/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.animation;

import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.event.AnimationEvent;
import net.ilexiconn.llibrary.server.network.AnimationMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;

public enum AnimationHandler {
    INSTANCE;


    public <T extends Entity> void sendAnimationMessage(T entity, Animation animation) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        ((IAnimatedEntity)entity).setAnimation(animation);
        for (EntityPlayer trackingPlayer : ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers(entity)) {
            LLibrary.NETWORK_WRAPPER.sendTo((IMessage)new AnimationMessage(entity.func_145782_y(), ArrayUtils.indexOf((Object[])((IAnimatedEntity)entity).getAnimations(), (Object)animation)), (EntityPlayerMP)trackingPlayer);
        }
    }

    public <T extends Entity> void updateAnimations(T entity) {
        if (((IAnimatedEntity)entity).getAnimation() == null) {
            ((IAnimatedEntity)entity).setAnimation(IAnimatedEntity.NO_ANIMATION);
        } else if (((IAnimatedEntity)entity).getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            AnimationEvent.Start<T> event;
            if (((IAnimatedEntity)entity).getAnimationTick() == 0 && !MinecraftForge.EVENT_BUS.post(event = new AnimationEvent.Start<T>(entity, ((IAnimatedEntity)entity).getAnimation()))) {
                this.sendAnimationMessage(entity, event.getAnimation());
            }
            if (((IAnimatedEntity)entity).getAnimationTick() < ((IAnimatedEntity)entity).getAnimation().getDuration()) {
                ((IAnimatedEntity)entity).setAnimationTick(((IAnimatedEntity)entity).getAnimationTick() + 1);
                MinecraftForge.EVENT_BUS.post(new AnimationEvent.Tick<T>(entity, ((IAnimatedEntity)entity).getAnimation(), ((IAnimatedEntity)entity).getAnimationTick()));
            }
            if (((IAnimatedEntity)entity).getAnimationTick() == ((IAnimatedEntity)entity).getAnimation().getDuration()) {
                ((IAnimatedEntity)entity).setAnimationTick(0);
                ((IAnimatedEntity)entity).setAnimation(IAnimatedEntity.NO_ANIMATION);
            }
        }
    }
}

