/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class MapGenDragonDens
extends MapGenBase {
    protected static final IBlockState BLK_LAVA = Blocks.field_150353_l.func_176223_P();
    protected static final IBlockState BLK_AIR = Blocks.field_150350_a.func_176223_P();

    protected void addRoom(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double d0, double d1, double d2) {
        float width = 3.0f + this.field_75038_b.nextFloat() * 6.0f;
        this.addTunnel(seed, chunkX, chunkZ, primer, d0, d1, d2, width, 0.0f, 0.0f, -1, -1, 0.75);
        this.addTunnelDecoration(seed, chunkX, chunkZ, primer, d0, d1, d2, width, 0.0f, 0.0f, -1, -1, 0.75);
    }

    protected void addTunnel(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double x, double y, double z, float width, float zero, float negitive0, int negitive1, int chance, double size) {
        boolean flag;
        double d0 = chunkX * 16 + 8;
        double d1 = chunkZ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(seed);
        if (chance <= 0) {
            int i = this.field_75040_a * 16 - 16;
            chance = i - random.nextInt(i / 4);
        }
        boolean flag2 = false;
        if (negitive1 == -1) {
            negitive1 = chance / 2;
            flag2 = true;
        }
        int j = random.nextInt(chance / 2) + chance / 4;
        boolean bl = flag = random.nextInt(6) == 0;
        while (negitive1 < chance) {
            double d2 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)negitive1 * (float)Math.PI / (float)chance)) * width);
            double d3 = d2 * size;
            float f2 = MathHelper.func_76134_b((float)negitive0);
            float f3 = MathHelper.func_76126_a((float)negitive0);
            x += (double)(MathHelper.func_76134_b((float)zero) * f2);
            y += (double)f3;
            z += (double)(MathHelper.func_76126_a((float)zero) * f2);
            negitive0 = flag ? (negitive0 *= 0.92f) : (negitive0 *= 0.7f);
            negitive0 += f1 * 0.1f;
            zero += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag2 && negitive1 == j && width > 1.0f && chance > 0) {
                this.addTunnel(random.nextLong(), chunkX, chunkZ, primer, x, y, z, random.nextFloat() * 0.5f + 0.5f, zero - 1.5707964f, negitive0 / 3.0f, negitive1, chance, 1.0);
                this.addTunnel(random.nextLong(), chunkX, chunkZ, primer, x, y, z, random.nextFloat() * 0.5f + 0.5f, zero + 1.5707964f, negitive0 / 3.0f, negitive1, chance, 1.0);
                return;
            }
            if (flag2 || random.nextInt(4) != 0) {
                double d4 = x - d0;
                double d5 = z - d1;
                double d6 = chance - negitive1;
                double d7 = width + 2.0f + 16.0f;
                if (d4 * d4 + d5 * d5 - d6 * d6 > d7 * d7) {
                    return;
                }
                if (x >= d0 - 16.0 - d2 * 2.0 && z >= d1 - 16.0 - d2 * 2.0 && x <= d0 + 16.0 + d2 * 2.0 && z <= d1 + 16.0 + d2 * 2.0) {
                    int k2 = MathHelper.floor_double((double)(x - d2)) - chunkX * 16 - 1;
                    int k = MathHelper.floor_double((double)(x + d2)) - chunkX * 16 + 1;
                    int l2 = MathHelper.floor_double((double)(y - d3)) - 1;
                    int l = MathHelper.floor_double((double)(y + d3)) + 1;
                    int i3 = MathHelper.floor_double((double)(z - d2)) - chunkZ * 16 - 1;
                    int i1 = MathHelper.floor_double((double)(z + d2)) - chunkZ * 16 + 1;
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if (k > 16) {
                        k = 16;
                    }
                    if (l2 < 1) {
                        l2 = 1;
                    }
                    if (l > 248) {
                        l = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i1 > 16) {
                        i1 = 16;
                    }
                    boolean flag3 = false;
                    for (int j1 = k2; !flag3 && j1 < k; ++j1) {
                        for (int k1 = i3; !flag3 && k1 < i1; ++k1) {
                            for (int l1 = l + 1; !flag3 && l1 >= l2 - 1; --l1) {
                                if (l1 < 0 || l1 >= 256) continue;
                                if (this.isOceanBlock(primer, j1, l1, k1, chunkX, chunkZ)) {
                                    flag3 = true;
                                }
                                if (l1 == l2 - 1 || j1 == k2 || j1 == k - 1 || k1 == i3 || k1 == i1 - 1) continue;
                                l1 = l2;
                            }
                        }
                    }
                    if (!flag3) {
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                        for (int j3 = k2; j3 < k; ++j3) {
                            double d10 = ((double)(j3 + chunkX * 16) + 0.5 - x) / d2;
                            for (int i2 = i3; i2 < i1; ++i2) {
                                double d8 = ((double)(i2 + chunkZ * 16) + 0.5 - z) / d2;
                                boolean flag1 = false;
                                if (!(d10 * d10 + d8 * d8 < 1.0)) continue;
                                for (int j2 = l; j2 > l2; --j2) {
                                    double d9 = ((double)(j2 - 1) + 0.5 - y) / d3;
                                    if (!(d9 > -0.7) || !(d10 * d10 + d9 * d9 + d8 * d8 < 1.0)) continue;
                                    IBlockState iblockstate1 = primer.func_177856_a(j3, j2, i2);
                                    IBlockState iblockstate2 = (IBlockState)Objects.firstNonNull((Object)primer.func_177856_a(j3, j2 + 1, i2), (Object)BLK_AIR);
                                    if (this.isTopBlock(primer, j3, j2, i2, chunkX, chunkZ)) {
                                        flag1 = true;
                                    }
                                    this.digBlock(primer, j3, j2, i2, chunkX, chunkZ, flag1, iblockstate1, iblockstate2);
                                }
                            }
                        }
                        if (flag2) break;
                    }
                }
            }
            ++negitive1;
        }
    }

    protected void addTunnelDecoration(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double x, double y, double z, float width, float zero, float negitive0, int negitive1, int chance, double size) {
        boolean flag;
        double d0 = chunkX * 16 + 8;
        double d1 = chunkZ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(seed);
        if (chance <= 0) {
            int i = this.field_75040_a * 16 - 16;
            chance = i - random.nextInt(i / 4);
        }
        boolean flag2 = false;
        if (negitive1 == -1) {
            negitive1 = chance / 2;
            flag2 = true;
        }
        int j = random.nextInt(chance / 2) + chance / 4;
        boolean bl = flag = random.nextInt(6) == 0;
        while (negitive1 < chance) {
            double d2 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)negitive1 * (float)Math.PI / (float)chance)) * width);
            double d3 = d2 * size;
            float f2 = MathHelper.func_76134_b((float)negitive0);
            float f3 = MathHelper.func_76126_a((float)negitive0);
            x += (double)(MathHelper.func_76134_b((float)zero) * f2);
            y += (double)f3;
            z += (double)(MathHelper.func_76126_a((float)zero) * f2);
            negitive0 = flag ? (negitive0 *= 0.92f) : (negitive0 *= 0.7f);
            negitive0 += f1 * 0.1f;
            zero += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag2 && negitive1 == j && width > 1.0f && chance > 0) {
                this.addTunnel(random.nextLong(), chunkX, chunkZ, primer, x, y, z, random.nextFloat() * 0.5f + 0.5f, zero - 1.5707964f, negitive0 / 3.0f, negitive1, chance, 1.0);
                this.addTunnel(random.nextLong(), chunkX, chunkZ, primer, x, y, z, random.nextFloat() * 0.5f + 0.5f, zero + 1.5707964f, negitive0 / 3.0f, negitive1, chance, 1.0);
                return;
            }
            if (flag2 || random.nextInt(4) != 0) {
                double d4 = x - d0;
                double d5 = z - d1;
                double d6 = chance - negitive1;
                double d7 = width + 2.0f + 16.0f;
                if (d4 * d4 + d5 * d5 - d6 * d6 > d7 * d7) {
                    return;
                }
                if (x >= d0 - 16.0 - d2 * 2.0 && z >= d1 - 16.0 - d2 * 2.0 && x <= d0 + 16.0 + d2 * 2.0 && z <= d1 + 16.0 + d2 * 2.0) {
                    int k2 = MathHelper.floor_double((double)(x - d2)) - chunkX * 16 - 1;
                    int k = MathHelper.floor_double((double)(x + d2)) - chunkX * 16 + 1;
                    int l2 = MathHelper.floor_double((double)(y - d3)) - 1;
                    int l = MathHelper.floor_double((double)(y + d3)) + 1;
                    int i3 = MathHelper.floor_double((double)(z - d2)) - chunkZ * 16 - 1;
                    int i1 = MathHelper.floor_double((double)(z + d2)) - chunkZ * 16 + 1;
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if (k > 16) {
                        k = 16;
                    }
                    if (l2 < 1) {
                        l2 = 1;
                    }
                    if (l > 248) {
                        l = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i1 > 16) {
                        i1 = 16;
                    }
                    boolean flag3 = false;
                    for (int j1 = k2; !flag3 && j1 < k; ++j1) {
                        for (int k1 = i3; !flag3 && k1 < i1; ++k1) {
                            for (int l1 = l + 1; !flag3 && l1 >= l2 - 1; --l1) {
                                if (l1 < 0 || l1 >= 256) continue;
                                if (this.isOceanBlock(primer, j1, l1, k1, chunkX, chunkZ)) {
                                    flag3 = true;
                                }
                                if (l1 == l2 - 1 || j1 == k2 || j1 == k - 1 || k1 == i3 || k1 == i1 - 1) continue;
                                l1 = l2;
                            }
                        }
                    }
                    if (!flag3) {
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                        for (int j3 = k2; j3 < k; ++j3) {
                            double d10 = ((double)(j3 + chunkX * 16) + 0.5 - x) / d2;
                            block5: for (int i2 = i3; i2 < i1; ++i2) {
                                double d8 = ((double)(i2 + chunkZ * 16) + 0.5 - z) / d2;
                                boolean flag1 = false;
                                if (!(d10 * d10 + d8 * d8 < 1.0)) continue;
                                for (int j2 = l; j2 > l2; --j2) {
                                    double d9 = ((double)(j2 - 1) + 0.5 - y) / d3;
                                    if (!(d9 > -0.7) || !(d10 * d10 + d9 * d9 + d8 * d8 < 1.0)) continue;
                                    IBlockState iblockstate1 = primer.func_177856_a(j3, j2, i2);
                                    IBlockState iblockstate2 = (IBlockState)Objects.firstNonNull((Object)primer.func_177856_a(j3, j2 + 1, i2), (Object)BLK_AIR);
                                    IBlockState iblockstate3 = primer.func_177856_a(j3, j2 - 1, i2);
                                    if (this.isTopBlock(primer, j3, j2, i2, chunkX, chunkZ)) {
                                        flag1 = true;
                                    }
                                    this.decorateBlock(primer, j3, j2, i2, chunkX, chunkZ, flag1, iblockstate3, iblockstate2);
                                    continue block5;
                                }
                            }
                        }
                        if (flag2) break;
                    }
                }
            }
            ++negitive1;
        }
    }

    protected boolean canReplaceBlock(IBlockState digBlock, IBlockState digBlock2) {
        return digBlock.func_177230_c() == Blocks.field_150348_b ? true : (digBlock.func_177230_c() == Blocks.field_150346_d ? true : (digBlock.func_177230_c() == Blocks.field_150349_c ? true : (digBlock.func_177230_c() == Blocks.field_150405_ch ? true : (digBlock.func_177230_c() == Blocks.field_150406_ce ? true : (digBlock.func_177230_c() == Blocks.field_150322_A ? true : (digBlock.func_177230_c() == Blocks.field_180395_cM ? true : (digBlock.func_177230_c() == Blocks.field_150391_bh ? true : (digBlock.func_177230_c() == Blocks.field_150431_aC ? true : (digBlock.func_177230_c() == Blocks.field_150354_m || digBlock.func_177230_c() == Blocks.field_150351_n) && digBlock2.func_185904_a() != Material.field_151586_h))))))));
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int x, int z, ChunkPrimer chunkPrimerIn) {
        int i = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(15) + 1) + 1);
        if (this.field_75038_b.nextInt(7) != 0) {
            i = 0;
        }
        for (int j = 0; j < i; ++j) {
            double d0 = chunkX * 16 + this.field_75038_b.nextInt(16);
            double d1 = this.field_75038_b.nextInt(this.field_75038_b.nextInt(120) + 8);
            double d2 = chunkZ * 16 + this.field_75038_b.nextInt(16);
            int k = 1;
            if (this.field_75038_b.nextInt(1) != 0) continue;
            this.addRoom(this.field_75038_b.nextLong(), x, z, chunkPrimerIn, d0, d1, d2);
            k += this.field_75038_b.nextInt(4);
        }
    }

    protected boolean isOceanBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        Block block = data.func_177856_a(x, y, z).func_177230_c();
        return block == Blocks.field_150358_i || block == Blocks.field_150355_j;
    }

    private boolean isExceptionBiome(Biome biome) {
        if (biome == Biomes.field_76787_r) {
            return true;
        }
        return biome == Biomes.field_76769_d;
    }

    private boolean isTopBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        Biome biome = this.worldObj.getBiomeGenForCoords(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState state = data.func_177856_a(x, y, z);
        return this.isExceptionBiome(biome) ? state.func_177230_c() == Blocks.field_150349_c : state.func_177230_c() == biome.field_76752_A;
    }

    protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, IBlockState state, IBlockState up) {
        Biome biome = this.worldObj.getBiomeGenForCoords(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState top = biome.field_76752_A;
        IBlockState filler = biome.field_76753_B;
        if (this.canReplaceBlock(state, up) || state.func_177230_c() == top.func_177230_c() || state.func_177230_c() == filler.func_177230_c()) {
            data.func_177855_a(x, y, z, BLK_AIR);
            if (ModBlocks.goldPile.func_176196_c(this.worldObj, new BlockPos(x, y, z))) {
                data.func_177855_a(x, y, z, ModBlocks.goldPile.func_176223_P());
            }
            if (foundTop && data.func_177856_a(x, y - 1, z).func_177230_c() == filler.func_177230_c()) {
                data.func_177855_a(x, y - 1, z, top.func_177230_c().func_176223_P());
            }
        }
    }

    protected void decorateBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundBottom, IBlockState down, IBlockState up) {
        Biome biome = this.worldObj.getBiomeGenForCoords(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState top = biome.field_76752_A;
        IBlockState filler = biome.field_76753_B;
        if (!down.func_185913_b() && ModBlocks.goldPile.func_176196_c(this.worldObj, new BlockPos(x, y, z))) {
            data.func_177855_a(x, y, z, ModBlocks.goldPile.func_176223_P());
        }
    }
}

