/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.structures.WorldGenFireDragonCave;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenFireDragonRoosts
extends WorldGenerator {
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int dragonAge = 50 + rand.nextInt(25);
        WorldGenFireDragonRoosts.burnGround(worldIn, rand, position, dragonAge / 5);
        this.generateStructures(worldIn, rand, position, dragonAge / 5);
        EntityFireDragon dragon = new EntityFireDragon(worldIn);
        dragon.setGender(dragon.func_70681_au().nextBoolean());
        dragon.growDragon(dragonAge);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(new Random().nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)worldIn.func_175645_m(position).func_177956_o() + 1.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.homeArea = position;
        dragon.setHunger(50);
        worldIn.func_72838_d((Entity)dragon);
        return true;
    }

    public static void burnGround(World world, Random rand, BlockPos position, int radius) {
        for (int i = 0; radius >= 0 && i < 3; ++i) {
            int j = radius + rand.nextInt(2);
            int k = radius + rand.nextInt(2);
            int l = radius + rand.nextInt(2);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
                IBlockState state = world.func_180495_p(blockpos);
                if (state.func_185904_a() == Material.field_151577_b) {
                    world.func_175656_a(blockpos, ModBlocks.charedGrass.func_176223_P());
                    continue;
                }
                if (state.func_185904_a() == Material.field_151578_c && state.func_177230_c() == Blocks.field_150346_d) {
                    world.func_175656_a(blockpos, ModBlocks.charedDirt.func_176223_P());
                    continue;
                }
                if (state.func_185904_a() == Material.field_151578_c && state.func_177230_c() == Blocks.field_150351_n) {
                    world.func_175656_a(blockpos, ModBlocks.charedGravel.func_176223_P());
                    continue;
                }
                if (state.func_185904_a() == Material.field_151576_e && (state.func_177230_c() == Blocks.field_150347_e || state.func_177230_c().func_149739_a().contains("cobblestone"))) {
                    world.func_175656_a(blockpos, ModBlocks.charedCobblestone.func_176223_P());
                    continue;
                }
                if (state.func_185904_a() == Material.field_151576_e) {
                    world.func_175656_a(blockpos, ModBlocks.charedStone.func_176223_P());
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_185774_da) {
                    world.func_175656_a(blockpos, ModBlocks.charedGrassPath.func_176223_P());
                    continue;
                }
                if (state.func_185904_a() == Material.field_151575_d) {
                    world.func_175656_a(blockpos, ModBlocks.ash.func_176223_P());
                    continue;
                }
                if (state.func_185904_a() != Material.field_151584_j && state.func_185904_a() != Material.field_151585_k) continue;
                world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public void generateStructures(World world, Random rand, BlockPos position, int radius) {
        for (int i = 0; radius >= 0 && i < 3; ++i) {
            int j = radius + rand.nextInt(2);
            int k = radius + rand.nextInt(2);
            int l = radius + rand.nextInt(2);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            block5: for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                int chance;
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || !world.func_175623_d(blockpos) || !world.func_180495_p(blockpos.func_177977_b()).func_177230_c().func_149739_a().contains("chared") || (chance = rand.nextInt(100)) >= 4) continue;
                int chance2 = rand.nextInt(20);
                switch (chance2) {
                    default: {
                        this.generateGoldPile(world, rand, blockpos);
                        continue block5;
                    }
                    case 1: {
                        this.generateArchNS(world, rand, blockpos);
                        continue block5;
                    }
                    case 2: 
                }
                this.generateArchEW(world, rand, blockpos);
            }
        }
    }

    public void generateGoldPile(World world, Random rand, BlockPos position) {
        int height = 1 + new Random().nextInt(7);
        int chance = rand.nextInt(100);
        if (chance < 20) {
            TileEntity tileentity1;
            world.func_180501_a(position, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[new Random().nextInt(3)]), 3);
            if (world.func_180495_p(position).func_177230_c() instanceof BlockChest && (tileentity1 = world.func_175625_s(position)) instanceof TileEntityChest && !((TileEntityChest)tileentity1).func_145837_r()) {
                ((TileEntityChest)tileentity1).func_189404_a(WorldGenFireDragonCave.FIREDRAGON_CHEST, new Random().nextLong());
            }
        } else {
            world.func_180501_a(position, ModBlocks.goldPile.func_176223_P().func_177226_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(height)), 3);
        }
    }

    public void generateArchNS(World world, Random rand, BlockPos position) {
        int height = 3 + rand.nextInt(1);
        int width = 1 + rand.nextInt(2);
        for (int sides = 0; sides < height; ++sides) {
            world.func_180501_a(position.func_177981_b(sides).func_177965_g(width / 2), ModBlocks.charedCobblestone.func_176223_P(), 3);
            world.func_180501_a(position.func_177981_b(sides).func_177985_f(width / 2), ModBlocks.charedCobblestone.func_176223_P(), 3);
        }
        for (int way = -1; way < width; ++way) {
            world.func_180501_a(position.func_177981_b(height).func_177965_g(way), ModBlocks.charedCobblestone.func_176223_P(), 3);
        }
    }

    public void generateArchEW(World world, Random rand, BlockPos position) {
        int height = 3 + rand.nextInt(1);
        int width = 1 + rand.nextInt(2);
        for (int sides = 0; sides < height; ++sides) {
            world.func_180501_a(position.func_177981_b(sides).func_177964_d(width / 2), ModBlocks.charedCobblestone.func_176223_P(), 3);
            world.func_180501_a(position.func_177981_b(sides).func_177970_e(width / 2), ModBlocks.charedCobblestone.func_176223_P(), 3);
        }
        for (int way = 0; way < width; ++way) {
            world.func_180501_a(position.func_177981_b(height).func_177970_e(way), ModBlocks.charedCobblestone.func_176223_P(), 3);
        }
    }
}

