/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.structures.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.structures.WorldGenFireDragonRoosts;
import com.github.alexthe666.iceandfire.structures.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.structures.WorldGenIceDragonRoosts;
import com.github.alexthe666.iceandfire.world.village.MapGenSnowVillage;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class StructureGenerator
implements IWorldGenerator {
    private static final WorldGenFireDragonCave FIRE_DRAGON_CAVE = new WorldGenFireDragonCave();
    private static final WorldGenFireDragonRoosts FIRE_DRAGON_ROOST = new WorldGenFireDragonRoosts();
    private static final WorldGenIceDragonCave ICE_DRAGON_CAVE = new WorldGenIceDragonCave();
    private static final WorldGenIceDragonRoosts ICE_DRAGON_ROOST = new WorldGenIceDragonRoosts();
    public static final MapGenSnowVillage SNOW_VILLAGE = new MapGenSnowVillage();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos surface;
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        BlockPos height = StructureGenerator.getHeight(world, new BlockPos(x, 0, z));
        if (IceAndFire.CONFIG.generateDragonSkeletons && BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && random.nextInt(IceAndFire.CONFIG.generateDragonSkeletonChance + 1) == 0) {
            EntityFireDragon firedragon = new EntityFireDragon(world);
            firedragon.func_70107_b(x, height.func_177956_o() + 1, z);
            int dragonage = 10 + random.nextInt(100);
            firedragon.growDragon(dragonage);
            firedragon.modelDeadProgress = 20.0f;
            firedragon.setModelDead(true);
            firedragon.setDeathStage(dragonage / 5 / 2);
            firedragon.field_70177_z = random.nextInt(360);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)firedragon);
            }
        }
        if (IceAndFire.CONFIG.generateDragonRoosts && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), true)) {
            boolean isHills;
            boolean bl = isHills = BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
            if ((!world.func_180494_b(height).func_76746_c() && (double)world.func_180494_b(height).func_185353_n() > -0.5 && world.func_180494_b(height) != Biomes.field_76774_n && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.WET) && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || isHills) && random.nextInt((isHills ? IceAndFire.CONFIG.generateDragonRoostChance : IceAndFire.CONFIG.generateDragonRoostChance * 2) + 1) == 0) {
                BlockPos surface2 = world.func_175645_m(new BlockPos(x, 0, z));
                FIRE_DRAGON_ROOST.func_180709_b(world, random, surface2);
            }
            if (BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && random.nextInt((isHills ? IceAndFire.CONFIG.generateDragonRoostChance : IceAndFire.CONFIG.generateDragonRoostChance * 2) + 1) == 0) {
                BlockPos surface3 = world.func_175645_m(new BlockPos(x, 0, z));
                ICE_DRAGON_ROOST.func_180709_b(world, random, surface3);
            }
        }
        if (IceAndFire.CONFIG.generateDragonDens && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), true)) {
            int newY;
            BlockPos pos;
            boolean isHills;
            boolean bl = isHills = BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
            if ((!world.func_180494_b(height).func_76746_c() && (double)world.func_180494_b(height).func_185353_n() > -0.5 && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.WET) && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || isHills) && random.nextInt((isHills ? IceAndFire.CONFIG.generateDragonDenChance : IceAndFire.CONFIG.generateDragonDenChance * 2) + 1) == 0 && !world.func_175710_j(pos = new BlockPos(x, newY = 20 + random.nextInt(20), z))) {
                FIRE_DRAGON_CAVE.func_180709_b(world, random, pos);
            }
            if (BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && random.nextInt((isHills ? IceAndFire.CONFIG.generateDragonDenChance : IceAndFire.CONFIG.generateDragonDenChance * 2) + 1) == 0) {
                newY = 20 + random.nextInt(20);
                pos = new BlockPos(x, newY, z);
                ICE_DRAGON_CAVE.func_180709_b(world, random, pos);
            }
        }
        if (IceAndFire.CONFIG.generateSilverOre) {
            for (int silverAmount = 0; silverAmount < 2; ++silverAmount) {
                int oreHeight = random.nextInt(32);
                int xOre = chunkX * 16 + random.nextInt(16);
                int zOre = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(ModBlocks.silverOre.func_176223_P(), 4 + random.nextInt(4)).func_180709_b(world, random, new BlockPos(xOre, oreHeight, zOre));
            }
        }
        if (IceAndFire.CONFIG.generateSapphireOre && BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            int count = 3 + random.nextInt(6);
            for (int sapphireAmount = 0; sapphireAmount < count; ++sapphireAmount) {
                int zOre;
                int oreHeight = random.nextInt(28) + 4;
                int xOre = chunkX * 16 + random.nextInt(16);
                BlockPos pos = new BlockPos(xOre, oreHeight, zOre = chunkZ * 16 + random.nextInt(16));
                IBlockState state = world.func_180495_p(pos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                world.func_175656_a(pos, ModBlocks.sapphireOre.func_176223_P());
            }
        }
        if (IceAndFire.CONFIG.generateSnowVillages && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            SNOW_VILLAGE.func_180709_b(world, random, height);
        }
        if (BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && random.nextInt(5) == 0 && ModBlocks.frost_lily.func_176196_c(world, surface = world.func_175645_m(new BlockPos(x, 0, z)))) {
            world.func_175656_a(surface, ModBlocks.frost_lily.func_176223_P());
        }
        if (BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && (BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) && random.nextInt(5) == 0 && ModBlocks.fire_lily.func_176196_c(world, height.func_177984_a())) {
            world.func_175656_a(height.func_177984_a(), ModBlocks.fire_lily.func_176223_P());
        }
    }

    public static BlockPos getHeight(World world, BlockPos pos) {
        for (int y = 0; y < 256; ++y) {
            BlockPos pos1 = pos.func_177981_b(y);
            if (world.func_180495_p(pos1.func_177984_a()).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(pos1.func_177977_b()).func_177230_c() == Blocks.field_150350_a) continue;
            return pos1;
        }
        return pos;
    }

    private boolean isDimensionBlacklisted(int id, boolean dragons) {
        int[] blacklistedArray = dragons ? IceAndFire.CONFIG.dragonBlacklistedDimensions : IceAndFire.CONFIG.snowVillageBlacklistedDimensions;
        ArrayList<Integer> dimList = new ArrayList<Integer>();
        for (int dimension : blacklistedArray) {
            dimList.add(dimension);
        }
        return dimList.contains(id);
    }
}

