/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModAchievements;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModKeys;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.RollBuffer;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.message.MessageDaytime;
import com.github.alexthe666.iceandfire.message.MessageDragonArmor;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.google.common.base.Predicate;
import fossilsarcheology.api.EnumDiet;
import fossilsarcheology.api.FoodMappings;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class EntityDragonBase
extends EntityTameable
implements IAnimatedEntity,
IInventoryChangedListener {
    public double minimumDamage;
    public double maximumDamage;
    public double minimumHealth;
    public double maximumHealth;
    public double minimumSpeed;
    public double maximumSpeed;
    public EnumDiet diet;
    private boolean isSleeping;
    public float sleepProgress;
    private boolean isSitting;
    private boolean isHovering;
    public float hoverProgress;
    private boolean isFlying;
    public float flyProgress;
    private boolean isBreathingFire;
    public float fireBreathProgress;
    private int fireTicks;
    public int fireStopTicks;
    private int hoverTicks;
    public int flyTicks;
    private boolean isModelDead;
    public float modelDeadProgress;
    public float ridingProgress;
    private static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> AGE_TICKS = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FIREBREATHING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HOVERING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> HEAD_ARMOR = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> NECK_ARMOR = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BODY_ARMOR = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TAIL_ARMOR = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> MODEL_DEAD = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DEATH_STAGE = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187191_a);
    public AnimalChest dragonInv;
    private int animationTick;
    private Animation currentAnimation;
    public boolean isDaytime;
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_BITE;
    public static Animation ANIMATION_SHAKEPREY;
    public boolean attackDecision;
    public int animationCycle;
    public BlockPos airTarget;
    public BlockPos homeArea;
    protected int flyHovering;
    @SideOnly(value=Side.CLIENT)
    public RollBuffer roll_buffer;
    public int spacebarTicks;
    public int spacebarTickCounter;
    public float[][] growth_stages;
    public boolean isFire = this instanceof EntityFireDragon;
    private IItemHandler itemHandler = null;

    public EntityDragonBase(World world, EnumDiet diet, double minimumDamage, double maximumDamage, double minimumHealth, double maximumHealth, double minimumSpeed, double maximumSpeed) {
        super(world);
        this.diet = diet;
        this.minimumDamage = minimumDamage;
        this.maximumDamage = maximumDamage;
        this.minimumHealth = minimumHealth;
        this.maximumHealth = maximumHealth;
        this.minimumSpeed = minimumSpeed;
        this.maximumSpeed = maximumSpeed;
        ANIMATION_EAT = Animation.create((int)20);
        this.updateAttributes();
        this.initDragonInv();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.roll_buffer = new RollBuffer();
        }
    }

    private void initDragonInv() {
        AnimalChest animalchest = this.dragonInv;
        this.dragonInv = new AnimalChest("dragonInv", 4);
        this.dragonInv.func_110133_a(this.func_70005_c_());
        if (animalchest != null) {
            animalchest.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(animalchest.func_70302_i_(), this.dragonInv.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack == null) continue;
                this.dragonInv.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.dragonInv.func_110134_a((IInventoryChangedListener)this);
        this.itemHandler = new InvWrapper((IInventory)this.dragonInv);
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), 0, this.getIntFromArmor(this.dragonInv.func_70301_a(0))));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), 1, this.getIntFromArmor(this.dragonInv.func_70301_a(1))));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), 2, this.getIntFromArmor(this.dragonInv.func_70301_a(2))));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), 3, this.getIntFromArmor(this.dragonInv.func_70301_a(3))));
        }
    }

    private void updateDragonSlots() {
        if (!this.field_70170_p.field_72995_K) {
            this.setArmorInSlot(0, this.getIntFromArmor(this.dragonInv.func_70301_a(0)));
            this.setArmorInSlot(1, this.getIntFromArmor(this.dragonInv.func_70301_a(1)));
            this.setArmorInSlot(2, this.getIntFromArmor(this.dragonInv.func_70301_a(2)));
            this.setArmorInSlot(3, this.getIntFromArmor(this.dragonInv.func_70301_a(3)));
        }
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            playerEntity.openGui((Object)IceAndFire.INSTANCE, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    protected void func_70609_aI() {
        this.field_70725_aQ = 0;
        this.setModelDead(true);
        if (this.getDeathStage() >= this.getAgeInDays() / 5) {
            double d1;
            double d0;
            int k;
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            for (k = 0; k < 40; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (!this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
            for (k = 0; k < 3; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.isFire) {
                    if (!this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
                    continue;
                }
                IceAndFire.PROXY.spawnParticle("snowflake", this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
            }
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        return 5 + this.field_70170_p.field_73012_v.nextInt(this.getDragonStage() / 2);
    }

    public int getIntFromArmor(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.dragon_armor_iron) {
            return 1;
        }
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.dragon_armor_gold) {
            return 2;
        }
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.dragon_armor_diamond) {
            return 3;
        }
        return 0;
    }

    public boolean func_175446_cd() {
        return this.isModelDead();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HUNGER, (Object)0);
        this.field_70180_af.func_187214_a(AGE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(GENDER, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(FIREBREATHING, (Object)false);
        this.field_70180_af.func_187214_a(HOVERING, (Object)false);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(HEAD_ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(NECK_ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(BODY_ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(TAIL_ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(DEATH_STAGE, (Object)0);
        this.field_70180_af.func_187214_a(MODEL_DEAD, (Object)false);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
    }

    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    public boolean down() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean strike() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public boolean dismount() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 4 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public void strike(boolean strike) {
        this.setStateField(3, strike);
    }

    public void dismount(boolean dismount) {
        this.setStateField(4, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Hunger", this.getHunger());
        compound.func_74768_a("AgeTicks", this.getAgeInTicks());
        compound.func_74757_a("Gender", this.isMale());
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Sleeping", this.isSleeping());
        compound.func_74757_a("FireBreathing", this.isBreathingFire());
        compound.func_74757_a("AttackDecision", this.attackDecision);
        compound.func_74757_a("Hovering", this.isHovering());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74757_a("Sitting", this.func_70906_o());
        compound.func_74768_a("ArmorHead", this.getArmorInSlot(0));
        compound.func_74768_a("ArmorNeck", this.getArmorInSlot(1));
        compound.func_74768_a("ArmorBody", this.getArmorInSlot(2));
        compound.func_74768_a("ArmorTail", this.getArmorInSlot(3));
        compound.func_74768_a("DeathStage", this.getDeathStage());
        compound.func_74757_a("ModelDead", this.isModelDead());
        compound.func_74776_a("DeadProg", this.modelDeadProgress);
        if (this.dragonInv != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.dragonInv.func_70302_i_(); ++i) {
                ItemStack itemstack = this.dragonInv.func_70301_a(i);
                if (itemstack == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.func_95999_t() != null && !this.func_95999_t().isEmpty()) {
            compound.func_74778_a("CustomName", this.func_95999_t());
        }
        if (this.homeArea != null) {
            compound.func_74768_a("HomeAreaX", this.homeArea.func_177958_n());
            compound.func_74768_a("HomeAreaY", this.homeArea.func_177956_o());
            compound.func_74768_a("HomeAreaZ", this.homeArea.func_177952_p());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHunger(compound.func_74762_e("Hunger"));
        this.setAgeInTicks(compound.func_74762_e("AgeTicks"));
        this.setGender(compound.func_74767_n("Gender"));
        this.setVariant(compound.func_74762_e("Variant"));
        this.setSleeping(compound.func_74767_n("Sleeping"));
        this.func_70904_g(compound.func_74767_n("Sitting"));
        this.setBreathingFire(compound.func_74767_n("FireBreathing"));
        this.attackDecision = compound.func_74767_n("AttackDecision");
        this.setHovering(compound.func_74767_n("Hovering"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.setArmorInSlot(0, compound.func_74762_e("ArmorHead"));
        this.setArmorInSlot(1, compound.func_74762_e("ArmorNeck"));
        this.setArmorInSlot(2, compound.func_74762_e("ArmorBody"));
        this.setArmorInSlot(3, compound.func_74762_e("ArmorTail"));
        if (this.dragonInv != null) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initDragonInv();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j > 4) continue;
                this.dragonInv.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
            }
        } else {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initDragonInv();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.initDragonInv();
                this.dragonInv.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
                if (!this.field_70170_p.field_72995_K) continue;
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), 0, this.getIntFromArmor(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound))));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), 1, this.getIntFromArmor(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound))));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), 2, this.getIntFromArmor(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound))));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), 3, this.getIntFromArmor(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound))));
            }
        }
        this.setDeathStage(compound.func_74762_e("DeathStage"));
        this.setModelDead(compound.func_74767_n("ModelDead"));
        this.modelDeadProgress = compound.func_74760_g("DeadProg");
        if (!compound.func_74779_i("CustomName").isEmpty()) {
            this.func_96094_a(compound.func_74779_i("CustomName"));
        }
        if (compound.func_74762_e("HomeAreaX") != 0 && compound.func_74762_e("HomeAreaY") != 0 && compound.func_74762_e("HomeAreaZ") != 0) {
            this.homeArea = new BlockPos(compound.func_74762_e("HomeAreaX"), compound.func_74762_e("HomeAreaY"), compound.func_74762_e("HomeAreaZ"));
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityPlayer) || this.func_70638_az() == passenger) continue;
            EntityPlayer player = (EntityPlayer)passenger;
            if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    public boolean isRidingPlayer(EntityPlayer player) {
        return this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer && this.func_184179_bs().func_110124_au().equals(player.func_110124_au());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    private void updateAttributes() {
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        double attackStep = (this.maximumDamage - this.minimumDamage) / 125.0;
        double speedStep = (this.maximumSpeed - this.minimumSpeed) / 125.0;
        if (this.getAgeInDays() <= 125) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(this.minimumHealth + healthStep * (double)this.getAgeInDays()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(this.minimumDamage + attackStep * (double)this.getAgeInDays()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.minimumSpeed + speedStep * (double)this.getAgeInDays());
        }
    }

    public int getHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)Math.min(100, hunger));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getAgeInDays() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TICKS) / 24000;
    }

    public void setAgeInDays(int age) {
        this.field_70180_af.func_187227_b(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.field_70180_af.func_187227_b(AGE_TICKS, (Object)age);
    }

    public int getDeathStage() {
        return (Integer)this.field_70180_af.func_187225_a(DEATH_STAGE);
    }

    public void setDeathStage(int stage) {
        this.field_70180_af.func_187227_b(DEATH_STAGE, (Object)stage);
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(GENDER);
    }

    public boolean isModelDead() {
        if (this.field_70170_p.field_72995_K) {
            this.isModelDead = (Boolean)this.field_70180_af.func_187225_a(MODEL_DEAD);
            return this.isModelDead;
        }
        return this.isModelDead;
    }

    public boolean isHovering() {
        if (this.field_70170_p.field_72995_K) {
            this.isHovering = (Boolean)this.field_70180_af.func_187225_a(HOVERING);
            return this.isHovering;
        }
        return this.isHovering;
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setGender(boolean male) {
        this.field_70180_af.func_187227_b(GENDER, (Object)male);
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
        if (!this.field_70170_p.field_72995_K) {
            this.isSleeping = sleeping;
        }
    }

    public void setModelDead(boolean modeldead) {
        this.field_70180_af.func_187227_b(MODEL_DEAD, (Object)modeldead);
        if (!this.field_70170_p.field_72995_K) {
            this.isModelDead = modeldead;
        }
    }

    public void setHovering(boolean hovering) {
        this.field_70180_af.func_187227_b(HOVERING, (Object)hovering);
        if (!this.field_70170_p.field_72995_K) {
            this.isHovering = hovering;
        }
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public boolean isSleeping() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSleeping;
            this.isSleeping = isSleeping = ((Boolean)this.field_70180_af.func_187225_a(SLEEPING)).booleanValue();
            return isSleeping;
        }
        return this.isSleeping;
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    public void setBreathingFire(boolean breathing) {
        this.field_70180_af.func_187227_b(FIREBREATHING, (Object)breathing);
        if (!this.field_70170_p.field_72995_K) {
            this.isBreathingFire = breathing;
        }
    }

    public boolean isBreathingFire() {
        if (this.field_70170_p.field_72995_K) {
            boolean breathing;
            this.isBreathingFire = breathing = ((Boolean)this.field_70180_af.func_187225_a(FIREBREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathingFire;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        super.func_70904_g(sitting);
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
    }

    public int getArmorInSlot(int i) {
        switch (i) {
            default: {
                return (Integer)this.field_70180_af.func_187225_a(HEAD_ARMOR);
            }
            case 1: {
                return (Integer)this.field_70180_af.func_187225_a(NECK_ARMOR);
            }
            case 2: {
                return (Integer)this.field_70180_af.func_187225_a(BODY_ARMOR);
            }
            case 3: 
        }
        return (Integer)this.field_70180_af.func_187225_a(TAIL_ARMOR);
    }

    public void riderShootFire(Entity controller) {
    }

    public void setArmorInSlot(int i, int armorType) {
        switch (i) {
            case 0: {
                this.field_70180_af.func_187227_b(HEAD_ARMOR, (Object)armorType);
                break;
            }
            case 1: {
                this.field_70180_af.func_187227_b(NECK_ARMOR, (Object)armorType);
                break;
            }
            case 2: {
                this.field_70180_af.func_187227_b(BODY_ARMOR, (Object)armorType);
                break;
            }
            case 3: {
                this.field_70180_af.func_187227_b(TAIL_ARMOR, (Object)armorType);
            }
        }
    }

    public boolean canMove() {
        return !this.func_70906_o() && !this.isSleeping() && this.func_184179_bs() == null && !this.isModelDead() && this.sleepProgress == 0.0f;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        int lastDeathStage = this.getAgeInDays() / 5;
        if (this.isModelDead() && this.getDeathStage() < lastDeathStage) {
            player.func_71064_a((StatBase)ModAchievements.dragonHarvest, 1);
            if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() == Items.field_151069_bo && this.getDeathStage() > lastDeathStage / 2) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                this.setDeathStage(this.getDeathStage() + 1);
                player.field_71071_by.func_70441_a(new ItemStack(this instanceof EntityFireDragon ? ModItems.fire_dragon_blood : ModItems.ice_dragon_blood, 1));
                return true;
            }
            if (this.getDeathStage() == lastDeathStage - 1) {
                ItemStack skull = new ItemStack(ModItems.dragon_skull, 1, this.isFire ? 0 : 1);
                skull.func_77982_d(new NBTTagCompound());
                skull.func_77978_p().func_74768_a("Stage", this.getDragonStage());
                skull.func_77978_p().func_74768_a("DragonType", 0);
                skull.func_77978_p().func_74768_a("DragonAge", this.getAgeInDays());
                this.setDeathStage(this.getDeathStage() + 1);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(skull, 1.0f);
                }
                this.func_70106_y();
            } else if (this.getDeathStage() == lastDeathStage / 2 - 1) {
                ItemStack heart = new ItemStack(this instanceof EntityFireDragon ? ModItems.fire_dragon_heart : ModItems.ice_dragon_heart, 1);
                ItemStack egg = new ItemStack(this.getVariantEgg(this.field_70146_Z.nextInt(3)), 1);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(heart, 1.0f);
                    if (!this.isMale() && this.getDragonStage() > 3) {
                        this.func_70099_a(egg, 1.0f);
                    }
                }
                this.setDeathStage(this.getDeathStage() + 1);
            } else {
                this.setDeathStage(this.getDeathStage() + 1);
                ItemStack drop = this.getRandomDrop();
                if (drop != null && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(drop, 1.0f);
                }
            }
            return true;
        }
        if (!this.isModelDead() && this.func_152114_e((EntityLivingBase)player)) {
            if (stack != null) {
                if (this.func_70877_b(stack) && this.isAdult() && !this.func_70880_s()) {
                    this.func_175505_a(player, stack);
                    this.func_146082_f(player);
                    return true;
                }
                if (stack.func_77973_b() != null) {
                    int itemFoodAmount = FoodMappings.INSTANCE.getItemFoodAmount(stack.func_77973_b(), this.diet);
                    if (itemFoodAmount > 0) {
                        this.setHunger(this.getHunger() + itemFoodAmount);
                        this.func_70606_j(Math.min(this.func_110138_aP(), (float)((int)(this.func_110143_aJ() + (float)(itemFoodAmount / 10)))));
                        this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                        this.spawnItemCrackParticles(stack.func_77973_b());
                        this.eatFoodBonus(stack);
                        if (!player.func_184812_l_()) {
                            --stack.field_77994_a;
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == ModItems.dragon_meal) {
                        this.growDragon(1);
                        this.setHunger(this.getHunger() + 20);
                        this.func_70606_j(Math.min(this.func_110138_aP(), (float)((int)(this.func_110138_aP() / 3.0f))));
                        this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                        this.spawnItemCrackParticles(stack.func_77973_b());
                        this.spawnItemCrackParticles(Items.field_151103_aS);
                        this.spawnItemCrackParticles(Items.field_151100_aR);
                        this.eatFoodBonus(stack);
                        if (!player.func_184812_l_()) {
                            --stack.field_77994_a;
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == ModItems.dragon_stick) {
                        this.func_184185_a(SoundEvents.field_187945_hs, this.func_70599_aP(), this.func_70647_i());
                        this.func_70904_g(!this.func_70906_o());
                        if (this.field_70170_p.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("dragon.command." + (this.func_70906_o() ? "sit" : "stand"), new Object[0]));
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == ModItems.dragon_horn) {
                        this.func_184185_a(SoundEvents.field_187941_ho, 3.0f, 1.25f);
                        ItemStack stack1 = new ItemStack(this.isFire ? ModItems.dragon_horn_fire : ModItems.dragon_horn_ice);
                        stack1.func_77982_d(new NBTTagCompound());
                        this.func_70014_b(stack1.func_77978_p());
                        player.func_184611_a(hand, stack1);
                        this.func_70106_y();
                        return true;
                    }
                }
            } else {
                if (player.func_70093_af()) {
                    if (this.getDragonStage() > 2) {
                        player.func_70095_a(false);
                        player.func_184205_a((Entity)this, true);
                        player.func_71064_a((StatBase)ModAchievements.dragonRide, 1);
                        this.setSleeping(false);
                    } else if (this.func_184218_aH()) {
                        this.func_184210_p();
                    } else if (this.getDragonStage() < 2) {
                        this.func_184205_a((Entity)player, true);
                    }
                    return true;
                }
                if (stack == null && !player.func_70093_af()) {
                    this.openGUI(player);
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand, stack);
    }

    private ItemStack getRandomDrop() {
        Item flesh;
        int chance = this.field_70146_Z.nextInt(99) + 1;
        Item item = flesh = this.isFire ? ModItems.fire_dragon_flesh : ModItems.ice_dragon_flesh;
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            this.func_184185_a(SoundEvents.field_187854_fc, 1.0f, 1.0f);
            return new ItemStack(ModItems.dragonbone, 1 + this.field_70146_Z.nextInt(1 + this.getAgeInDays() / 25));
        }
        this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
        if (chance >= 0 && chance < 40) {
            return new ItemStack(flesh, 1 + this.field_70146_Z.nextInt(1 + this.getAgeInDays() / 25));
        }
        if (chance >= 40 && chance < 100) {
            return new ItemStack(this.getVariantScale(this.getVariant()), 1 + this.field_70146_Z.nextInt(1 + this.getAgeInDays() / 5));
        }
        return null;
    }

    public void eatFoodBonus(ItemStack stack) {
    }

    public void growDragon(int ageInDays) {
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.func_98054_a(false);
        if (this.getAgeInDays() % 25 == 0) {
            int i = 0;
            while ((float)i < this.getRenderSize() * 4.0f) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float f = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) + this.func_174813_aQ().field_72340_a);
                float f1 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) + this.func_174813_aQ().field_72338_b);
                float f2 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) + this.func_174813_aQ().field_72339_c);
                if (this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ, new int[0]);
                }
                ++i;
            }
        }
        this.updateAttributes();
    }

    public void spawnItemCrackParticles(Item item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.func_70681_au().nextGaussian() * 0.07;
            double motionY = this.func_70681_au().nextGaussian() * 0.07;
            double motionZ = this.func_70681_au().nextGaussian() * 0.07;
            float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
            float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
            float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
            if (!this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)headPosX, (double)headPosZ, (double)headPosY, motionX, motionY, motionZ, new int[]{Item.func_150891_b((Item)item)});
        }
    }

    public boolean isDaytime() {
        if (!this.field_70148_d && this.field_70170_p != null) {
            if (this.field_70170_p.field_72995_K) {
                return this.isDaytime;
            }
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageDaytime(this.func_145782_y(), this.field_70170_p.func_72935_r()));
            return this.field_70170_p.func_72935_r();
        }
        return true;
    }

    public void func_70636_d() {
        boolean riding;
        boolean flying;
        boolean sleeping;
        super.func_70636_d();
        if (this.isFlying() && this.field_70173_aa % 40 == 0 || this.isFlying() && this.isSleeping()) {
            this.setFlying(false);
            this.setFlying(true);
            this.setSleeping(false);
        }
        if (!this.canMove() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (!this.canMove()) {
            this.func_70661_as().func_75499_g();
        }
        if (this.func_184179_bs() != null) {
            if (this.field_70181_x > 0.5) {
                this.field_70181_x = 0.5;
            }
            if (this.field_70181_x < -0.5) {
                this.field_70181_x = -0.5;
            }
        } else {
            if (this.field_70181_x > 0.8) {
                this.field_70181_x = 0.5;
            }
            if (this.field_70181_x < -0.8) {
                this.field_70181_x = -0.8;
            }
            if (this.field_70181_x > 1.0) {
                this.field_70181_x = 0.0;
            }
        }
        this.updateCheckPlayer();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        if ((this.isFlying() || this.isHovering()) && !this.isModelDead()) {
            this.animationCycle = this.animationCycle < 15 ? ++this.animationCycle : 0;
            if (this.animationCycle == 12) {
                this.func_184185_a(SoundEvents.field_187524_aN, 10.0f * this.func_70599_aP(), 0.4f + this.field_70146_Z.nextFloat() * 0.3f * this.func_70647_i());
            }
            if (this.animationCycle > 12 && this.animationCycle < 15) {
                int i = 0;
                while ((float)i < this.getRenderSize()) {
                    for (int i1 = 0; i1 < 20; ++i1) {
                        double motionX = this.func_70681_au().nextGaussian() * 0.07;
                        double motionY = this.func_70681_au().nextGaussian() * 0.07;
                        double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                        float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
                        float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                        double extraZ = radius * MathHelper.func_76134_b((float)angle);
                        double extraY = 0.8f;
                        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + extraX)), MathHelper.func_76128_c((double)(this.field_70163_u + extraY)) - 1, MathHelper.func_76128_c((double)(this.field_70161_v + extraZ))));
                        if (iblockstate.func_185904_a() == Material.field_151579_a || !this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_175682_a(EnumParticleTypes.BLOCK_CRACK, true, this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
                    }
                    ++i;
                }
            }
        }
        if (this.isModelDead() && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
        if (this.isModelDead() && this.animationCycle != 0) {
            this.animationCycle = 0;
        }
        boolean bl = sleeping = this.isSleeping() && !this.isHovering() && !this.isFlying();
        if (sleeping && this.sleepProgress < 20.0f) {
            this.sleepProgress += 0.5f;
        } else if (!sleeping && this.sleepProgress > 0.0f) {
            this.sleepProgress -= 0.5f;
        }
        boolean fireBreathing = this.isBreathingFire();
        if (fireBreathing && this.fireBreathProgress < 20.0f) {
            this.fireBreathProgress += 0.5f;
        } else if (!fireBreathing && this.fireBreathProgress > 0.0f) {
            this.fireBreathProgress -= 0.5f;
        }
        boolean hovering = this.isHovering();
        if (hovering && this.hoverProgress < 20.0f) {
            this.hoverProgress += 0.5f;
        } else if (!hovering && this.hoverProgress > 0.0f) {
            this.hoverProgress -= 0.5f;
        }
        boolean bl2 = flying = this.isFlying() || !this.field_70122_E && !this.isHovering() && this.airTarget != null;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 0.5f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 0.5f;
        }
        boolean modeldead = this.isModelDead();
        if (modeldead && this.modelDeadProgress < 20.0f) {
            this.modelDeadProgress += 0.5f;
        } else if (!modeldead && this.modelDeadProgress > 0.0f) {
            this.modelDeadProgress -= 0.5f;
        }
        boolean bl3 = riding = this.func_184218_aH() && this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer;
        if (riding && this.ridingProgress < 20.0f) {
            this.ridingProgress += 0.5f;
        } else if (!riding && this.ridingProgress > 0.0f) {
            this.ridingProgress -= 0.5f;
        }
        if (this.isModelDead()) {
            return;
        }
        if (this.field_70122_E && this.doesWantToLand() && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
        if (this.func_184179_bs() != null && !this.field_70122_E && (this.isFlying() || this.isHovering())) {
            this.field_70181_x *= 0.0;
        }
        if (this.isHovering()) {
            if (this.isSleeping()) {
                this.setHovering(false);
            }
            ++this.hoverTicks;
            if (this.doesWantToLand()) {
                this.field_70181_x -= 0.25;
            } else {
                if (this.func_184179_bs() == null) {
                    this.field_70181_x += 0.08;
                }
                if (this.hoverTicks > 40) {
                    if (!this.func_70631_g_()) {
                        this.setFlying(true);
                    }
                    this.setHovering(false);
                    this.flyHovering = 0;
                    this.hoverTicks = 0;
                    this.flyTicks = 0;
                }
            }
            if (this.flyHovering == 0) {
                // empty if block
            }
            if (this.flyHovering == 1) {
                // empty if block
            }
            if (this.flyHovering == 2) {
                // empty if block
            }
        }
        if (this.isSleeping()) {
            this.func_70661_as().func_75499_g();
        }
        if (!this.isFlying() && !this.isHovering() && this.airTarget != null && this.field_70122_E) {
            this.airTarget = null;
        }
        if (this.isFlying() && this.airTarget == null && this.field_70122_E && this.func_184179_bs() == null) {
            this.setFlying(false);
        }
        if (this.isFlying() && this.func_70638_az() == null) {
            this.flyAround();
        } else if (this.func_70638_az() != null) {
            this.flyTowardsTarget();
        }
        if (this.field_70122_E && this.flyTicks != 0) {
            this.flyTicks = 0;
        }
        if (this.isFlying() && this.doesWantToLand()) {
            this.setFlying(false);
            this.setHovering(!this.field_70122_E);
            if (this.field_70122_E) {
                this.flyTicks = 0;
                this.setFlying(false);
            }
        }
        if (this.isFlying()) {
            ++this.flyTicks;
        }
        if ((this.isHovering() || this.isFlying()) && this.isSleeping()) {
            this.setFlying(false);
            this.setHovering(false);
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70681_au().nextInt(1250) != 0 || this.func_70906_o() || this.isFlying() || !this.func_184188_bt().isEmpty() || this.func_70631_g_() || this.isHovering() || this.isSleeping() || !this.canMove() || !this.field_70122_E)) {
            this.setHovering(true);
            this.setSleeping(false);
            this.func_70904_g(false);
            this.flyHovering = 0;
            this.hoverTicks = 0;
            this.flyTicks = 0;
        }
        if (this.func_70638_az() != null && !this.func_184188_bt().isEmpty() && this.func_70902_q() != null && this.func_184188_bt().contains(this.func_70902_q())) {
            this.func_70624_b(null);
        }
        this.setAgeInTicks(this.getAgeInTicks() + 1);
        if (this.getAgeInTicks() % 24000 == 0) {
            this.updateAttributes();
            this.func_98055_j(this.getRenderSize());
        }
        if (this.getAgeInTicks() % 1200 == 0 && this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
        if (!(this.attackDecision && this.func_70681_au().nextInt(750) != 0 || this.getDragonStage() >= 2)) {
            this.attackDecision = true;
            for (int i = 0; i < 5; ++i) {
                float radiusAdd = (float)i * 0.15f;
                float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd)) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd)) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                if (this.isFire && this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0, new int[0]);
                    continue;
                }
                if (!this.field_70170_p.field_72995_K) continue;
                IceAndFire.PROXY.spawnParticle("snowflake", this.field_70170_p, headPosX, headPosY, headPosZ, 0.0, 0.0, 0.0);
            }
            if (this.isFire) {
                this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187618_I, 1.0f, 1.0f);
            }
        }
        if (this.isBreathingFire()) {
            ++this.fireTicks;
            if (this.fireTicks > this.getDragonStage() * 12 || this.func_70902_q() != null && this.func_184188_bt().contains(this.func_70902_q()) && this.fireStopTicks <= 0) {
                this.setBreathingFire(false);
                this.attackDecision = true;
                this.fireTicks = 0;
            }
            if (this.fireStopTicks > 0 && this.func_70902_q() != null && this.func_184188_bt().contains(this.func_70902_q())) {
                --this.fireStopTicks;
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean isActuallyBreathingFire() {
        return this.fireTicks > 20 && this.isBreathingFire();
    }

    public boolean doesWantToLand() {
        return this.flyTicks > 6000 || this.down() || this.flyTicks > 40 && this.flyProgress == 0.0f;
    }

    public abstract String getVariantName(int var1);

    public abstract String getTexture();

    public abstract String getTextureOverlay();

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            if (this.func_184179_bs() == null) {
                this.updatePreyInMouth(passenger);
            } else {
                float speed_walk = 0.2f;
                float speed_idle = 0.05f;
                float speed_fly = 0.35f;
                float degree_walk = 0.5f;
                float degree_idle = 0.5f;
                float degree_fly = 0.5f;
                this.field_70761_aq = this.field_70177_z;
                this.field_70177_z = passenger.field_70177_z;
                float hoverAddition = this.hoverProgress * 0.02f;
                float flyAddition = -this.flyProgress * 0.03f;
                float flyBody = Math.max(this.flyProgress, this.hoverProgress) * 0.0065f;
                float radius = 0.7f * ((0.3f - flyBody) * this.getRenderSize()) + this.getRenderSize() / 3.0f * flyAddition * 0.0065f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                float bob0 = this.hoverProgress > 0.0f || this.flyProgress > 0.0f ? this.bob(-speed_fly, degree_fly * 5.0f, false, this.field_70173_aa, -0.0625f) : 0.0f;
                float bob1 = this.bob(speed_walk * 2.0f, degree_walk * 1.7f, false, this.field_184619_aG, this.field_70721_aZ * -0.0625f);
                float bob2 = this.bob(speed_idle, degree_idle * 1.3f, false, this.field_70173_aa, -0.0625f);
                double extraY_pre = 0.8f;
                double extraY = (extraY_pre - (double)hoverAddition + (double)flyAddition) * (double)(this.getRenderSize() / 3.0f) - 0.35 * (double)(1.0f - this.getRenderSize() / 30.0f) + (double)bob0 + (double)bob1 + (double)bob2;
                passenger.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
                this.field_70138_W = 1.0f;
            }
        }
    }

    private float bob(float speed, float degree, boolean bounce, float f, float f1) {
        float bob = (float)(Math.sin(f * speed) * (double)f1 * (double)degree - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        return bob * this.getRenderSize() / 3.0f;
    }

    private float walk(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        float movementScale = this.getRenderSize() / 3.0f;
        speed = -speed;
        float rotation = MathHelper.func_76134_b((float)(f * (speed * movementScale) + offset)) * (degree * movementScale) * f1 + weight * f1;
        return invert ? -rotation : rotation;
    }

    private void updatePreyInMouth(Entity prey) {
        if (this.func_184179_bs() != null && prey == this.func_184179_bs()) {
            return;
        }
        if (this.getAnimation() == ANIMATION_SHAKEPREY && this.getAnimationTick() > 55 && prey != null || this.getAnimation() == NO_ANIMATION) {
            prey.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), ((EntityLivingBase)prey).func_110138_aP() * 2.0f);
            this.attackDecision = !this.attackDecision;
            prey.func_184210_p();
        }
        this.field_70761_aq = this.field_70177_z;
        this.field_70177_z = prey.field_70177_z;
        prey.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + prey.func_70033_W(), this.field_70161_v);
        float modTick_0 = this.getAnimationTick() - 15;
        float modTick_1 = this.getAnimationTick() > 15 ? 6.0f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)(modTick_0 * 0.3f)))) : 0.0f;
        float modTick_2 = this.getAnimationTick() > 20 ? 10.0f : (float)(this.getAnimationTick() - 10);
        float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
        float angle = (float)Math.PI / 180 * this.field_70761_aq + 3.15f + modTick_1 * 1.75f * 0.05f;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double extraY = (double)0.1f * ((double)(this.getRenderSize() / 3.0f) + (double)modTick_2 * 0.15 * (double)(this.getRenderSize() / 3.0f));
        prey.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isTeen() {
        return this.getDragonStage() < 4 && this.getDragonStage() > 1;
    }

    public boolean isAdult() {
        return this.getDragonStage() >= 4;
    }

    public boolean func_70631_g_() {
        return this.getDragonStage() < 2;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setGender(this.func_70681_au().nextBoolean());
        int age = this.func_70681_au().nextInt(80) + 1;
        this.growDragon(age);
        this.setVariant(new Random().nextInt(4));
        this.setSleeping(false);
        this.updateAttributes();
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        this.func_70691_i(Math.round(this.minimumHealth + healthStep * (double)age));
        this.setHunger(50);
        return livingdata;
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.isModelDead()) {
            return false;
        }
        if (this.func_184207_aI() && dmg.func_76346_g() != null && this.func_184179_bs() != null && dmg.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        if (dmg == DamageSource.field_76368_d && this.func_184218_aH()) {
            return false;
        }
        float damageReductionHead = (float)(this.getIntFromArmor(this.dragonInv.func_70301_a(0)) / 3) * 0.2f;
        float damageReductionNeck = (float)(this.getIntFromArmor(this.dragonInv.func_70301_a(0)) / 3) * 0.2f;
        float damageReductionBody = (float)(this.getIntFromArmor(this.dragonInv.func_70301_a(0)) / 3) * 0.3f;
        float damageReductionTail = (float)(this.getIntFromArmor(this.dragonInv.func_70301_a(0)) / 3) * 0.2f;
        if (i > 0.0f) {
            this.func_70904_g(false);
            this.setSleeping(false);
        }
        return super.func_70097_a(dmg, i -= damageReductionHead + damageReductionNeck + damageReductionBody + damageReductionTail);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isModelDead()) {
            return;
        }
        if (this.up()) {
            if (!this.isFlying() && !this.isHovering()) {
                this.spacebarTicks += 2;
            }
            if (this.isFlying() || this.isHovering()) {
                this.field_70181_x += 0.4;
            }
        } else if (this.down() && (this.isFlying() || this.isHovering())) {
            this.field_70181_x -= 0.4;
            if (this.field_70122_E) {
                this.setFlying(false);
                this.setHovering(false);
            }
        }
        if (!this.down() && (this.isFlying() || this.isHovering())) {
            this.field_70181_x += 0.01;
        }
        if (this.attack() && this.func_184179_bs() != null && this.getDragonStage() > 1) {
            this.setBreathingFire(true);
            this.riderShootFire(this.func_184179_bs());
            this.fireStopTicks = 10;
        }
        if (this.strike() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            Entity entity = null;
            List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)(this.getRenderSize() / 2.0f), (double)(this.getRenderSize() / 2.0f), (double)(this.getRenderSize() / 2.0f)), (Predicate)new DragonRiderSelector(this));
            Collections.sort(list, new EntityAINearestAttackableTarget.Sorter((Entity)this));
            if (!list.isEmpty()) {
                entity = (Entity)list.get(0);
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                    this.attackDecision = false;
                }
            }
        }
        if (this.dismount() && this.func_184179_bs() != null) {
            this.func_184179_bs().func_184210_p();
        }
        if (this.isFlying() && !this.isHovering() && this.func_184179_bs() != null && !this.field_70122_E && Math.max(Math.abs(this.field_70179_y), Math.abs(this.field_70159_w)) < (double)0.1f) {
            this.setHovering(true);
            this.setFlying(false);
        }
        if (!this.isFlying() && !this.isHovering() || this.func_70090_H()) {
            // empty if block
        }
        if (this.isHovering() && !this.isFlying() && this.func_184179_bs() != null && !this.field_70122_E && Math.max(Math.abs(this.field_70179_y), Math.abs(this.field_70159_w)) > (double)0.1f) {
            this.setFlying(true);
            this.setHovering(false);
        }
        if (this.spacebarTicks > 0) {
            --this.spacebarTicks;
        }
        if (this.spacebarTicks > 20 && this.func_70902_q() != null && this.func_184188_bt().contains(this.func_70902_q()) && !this.isFlying() && !this.isHovering()) {
            this.setHovering(true);
        }
        if (this.field_70170_p.field_72995_K) {
            this.roll_buffer.calculateChainFlapBuffer(50.0f, 10, 4.0f, (EntityLivingBase)this);
        }
        if (this.func_70638_az() != null && this.func_184187_bx() == null && this.func_70638_az().field_70128_L || this.func_70638_az() != null && this.func_70638_az() instanceof EntityDragonBase && ((EntityDragonBase)this.func_70638_az()).field_70128_L) {
            this.func_70624_b(null);
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70090_H() || this.isSleeping() || !this.field_70122_E || this.isFlying() || this.isHovering() || this.func_70638_az() != null || this.isDaytime() || this.func_70681_au().nextInt(250) != 0 || this.func_70638_az() != null || !this.func_184188_bt().isEmpty())) {
            this.setSleeping(true);
        }
        if (this.isSleeping() && (this.isFlying() || this.isHovering() || this.func_70090_H() || this.field_70170_p.func_175710_j(new BlockPos((Entity)this)) && this.isDaytime() && !this.func_70909_n() || this.isDaytime() && this.func_70909_n() || this.func_70638_az() != null || !this.func_184188_bt().isEmpty())) {
            this.setSleeping(false);
        }
    }

    public void func_98054_a(boolean par1) {
        this.func_98055_j(Math.min(this.getRenderSize() * 0.3f, 7.0f));
    }

    public float getRenderSize() {
        float step = (this.growth_stages[this.getDragonStage() - 1][1] - this.growth_stages[this.getDragonStage() - 1][0]) / 25.0f;
        if (this.getAgeInDays() > 125) {
            return this.growth_stages[this.getDragonStage() - 1][0] + step * 25.0f;
        }
        return this.growth_stages[this.getDragonStage() - 1][0] + step * (float)this.getAgeFactor();
    }

    private int getAgeFactor() {
        return this.getDragonStage() > 1 ? this.getAgeInDays() - 25 * (this.getDragonStage() - 1) : this.getAgeInDays();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isModelDead()) {
            return false;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && entity.field_70128_L) {
            this.func_184210_p();
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70071_h_();
            if (this.func_184218_aH()) {
                this.updateRiding(entity);
            }
        }
    }

    public void updateRiding(Entity riding) {
        if (riding.func_184196_w((Entity)this) && riding instanceof EntityPlayer) {
            int i = riding.func_184188_bt().indexOf((Object)this);
            float radius = (i == 2 ? 0.0f : 0.4f) + (float)(((EntityPlayer)riding).func_184613_cA() ? 2 : 0);
            float angle = (float)Math.PI / 180 * ((EntityPlayer)riding).field_70761_aq + (float)(i == 1 ? -90 : (i == 0 ? 90 : 0));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = (riding.func_70093_af() ? 1.2 : 1.4) + (i == 2 ? 0.4 : 0.0);
            this.field_70177_z = ((EntityPlayer)riding).field_70759_as;
            this.field_70759_as = ((EntityPlayer)riding).field_70759_as;
            this.field_70126_B = ((EntityPlayer)riding).field_70759_as;
            this.func_70107_b(riding.field_70165_t + extraX, riding.field_70163_u + extraY, riding.field_70161_v + extraZ);
            if (this.getControlState() == 16 || ((EntityPlayer)riding).func_184613_cA()) {
                this.func_184210_p();
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        if (this.isModelDead()) {
            return NO_ANIMATION;
        }
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (this.isModelDead()) {
            return;
        }
        this.currentAnimation = animation;
    }

    public void func_70642_aH() {
        if (!this.isSleeping() && !this.isModelDead()) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_70642_aH();
        }
    }

    protected void func_184581_c(DamageSource source) {
        if (!this.isModelDead()) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_184581_c(source);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT};
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal instanceof EntityDragonBase && super.func_70878_b(otherAnimal)) {
            EntityDragonBase dragon = (EntityDragonBase)otherAnimal;
            if (this.isMale() && !dragon.isMale() || !this.isMale() && dragon.isMale()) {
                return true;
            }
        }
        return false;
    }

    public EntityDragonEgg createEgg(EntityDragonBase ageable) {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        EntityDragonEgg dragon = new EntityDragonEgg(this.field_70170_p);
        dragon.setType(EnumDragonEgg.byMetadata(new Random().nextInt(3) + (this.isFire ? 0 : 4)));
        dragon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
        return dragon;
    }

    public void flyAround() {
        if (this.airTarget != null) {
            if (!this.isTargetInAir() || this.getDistanceSquared(new Vec3d((double)this.airTarget.func_177958_n(), (double)this.airTarget.func_177956_o(), (double)this.airTarget.func_177952_p())) < 4.0f || this.flyTicks > 6000 || !this.isFlying()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flyTowardsTarget() {
        if (this.airTarget == null || !this.isTargetInAir()) ** GOTO lbl-1000
        v0 = new Vec3d((double)this.airTarget.func_177958_n(), this.field_70163_u, (double)this.airTarget.func_177952_p());
        if (this.getDistanceSquared(v0) > 3.0f) {
            targetX = (double)this.airTarget.func_177958_n() + 0.5 - this.field_70165_t;
            targetY = (double)Math.min(this.airTarget.func_177956_o(), 256) + 1.0 - this.field_70163_u;
            targetZ = (double)this.airTarget.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * this.getFlySpeed();
            this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * this.getFlySpeed();
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * this.getFlySpeed();
            angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / 3.141592653589793) - 90.0f;
            rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70126_B = this.field_70177_z;
            this.field_70177_z += rotation;
            if (!this.isFlying()) {
                this.setFlying(true);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.airTarget = null;
        }
        if (this.airTarget != null && this.isTargetInAir() && this.isFlying()) {
            v1 = new Vec3d((double)this.airTarget.func_177958_n(), this.field_70163_u, (double)this.airTarget.func_177952_p());
            if (this.getDistanceSquared(v1) < 3.0f && this.doesWantToLand()) {
                this.setFlying(false);
                this.setHovering(true);
                this.flyHovering = 1;
            }
        }
    }

    private double getFlySpeed() {
        return 2 + this.getAgeInDays() / 125 * 2;
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && (this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a || this instanceof EntityIceDragon && (this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151586_h || this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a));
    }

    public float getDistanceSquared(Vec3d vec3d) {
        float f = (float)(this.field_70165_t - vec3d.field_72450_a);
        float f1 = (float)(this.field_70163_u - vec3d.field_72448_b);
        float f2 = (float)(this.field_70161_v - vec3d.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    public void func_76316_a(InventoryBasic invBasic) {
        int dragonArmorHead = this.getArmorInSlot(0);
        int dragonArmorNeck = this.getArmorInSlot(1);
        int dragonArmorBody = this.getArmorInSlot(2);
        int dragonArmorTail = this.getArmorInSlot(3);
        this.updateDragonSlots();
        if (this.field_70173_aa > 20) {
            if (dragonArmorHead != this.getIntFromArmor(this.dragonInv.func_70301_a(0))) {
                this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
            }
            if (dragonArmorNeck != this.getIntFromArmor(this.dragonInv.func_70301_a(1))) {
                this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
            }
            if (dragonArmorBody != this.getIntFromArmor(this.dragonInv.func_70301_a(2))) {
                this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
            }
            if (dragonArmorTail != this.getIntFromArmor(this.dragonInv.func_70301_a(3))) {
                this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
            }
        }
    }

    public boolean func_174820_d(int inventorySlot, @Nullable ItemStack itemStackIn) {
        int j = inventorySlot - 500 + 2;
        if (j >= 0 && j < this.dragonInv.func_70302_i_()) {
            this.dragonInv.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public abstract Item getVariantScale(int var1);

    public abstract Item getVariantEgg(int var1);

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((EntityPlayer)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.down(mc.field_71474_y.field_74311_E.func_151470_d());
            this.attack(ModKeys.dragon_fireAttack.func_151470_d());
            this.strike(ModKeys.dragon_strike.func_151470_d());
            this.dismount(ModKeys.dragon_dismount.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(ModKeys.dragon_dismount.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState));
            }
        }
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_70612_e(float strafe, float forward) {
        if (!this.canMove() && !this.func_184207_aI()) {
            strafe = 0.0f;
            forward = 0.0f;
            super.func_70612_e(strafe, forward);
            return;
        }
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase controller = (EntityLivingBase)this.func_184179_bs();
            if (controller != null) {
                strafe = controller.field_70702_br * 0.5f;
                forward = controller.field_70701_bs;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (this.isFlying() || this.isHovering()) {
                    this.field_70159_w *= 1.06;
                    this.field_70179_y *= 1.06;
                }
                this.field_70747_aH = 0.05f;
                this.func_70659_e(this.field_70122_E ? (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : (float)this.getFlySpeed());
            }
            if (!this.func_70090_H() || !this.func_70055_a(Material.field_151579_a) || this.field_70181_x > 1.0) {
                // empty if block
            }
        }
        if (!this.func_70090_H() || this.func_70909_n()) {
            // empty if block
        }
        super.func_70612_e(strafe, forward);
    }

    public void updateCheckPlayer() {
        EntityPlayer player1;
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, (double)(this.getRenderSize() / 2.0f));
        if (!this.func_70909_n() && this.isSleeping() && player != null && !this.func_152114_e((EntityLivingBase)player) && !player.field_71075_bZ.field_75098_d) {
            this.setSleeping(false);
            this.func_70904_g(false);
            this.func_70624_b((EntityLivingBase)player);
        }
        if ((player1 = this.field_70170_p.func_72890_a((Entity)this, (double)(this.getRenderSize() / 2.0f + 15.0f))) != null) {
            player1.func_71064_a((StatBase)ModAchievements.dragonEncounter, 1);
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean isDirectPathBetweenPoints(Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)this.field_70131_O * 0.5, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (entityLivingIn instanceof EntityPlayer) {
            ((EntityPlayer)entityLivingIn).func_71064_a((StatBase)ModAchievements.dragonKillPlayer, 1);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() != null && cause.func_76346_g() instanceof EntityPlayer) {
            ((EntityPlayer)cause.func_76346_g()).func_71064_a((StatBase)ModAchievements.dragonKill, 1);
        }
        super.func_70645_a(cause);
        if (this.dragonInv != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.dragonInv.func_70302_i_(); ++i) {
                ItemStack itemstack = this.dragonInv.func_70301_a(i);
                if (itemstack == null) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    static class DragonRiderSelector
    implements Predicate<Entity> {
        private final EntityDragonBase parentEntity;

        public DragonRiderSelector(EntityDragonBase dragon) {
            this.parentEntity = dragon;
        }

        public boolean apply(@Nullable Entity prey) {
            return prey instanceof EntityLivingBase && !this.sharesOwner((EntityLivingBase)prey) && !this.parentEntity.func_152114_e((EntityLivingBase)prey) && EntitySelectors.field_180132_d.apply((Object)prey);
        }

        public boolean sharesOwner(EntityLivingBase prey) {
            EntityLivingBase dogOwner;
            EntityLivingBase dragonOwner;
            return prey != null && prey instanceof EntityLivingBase && prey instanceof EntityTameable && this.parentEntity.func_70902_q() != null && ((EntityTameable)prey).func_70902_q() != null && (dragonOwner = this.parentEntity.func_70902_q()) != (dogOwner = ((EntityTameable)prey).func_70902_q());
        }
    }
}

