/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.core;

import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.enums.EnumBestiaryPages;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class ModVillagers {
    public static final ModVillagers INSTANCE = new ModVillagers();
    public static final ResourceLocation PROFESSIONS = new ResourceLocation("iceandfire:snowvillagerprofessions");
    public VillagerRegistry.VillagerProfession fisherman;
    public VillagerRegistry.VillagerProfession craftsman;
    public VillagerRegistry.VillagerProfession shaman;
    public Map<Integer, VillagerRegistry.VillagerProfession> professions = Maps.newHashMap();

    public void init() {
        this.fisherman = new VillagerRegistry.VillagerProfession("iceandfire:fisherman", "iceandfire:textures/models/snowvillager/fisherman.png", "minecraft:textures/entity/zombie_villager/zombie_farmer.png");
        VillagerRegistry.VillagerCareer career = new VillagerRegistry.VillagerCareer(this.fisherman, "fisherman");
        career.addTrade(1, new EntityVillager.ITradeList[]{new SapphireForItems(Items.field_151115_aP, new EntityVillager.PriceInfo(1, 10))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires((Item)Items.field_151112_aM, new EntityVillager.PriceInfo(1, 3))});
        career.addTrade(1, new EntityVillager.ITradeList[]{new ListItemForSapphires(ModItems.fishing_spear, new EntityVillager.PriceInfo(1, 5))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires(Items.field_179566_aV, new EntityVillager.PriceInfo(1, 5))});
        this.register(this.fisherman, 0);
        this.craftsman = new VillagerRegistry.VillagerProfession("iceandfire:craftsman", "iceandfire:textures/models/snowvillager/craftsman.png", "minecraft:textures/entity/zombie_villager/zombie_farmer.png");
        career = new VillagerRegistry.VillagerCareer(this.craftsman, "craftsman");
        career.addTrade(1, new EntityVillager.ITradeList[]{new SapphireForItems(Item.func_150898_a((Block)Blocks.field_150433_aE), new EntityVillager.PriceInfo(1, 32))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires(Item.func_150898_a((Block)Blocks.field_150403_cj), new EntityVillager.PriceInfo(1, 3))});
        career.addTrade(1, new EntityVillager.ITradeList[]{new ListItemForSapphires(Items.field_151037_a, new EntityVillager.PriceInfo(1, 4))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires(ModItems.silver_shovel, new EntityVillager.PriceInfo(1, 5))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new ListItemForSapphires(Items.field_151047_v, new EntityVillager.PriceInfo(1, 9))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires(Items.field_151116_aA, new EntityVillager.PriceInfo(10, 1))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new ListItemForSapphires((Item)Items.field_151021_T, new EntityVillager.PriceInfo(1, 3))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new ListItemForSapphires((Item)Items.field_151024_Q, new EntityVillager.PriceInfo(1, 4))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new ListItemForSapphires((Item)Items.field_151027_R, new EntityVillager.PriceInfo(1, 6))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new ListItemForSapphires((Item)Items.field_151026_S, new EntityVillager.PriceInfo(1, 6))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new SapphireForItems(Items.field_151047_v, new EntityVillager.PriceInfo(1, 7))});
        this.register(this.craftsman, 1);
        this.shaman = new VillagerRegistry.VillagerProfession("iceandfire:shaman", "iceandfire:textures/models/snowvillager/shaman.png", "minecraft:textures/entity/zombie_villager/zombie_farmer.png");
        career = new VillagerRegistry.VillagerCareer(this.shaman, "shaman");
        career.addTrade(1, new EntityVillager.ITradeList[]{new SapphireForItems(Items.field_151065_br, new EntityVillager.PriceInfo(2, 3))});
        career.addTrade(1, new EntityVillager.ITradeList[]{new SapphireForItems(Items.field_151073_bk, new EntityVillager.PriceInfo(1, 4))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new SapphireForItems(Items.field_151067_bt, new EntityVillager.PriceInfo(9, 1))});
        career.addTrade(1, new EntityVillager.ITradeList[]{new SapphireForItems(ModItems.dragonbone, new EntityVillager.PriceInfo(1, 12))});
        ItemStack stack = new ItemStack(ModItems.bestiary);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74783_a("Pages", new int[]{EnumBestiaryPages.INTRODUCTION.ordinal()});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires(stack, new EntityVillager.PriceInfo(1, 3))});
        career.addTrade(1, new EntityVillager.ITradeList[]{new ListItemForSapphires(ModItems.manuscript, new EntityVillager.PriceInfo(1, 2))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new ListItemForSapphires(ModItems.ice_dragon_flesh, new EntityVillager.PriceInfo(1, 5))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new ListItemForSapphires(ModItems.ice_dragon_blood, new EntityVillager.PriceInfo(1, 12))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires(Items.field_151061_bv, new EntityVillager.PriceInfo(2, 5))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires(ModItems.witherbone, new EntityVillager.PriceInfo(2, 5))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new ListItemForSapphires(ModItems.wither_shard, new EntityVillager.PriceInfo(3, 2))});
        this.register(this.shaman, 2);
    }

    public void setRandomProfession(EntityVillager entity, Random rand) {
        entity.setProfession(this.professions.get(rand.nextInt(this.professions.size())));
    }

    private void register(VillagerRegistry.VillagerProfession prof, int id) {
        this.professions.put(id, prof);
    }

    public static class ListItemForSapphires
    implements EntityVillager.ITradeList {
        public ItemStack itemToBuy;
        public EntityVillager.PriceInfo priceInfo;

        public ListItemForSapphires(Item par1Item, EntityVillager.PriceInfo priceInfo) {
            this.itemToBuy = new ItemStack(par1Item);
            this.priceInfo = priceInfo;
        }

        public ListItemForSapphires(ItemStack stack, EntityVillager.PriceInfo priceInfo) {
            this.itemToBuy = stack;
            this.priceInfo = priceInfo;
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random random) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.func_179412_a(random);
            }
            if (i < 0) {
                itemstack = new ItemStack(ModItems.sapphireGem);
                itemstack1 = new ItemStack(this.itemToBuy.func_77973_b(), -i, this.itemToBuy.func_77960_j());
            } else {
                itemstack = new ItemStack(ModItems.sapphireGem, i, 0);
                itemstack1 = new ItemStack(this.itemToBuy.func_77973_b(), 1, this.itemToBuy.func_77960_j());
            }
            recipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    public static class SapphireForItems
    implements EntityVillager.ITradeList {
        public Item buyingItem;
        public EntityVillager.PriceInfo price;

        public SapphireForItems(Item itemIn, EntityVillager.PriceInfo priceIn) {
            this.buyingItem = itemIn;
            this.price = priceIn;
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.price != null) {
                i = this.price.func_179412_a(random);
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(this.buyingItem, i, 0), ModItems.sapphireGem));
        }
    }
}

