/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.crafting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.math.IntMath;
import com.pau101.fairylights.util.crafting.IllegalRecipeException;
import com.pau101.fairylights.util.crafting.ingredient.Ingredient;
import com.pau101.fairylights.util.crafting.ingredient.IngredientAuxiliary;
import com.pau101.fairylights.util.crafting.ingredient.IngredientRegular;
import com.pau101.fairylights.util.crafting.ingredient.IngredientRegularEmpty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class GenericRecipe
implements IRecipe {
    public static final IngredientRegularEmpty EMPTY = new IngredientRegularEmpty();
    private final ItemStack output;
    private final IngredientRegular[] ingredients;
    private final IngredientAuxiliary<?>[] auxiliaryIngredients;
    private final int width;
    private final int height;
    private ThreadLocal<ItemStack> result = new ThreadLocal();

    GenericRecipe(ItemStack output, IngredientRegular[] ingredients, IngredientAuxiliary<?>[] auxiliaryIngredients, int width, int height) {
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(ingredients, "ingredients");
        Objects.requireNonNull(auxiliaryIngredients, "auxiliaryIngredients");
        GenericRecipe.checkIngredients(ingredients, auxiliaryIngredients);
        Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0, (Object)"width must be greater than or equal to zero");
        Preconditions.checkArgument((height >= 0 ? 1 : 0) != 0, (Object)"height must be greater than or equal to zero");
        this.output = output;
        this.ingredients = ingredients;
        this.auxiliaryIngredients = auxiliaryIngredients;
        this.width = width;
        this.height = height;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public IngredientRegular[] getIngredients() {
        return (IngredientRegular[])this.ingredients.clone();
    }

    public IngredientAuxiliary<?>[] getAuxiliaryIngredients() {
        return (IngredientAuxiliary[])this.auxiliaryIngredients.clone();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean func_77569_a(InventoryCrafting inventory, World world) {
        if (this.width > inventory.func_174922_i() || this.height > inventory.func_174923_h()) {
            return false;
        }
        int scanWidth = inventory.func_174922_i() + 1 - this.width;
        int scanHeight = inventory.func_174923_h() + 1 - this.height;
        int end = scanWidth * scanHeight;
        for (int i = 0; i < end; ++i) {
            int x = i % scanWidth;
            int y = i / scanWidth;
            ItemStack result = this.getResult(inventory, this.prepareOutput(), x, y, c -> c);
            this.result.set(result);
            if (result != null) {
                this.prepareResult();
                return true;
            }
            result = this.getResult(inventory, this.prepareOutput(), x, y, c -> this.width - 1 - c);
            this.result.set(result);
            if (result == null) continue;
            this.prepareResult();
            return true;
        }
        this.result.set(null);
        return false;
    }

    private ItemStack prepareOutput() {
        ItemStack result = this.output.func_77946_l();
        if (!result.func_77942_o()) {
            result.func_77982_d(new NBTTagCompound());
        }
        return result;
    }

    private void prepareResult() {
        ItemStack result = this.result.get();
        if (result.func_77942_o() && result.func_77978_p().func_82582_d()) {
            result.func_77982_d(null);
        }
    }

    @Nullable
    private ItemStack getResult(InventoryCrafting inventory, ItemStack output, int originX, int originY, IntUnaryOperator funcX) {
        MatchResultRegular[] match = new MatchResultRegular[this.ingredients.length];
        LinkedListMultimap auxMatchResults = LinkedListMultimap.create();
        HashMap<IngredientAuxiliary, Integer> auxMatchTotals = new HashMap<IngredientAuxiliary, Integer>();
        HashSet presentCalled = new HashSet();
        ArrayList<MatchResult<IngredientRegular, MatchResultRegular>> auxResults = new ArrayList<MatchResult<IngredientRegular, MatchResultRegular>>();
        int w = inventory.func_174922_i();
        int n = w * inventory.func_174923_h();
        int auxCount = this.auxiliaryIngredients.length;
        for (int i = 0; i < n; ++i) {
            MatchResult<IngredientRegular, MatchResultRegular> result;
            int x = i % w;
            int y = i / w;
            int ingX = x - originX;
            int ingY = y - originY;
            ItemStack input = inventory.func_70463_b(x, y);
            if (this.contains(ingX, ingY)) {
                int index = funcX.applyAsInt(ingX) + ingY * this.width;
                IngredientRegular ingredient = this.ingredients[index];
                result = (MatchResultRegular)ingredient.matches(input, output);
                if (!((MatchResultRegular)result).doesMatch()) {
                    return null;
                }
                match[index] = result;
                ((MatchResultRegular)result).forMatch(presentCalled, output);
                continue;
            }
            if (EMPTY.matches(input, output).doesMatch()) continue;
            boolean nonAuxiliary = true;
            for (int n2 = 0; n2 < auxCount; ++n2) {
                result = (MatchResultAuxiliary)this.auxiliaryIngredients[n2].matches(input, output);
                if (((MatchResultAuxiliary)result).doesMatch()) {
                    if (((MatchResultAuxiliary)result).isAtLimit(auxMatchTotals.getOrDefault(((MatchResultAuxiliary)result).ingredient, 0))) {
                        return null;
                    }
                    ((MatchResultAuxiliary)result).forMatch(presentCalled, output);
                    auxMatchTotals.merge(((MatchResultAuxiliary)result).ingredient, 1, IntMath::checkedAdd);
                    nonAuxiliary = false;
                    ((MatchResultAuxiliary)result).propagate((Multimap<IngredientAuxiliary<?>, MatchResultAuxiliary>)auxMatchResults);
                }
                auxResults.add(result);
            }
            if (!nonAuxiliary) continue;
            return null;
        }
        HashSet absentCalled = new HashSet();
        for (MatchResultRegular result : match) {
            result.notifyAbsence(presentCalled, absentCalled, output);
        }
        for (MatchResultAuxiliary matchResultAuxiliary : auxResults) {
            matchResultAuxiliary.notifyAbsence(presentCalled, absentCalled, output);
        }
        for (IngredientAuxiliary<?> ingredient : this.auxiliaryIngredients) {
            if (!ingredient.process((Multimap<IngredientAuxiliary<?>, MatchResultAuxiliary>)auxMatchResults, output)) continue;
            return null;
        }
        return output;
    }

    private boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        ItemStack result = this.result.get();
        if (result == null) {
            return null;
        }
        return result.func_77946_l();
    }

    public int func_77570_a() {
        return this.width * this.height;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inventory) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inventory);
    }

    private static void checkIngredients(IngredientRegular[] ingredients, IngredientAuxiliary<?>[] auxiliaryIngredients) {
        GenericRecipe.checkForNulls(ingredients);
        GenericRecipe.checkForNulls(auxiliaryIngredients);
        boolean ingredientDictator = GenericRecipe.checkDictatorship(false, ingredients);
        GenericRecipe.checkDictatorship(ingredientDictator, auxiliaryIngredients);
    }

    private static void checkForNulls(Ingredient<?, ?>[] ingredients) {
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i] != null) continue;
            throw new NullPointerException("Must not have null ingredients, found at index " + i);
        }
    }

    private static boolean checkDictatorship(boolean foundDictator, Ingredient<?, ?>[] ingredients) {
        for (Ingredient<?, ?> ingredient : ingredients) {
            if (!ingredient.dictatesOutputType()) continue;
            if (foundDictator) {
                throw new IllegalRecipeException("Only one ingredient can dictate output type");
            }
            foundDictator = true;
        }
        return foundDictator;
    }

    public static class MatchResultParentedAuxiliary
    extends MatchResultAuxiliary {
        protected final MatchResultAuxiliary parent;

        public MatchResultParentedAuxiliary(IngredientAuxiliary ingredient, @Nullable ItemStack input, boolean doesMatch, List<MatchResultAuxiliary> supplementaryResults, MatchResultAuxiliary parent) {
            super(ingredient, input, doesMatch, supplementaryResults);
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        @Override
        public void forMatch(Set<Ingredient<?, ?>> called, ItemStack output) {
            super.forMatch(called, output);
            this.parent.forMatch(called, output);
        }

        @Override
        public void notifyAbsence(Set<Ingredient<?, ?>> presentCalled, Set<Ingredient<?, ?>> absentCalled, ItemStack output) {
            super.notifyAbsence(presentCalled, absentCalled, output);
            this.parent.notifyAbsence(presentCalled, absentCalled, output);
        }

        @Override
        public MatchResultAuxiliary withParent(MatchResultAuxiliary parent) {
            return this.parent.withParent(new MatchResultParentedAuxiliary(this.ingredient, this.input, this.doesMatch, (List<MatchResultAuxiliary>)this.supplementaryResults, parent));
        }

        @Override
        public boolean isAtLimit(int count) {
            return super.isAtLimit(count) || this.parent.isAtLimit(count);
        }

        @Override
        public void propagate(Multimap<IngredientAuxiliary<?>, MatchResultAuxiliary> map) {
            super.propagate(map);
            this.parent.propagate(map);
        }
    }

    public static class MatchResultAuxiliary
    implements MatchResult<IngredientAuxiliary<?>, MatchResultAuxiliary> {
        protected final IngredientAuxiliary ingredient;
        @Nullable
        protected final ItemStack input;
        protected final boolean doesMatch;
        protected final ImmutableList<MatchResultAuxiliary> supplementaryResults;

        public MatchResultAuxiliary(IngredientAuxiliary ingredient, @Nullable ItemStack input, boolean doesMatch, List<MatchResultAuxiliary> supplementaryResults) {
            this.ingredient = Objects.requireNonNull(ingredient, "ingredient");
            this.input = input;
            this.doesMatch = doesMatch;
            this.supplementaryResults = ImmutableList.copyOf(supplementaryResults);
        }

        @Override
        public final IngredientAuxiliary getIngredient() {
            return this.ingredient;
        }

        @Override
        public final ItemStack getInput() {
            return this.input;
        }

        @Override
        public final boolean doesMatch() {
            return this.doesMatch;
        }

        @Override
        public void forMatch(Set<Ingredient<?, ?>> called, ItemStack output) {
            if (!called.contains(this.ingredient)) {
                this.ingredient.present(output);
                called.add(this.ingredient);
            }
        }

        @Override
        public void notifyAbsence(Set<Ingredient<?, ?>> presentCalled, Set<Ingredient<?, ?>> absentCalled, ItemStack output) {
            if (!presentCalled.contains(this.ingredient) && !absentCalled.contains(this.ingredient)) {
                this.ingredient.absent(output);
                absentCalled.add(this.ingredient);
            }
            for (MatchResultAuxiliary result : this.supplementaryResults) {
                result.notifyAbsence(presentCalled, absentCalled, output);
            }
        }

        @Override
        public MatchResultAuxiliary withParent(MatchResultAuxiliary parent) {
            return new MatchResultParentedAuxiliary(this.ingredient, this.input, this.doesMatch, (List<MatchResultAuxiliary>)this.supplementaryResults, parent);
        }

        public boolean isAtLimit(int count) {
            return count >= this.ingredient.getLimit();
        }

        public void propagate(Multimap<IngredientAuxiliary<?>, MatchResultAuxiliary> map) {
            map.put((Object)this.ingredient, (Object)this);
        }
    }

    public static class MatchResultParentedRegular
    extends MatchResultRegular {
        protected final MatchResultRegular parent;

        public MatchResultParentedRegular(IngredientRegular ingredient, @Nullable ItemStack input, boolean doesMatch, List<MatchResultRegular> supplementaryResults, MatchResultRegular parent) {
            super(ingredient, input, doesMatch, supplementaryResults);
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        @Override
        public void forMatch(Set<Ingredient<?, ?>> called, ItemStack output) {
            super.forMatch(called, output);
            this.parent.forMatch(called, output);
        }

        @Override
        public void notifyAbsence(Set<Ingredient<?, ?>> presentCalled, Set<Ingredient<?, ?>> absentCalled, ItemStack output) {
            super.notifyAbsence(presentCalled, absentCalled, output);
            this.parent.notifyAbsence(presentCalled, absentCalled, output);
        }

        @Override
        public MatchResultRegular withParent(MatchResultRegular parent) {
            return this.parent.withParent(new MatchResultParentedRegular(this.ingredient, this.input, this.doesMatch, (List<MatchResultRegular>)this.supplementaryResults, parent));
        }
    }

    public static class MatchResultRegular
    implements MatchResult<IngredientRegular, MatchResultRegular> {
        protected final IngredientRegular ingredient;
        @Nullable
        protected final ItemStack input;
        protected final boolean doesMatch;
        protected final ImmutableList<MatchResultRegular> supplementaryResults;

        public MatchResultRegular(IngredientRegular ingredient, @Nullable ItemStack input, boolean doesMatch, List<MatchResultRegular> supplementaryResults) {
            this.ingredient = Objects.requireNonNull(ingredient, "ingredient");
            this.input = input;
            this.doesMatch = doesMatch;
            this.supplementaryResults = ImmutableList.copyOf(supplementaryResults);
        }

        @Override
        public final IngredientRegular getIngredient() {
            return this.ingredient;
        }

        @Override
        public final ItemStack getInput() {
            return this.input;
        }

        @Override
        public final boolean doesMatch() {
            return this.doesMatch;
        }

        @Override
        public void forMatch(Set<Ingredient<?, ?>> called, ItemStack output) {
            this.ingredient.matched(this.input, output);
            if (!called.contains(this.ingredient)) {
                this.ingredient.present(output);
                called.add(this.ingredient);
            }
        }

        @Override
        public void notifyAbsence(Set<Ingredient<?, ?>> presentCalled, Set<Ingredient<?, ?>> absentCalled, ItemStack output) {
            if (!presentCalled.contains(this.ingredient) && !absentCalled.contains(this.ingredient)) {
                this.ingredient.absent(output);
                absentCalled.add(this.ingredient);
            }
            for (MatchResultRegular result : this.supplementaryResults) {
                result.notifyAbsence(presentCalled, absentCalled, output);
            }
        }

        @Override
        public MatchResultRegular withParent(MatchResultRegular parent) {
            return new MatchResultParentedRegular(this.ingredient, this.input, this.doesMatch, (List<MatchResultRegular>)this.supplementaryResults, parent);
        }
    }

    public static interface MatchResult<I extends Ingredient, M extends MatchResult<I, M>> {
        public I getIngredient();

        @Nullable
        public ItemStack getInput();

        public boolean doesMatch();

        public void forMatch(Set<Ingredient<?, ?>> var1, ItemStack var2);

        public void notifyAbsence(Set<Ingredient<?, ?>> var1, Set<Ingredient<?, ?>> var2, ItemStack var3);

        public M withParent(M var1);
    }
}

