/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.item;

import com.google.common.base.Objects;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.block.BlockFastener;
import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.entity.EntityFenceFastener;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.sound.FLSounds;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public abstract class ItemConnection
extends Item {
    private static final ThreadLocal<IsolatedBlock> ISOLATED_BLOCK = ThreadLocal.withInitial(() -> new IsolatedBlock());

    public ItemConnection() {
        this.func_77625_d(16);
    }

    public abstract ConnectionType getConnectionType();

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer user, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EntityHanging entity;
        if (this.isConnectionInOtherHand(world, user, stack)) {
            return EnumActionResult.PASS;
        }
        if (user.func_175151_a(pos, side, stack) && world.func_180495_p(pos).func_177230_c() == FairyLights.fastener) {
            if (!world.field_72995_K) {
                this.connect(stack, user, world, pos);
            }
            return EnumActionResult.SUCCESS;
        }
        if (FairyLights.fastener.func_176198_a(world, pos, side)) {
            if (user.func_175151_a(pos = pos.func_177972_a(side), side, stack) && FairyLights.fastener.func_176196_c(world, pos)) {
                if (!world.field_72995_K) {
                    this.connect(stack, user, world, pos, side);
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (user.func_175151_a(pos, side, stack) && ItemConnection.isFence(world.func_180495_p(pos), world.func_175625_s(pos)) && ((entity = EntityFenceFastener.findHanging(world, pos)) == null || entity instanceof EntityFenceFastener)) {
            if (!world.field_72995_K) {
                this.connectFence(stack, user, world, pos, (EntityFenceFastener)entity);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean isConnectionInOtherHand(World world, EntityPlayer user, ItemStack stack) {
        Fastener attacher = (Fastener)user.getCapability(CapabilityHandler.FASTENER_CAP, null);
        Connection connection = attacher.getFirstConnection();
        if (connection != null) {
            NBTTagCompound nbt = connection.serializeLogic();
            if (nbt.func_82582_d()) {
                return stack.func_77942_o();
            }
            return !NBTUtil.func_181123_a((NBTBase)nbt, (NBTBase)stack.func_77978_p(), (boolean)true);
        }
        return false;
    }

    private void connect(ItemStack stack, EntityPlayer user, World world, BlockPos pos) {
        Fastener fastener = (Fastener)world.func_175625_s(pos).getCapability(CapabilityHandler.FASTENER_CAP, null);
        this.connect(stack, user, world, fastener);
    }

    private void connect(ItemStack stack, EntityPlayer user, World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = FairyLights.fastener.func_176223_P().func_177226_a((IProperty)BlockFastener.FACING, (Comparable)facing);
        if (world.func_180501_a(pos, state, 3)) {
            FairyLights.fastener.func_180633_a(world, pos, state, (EntityLivingBase)user, stack);
            SoundType sound = FairyLights.fastener.getSoundType(state, world, pos, (Entity)user);
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            Fastener destination = (Fastener)world.func_175625_s(pos).getCapability(CapabilityHandler.FASTENER_CAP, null);
            this.connect(stack, user, world, destination, false);
        }
    }

    public void connect(ItemStack stack, EntityPlayer user, World world, Fastener fastener) {
        this.connect(stack, user, world, fastener, true);
    }

    public void connect(ItemStack stack, EntityPlayer user, World world, Fastener fastener, boolean playConnectSound) {
        Fastener attacher = (Fastener)user.getCapability(CapabilityHandler.FASTENER_CAP, null);
        Connection conn = attacher.getFirstConnection();
        if (conn == null) {
            NBTTagCompound data = (NBTTagCompound)Objects.firstNonNull((Object)stack.func_77978_p(), (Object)new NBTTagCompound());
            fastener.connectWith(world, attacher, this.getConnectionType(), data);
        } else if (conn.getDestination().isLoaded(world)) {
            Connection c = conn.getDestination().get(world).reconnect(attacher, fastener);
            if (c == null) {
                playConnectSound = false;
            } else {
                c.onConnect(world, user, stack);
                --stack.field_77994_a;
            }
        }
        if (playConnectSound) {
            Vec3d pos = fastener.getConnectionPoint();
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, FLSounds.CORD_CONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void connectFence(ItemStack stack, EntityPlayer user, World world, BlockPos pos, EntityFenceFastener fastener) {
        boolean playConnectSound;
        if (fastener == null) {
            fastener = EntityFenceFastener.create(world, pos);
            playConnectSound = false;
        } else {
            playConnectSound = true;
        }
        this.connect(stack, user, world, (Fastener)fastener.getCapability(CapabilityHandler.FASTENER_CAP, null), playConnectSound);
    }

    public static boolean isFence(IBlockState state, TileEntity entity) {
        Block block = state.func_177230_c();
        if (block instanceof BlockFence) {
            return true;
        }
        if (!state.func_185904_a().func_76220_a()) {
            return false;
        }
        AxisAlignedBB bounds = null;
        try {
            IsolatedBlock ib = ISOLATED_BLOCK.get();
            ib.set(state, entity);
            bounds = block.func_176223_P().func_185890_d((World)ib, IsolatedBlock.POS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bounds != null && bounds.field_72340_a > 0.34375 && bounds.field_72339_c > 0.34375 && bounds.field_72336_d < 0.65625 && bounds.field_72334_f < 0.65625;
    }

    private static class IsolatedProfiler
    extends Profiler {
        private IsolatedProfiler() {
        }

        public void func_76317_a() {
        }

        public void func_76320_a(String name) {
        }

        public void func_76319_b() {
        }

        public void func_76318_c(String name) {
        }

        public String func_76322_c() {
            return "";
        }

        public List<Profiler.Result> func_76321_b(String profilerName) {
            return Collections.EMPTY_LIST;
        }
    }

    private static class IsolatedImpl
    extends WorldProvider
    implements ISaveHandler,
    IPlayerFileData,
    IChunkLoader {
        private IsolatedImpl() {
        }

        public DimensionType func_186058_p() {
            return DimensionType.OVERWORLD;
        }

        public WorldInfo func_75757_d() {
            return IsolatedBlock.INFO;
        }

        public void func_75762_c() {
        }

        public IChunkLoader func_75763_a(WorldProvider provider) {
            return this;
        }

        public void func_75755_a(WorldInfo worldInformation, NBTTagCompound tagCompound) {
        }

        public void func_75761_a(WorldInfo worldInformation) {
        }

        public IPlayerFileData func_75756_e() {
            return this;
        }

        public void func_75759_a() {
        }

        public File func_75765_b() {
            return null;
        }

        public File func_75758_b(String mapName) {
            return null;
        }

        public TemplateManager func_186340_h() {
            return null;
        }

        public void func_75753_a(EntityPlayer player) {
        }

        public NBTTagCompound func_75752_b(EntityPlayer player) {
            return new NBTTagCompound();
        }

        public String[] func_75754_f() {
            return new String[0];
        }

        public Chunk func_75815_a(World worldIn, int x, int z) throws IOException {
            return null;
        }

        public void func_75816_a(World worldIn, Chunk chunkIn) {
        }

        public void func_75819_b(World worldIn, Chunk chunkIn) {
        }

        public void func_75817_a() {
        }

        public void func_75818_b() {
        }
    }

    private static class IsolatedBlock
    extends World {
        public static final BlockPos POS = BlockPos.field_177992_a;
        public static final WorldInfo INFO = new WorldInfo(new WorldSettings(0L, GameType.ADVENTURE, false, false, WorldType.field_180271_f), "");
        private static final IsolatedImpl OBJECT = new IsolatedImpl();
        private IBlockState state;
        private TileEntity entity;

        public IsolatedBlock() {
            super((ISaveHandler)OBJECT, INFO, (WorldProvider)OBJECT, (Profiler)new IsolatedProfiler(), true);
        }

        public void set(IBlockState state, TileEntity entity) {
            this.state = state;
            this.entity = entity;
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return POS.equals((Object)pos) ? this.entity : null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return POS.equals((Object)pos) ? this.state : Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return !POS.equals((Object)pos) || this.state.func_177230_c().isAir(this.state, (IBlockAccess)this, pos);
        }

        public Biome func_180494_b(BlockPos pos) {
            return Biomes.field_180279_ad;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return WorldType.field_180271_f;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return POS.equals((Object)pos) && this.state.isSideSolid((IBlockAccess)this, pos, side);
        }

        protected IChunkProvider func_72970_h() {
            return new IChunkProvider(){

                public boolean func_73156_b() {
                    return false;
                }

                public Chunk func_186025_d(int x, int z) {
                    return null;
                }

                public String func_73148_d() {
                    return "";
                }

                public Chunk func_186026_b(int x, int z) {
                    return null;
                }
            };
        }

        protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
            return true;
        }
    }
}

