/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration.mcmultipart;

import java.util.Collection;
import java.util.Collections;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.IPartConverter;
import mcmultipart.multipart.IReversePartConverter;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.ChiseledBlockPart;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

class ChiseledBlockConverter
implements IPartConverter,
IReversePartConverter {
    ChiseledBlockConverter() {
    }

    public Collection<Block> getConvertableBlocks() {
        return ChiselsAndBits.getBlocks().getConversions().values();
    }

    public Collection<? extends IMultipart> convertBlock(IBlockAccess world, BlockPos pos, boolean client) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBlockChiseled) {
            ChiseledBlockPart part = new ChiseledBlockPart();
            part.bc = (BlockChiseled)world.func_180495_p(pos).func_177230_c();
            part.inner = new TileEntityBlockChiseled();
            part.inner.copyFrom((TileEntityBlockChiseled)te);
            return Collections.singletonList(part);
        }
        return Collections.emptyList();
    }

    public boolean convertToBlock(IMultipartContainer container) {
        TileEntityBlockChiseled tile = null;
        for (IMultipart part : container.getParts()) {
            if (part instanceof ChiseledBlockPart) {
                tile = ((ChiseledBlockPart)part).getTile();
                continue;
            }
            return false;
        }
        if (tile != null) {
            tile.func_145831_w().func_175656_a(tile.func_174877_v(), tile.getPreferedBlock());
            TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(tile.func_145831_w(), tile.func_174877_v(), true);
            if (te != null) {
                te.copyFrom(tile);
            }
            return true;
        }
        return false;
    }
}

