/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.util.ArrayList;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import xaero.map.MapWriter;
import xaero.map.Misc;
import xaero.map.WorldMap;
import xaero.map.region.MapBlock;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;

public class MapPixel {
    protected int state = 0;
    protected byte colourType = 0;
    protected int customColour;
    protected byte light = 0;
    protected boolean glowing = false;

    public void getPixelColours(int[] red_dest, int[] green_dest, int[] blue_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTile prevTile, MapTile mapTile, int x, int z, MapBlock block, int height, ArrayList<Overlay> overlays, int lightLevels, float[] brightnessBuffer, float[] postBrightnessBuffer, BlockPos.MutableBlockPos mutableGlobalPos) {
        int i;
        int colour = 0;
        mutableGlobalPos.func_181079_c(mapTile.getChunkX() * 16 + x, height, mapTile.getChunkZ() * 16 + z);
        if (this.state != 0) {
            if (WorldMap.settings.colours == 0) {
                colour = mapWriter.loadBlockColourFromTexture(this.state, true, (BlockPos)mutableGlobalPos);
            } else {
                try {
                    IBlockState blockState = Misc.getStateById(this.state);
                    colour = blockState.func_177230_c() instanceof BlockLiquid && blockState.func_177230_c().getLightOpacity(blockState, (IBlockAccess)world, (BlockPos)mutableGlobalPos) != 255 && blockState.func_177230_c().getLightOpacity(blockState, (IBlockAccess)world, (BlockPos)mutableGlobalPos) != 0 ? 25825 : blockState.func_185909_g().field_76291_p;
                }
                catch (Exception blockState) {
                    // empty catch block
                }
            }
        }
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        if (this.colourType != 0 && WorldMap.settings.colours == 0) {
            int c = this.customColour;
            if (block != null) {
                if (this.colourType == 1) {
                    c = mapWriter.getBiomeColor(0, mutableGlobalPos);
                } else if (this.colourType == 2) {
                    c = mapWriter.getBiomeColor(1, mutableGlobalPos);
                }
            } else if (this.colourType == 1) {
                c = mapWriter.getBiomeColor(2, mutableGlobalPos);
            }
            float rMultiplier = (float)r / 255.0f;
            float gMultiplier = (float)g / 255.0f;
            float bMultiplier = (float)b / 255.0f;
            r = (int)((float)(c >> 16 & 0xFF) * rMultiplier);
            g = (int)((float)(c >> 8 & 0xFF) * gMultiplier);
            b = (int)((float)(c & 0xFF) * bMultiplier);
        }
        if (this.glowing) {
            int brightest;
            if (block != null) {
                for (i = 0; i < brightnessBuffer.length; ++i) {
                    brightnessBuffer[i] = 1.0f;
                }
            }
            if ((brightest = Math.max(r, Math.max(g, b))) != 0) {
                r = r * 255 / brightest;
                g = g * 255 / brightest;
                b = b * 255 / brightest;
            }
        } else if (block != null) {
            for (i = 0; i < brightnessBuffer.length; ++i) {
                brightnessBuffer[i] = this.getBlockBrightness(5.0f, this.light, 15, true, Misc.lightLevelToFloat(i));
            }
        }
        if (block != null) {
            for (i = 0; i < postBrightnessBuffer.length; ++i) {
                postBrightnessBuffer[i] = 1.0f;
            }
        }
        int overlayRed = 0;
        int overlayGreen = 0;
        int overlayBlue = 0;
        float divider = 1.0f;
        if (overlays != null && !overlays.isEmpty()) {
            int i2;
            int sun = 15;
            for (i2 = 0; i2 < overlays.size(); ++i2) {
                Overlay o = overlays.get(i2);
                o.getPixelColour(red_dest, green_dest, blue_dest, mapWriter, world, tileChunk, prevTile, mapTile, x, z, null, null, mutableGlobalPos);
                if (i2 == 0) {
                    for (int j = 0; j < postBrightnessBuffer.length; ++j) {
                        postBrightnessBuffer[j] = this.getBlockBrightness(5.0f, o.light, sun, true, Misc.lightLevelToFloat(j));
                    }
                }
                float overlayIntensity = (float)o.getIntensity() * this.getBlockBrightness(5.0f, o.light, sun, false, 0.0f);
                divider += overlayIntensity;
                overlayRed = (int)((float)overlayRed + (float)red_dest[0] * overlayIntensity);
                overlayGreen = (int)((float)overlayGreen + (float)green_dest[0] * overlayIntensity);
                overlayBlue = (int)((float)overlayBlue + (float)blue_dest[0] * overlayIntensity);
                if ((sun -= o.getOpacity()) >= 0) continue;
                sun = 0;
            }
            if (!this.glowing) {
                for (i2 = 0; i2 < brightnessBuffer.length; ++i2) {
                    brightnessBuffer[i2] = this.getBlockBrightness(5.0f, this.light, sun, false, 0.0f);
                }
            }
        }
        if (block != null & !this.glowing) {
            if (block.getHeightType() == 3 && block.getState() != 0) {
                block.fixHeightType(world, x, z, prevTile, mapTile, tileChunk);
                if (block.getHeightType() != 3) {
                    tileChunk.getInRegion().setBeingWritten(true);
                }
            }
            float depthBrightness = 1.0f;
            int block_height = block.getHeight();
            boolean caving = block.isCaveBlock() && block_height != -1 && block_height < 127;
            float caveBrightness = (float)block_height / 127.0f;
            if (!caving && WorldMap.settings.terrainDepth && block_height != -1) {
                depthBrightness = (float)height / 63.0f;
                if ((double)depthBrightness > 1.15) {
                    depthBrightness = 1.15f;
                } else if ((double)depthBrightness < 0.7) {
                    depthBrightness = 0.7f;
                }
            }
            if (WorldMap.settings.terrainSlopes) {
                if (block.getHeightType() == 1) {
                    depthBrightness = (float)((double)depthBrightness * 1.15);
                } else if (block.getHeightType() == 2) {
                    depthBrightness = (float)((double)depthBrightness * 0.85);
                }
            }
            for (int i3 = 0; i3 < brightnessBuffer.length; ++i3) {
                if (caving) {
                    brightnessBuffer[i3] = caveBrightness;
                }
                int n = i3;
                brightnessBuffer[n] = brightnessBuffer[n] * depthBrightness;
                if (!(brightnessBuffer[i3] < 0.0f)) continue;
                brightnessBuffer[i3] = 0.0f;
            }
        }
        for (int i4 = 0; i4 < lightLevels; ++i4) {
            float brightness = block != null ? brightnessBuffer[i4] : 1.0f;
            float postBrightness = block != null ? postBrightnessBuffer[i4] : 1.0f;
            red_dest[i4] = (int)(((float)r * brightness + (float)overlayRed) / divider * postBrightness);
            if (red_dest[i4] > 255) {
                red_dest[i4] = 255;
            }
            green_dest[i4] = (int)(((float)g * brightness + (float)overlayGreen) / divider * postBrightness);
            if (green_dest[i4] > 255) {
                green_dest[i4] = 255;
            }
            blue_dest[i4] = (int)(((float)b * brightness + (float)overlayBlue) / divider * postBrightness);
            if (blue_dest[i4] <= 255) continue;
            blue_dest[i4] = 255;
        }
    }

    public float getBlockBrightness(float min, int l, int sun, boolean dayLight, float sunLevel) {
        return (min + Math.max((dayLight ? sunLevel : 1.0f) * (float)sun, (float)l)) / (15.0f + min);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setLight(byte light) {
        this.light = light;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    public byte getColourType() {
        return this.colourType;
    }

    public void setColourType(byte colourType) {
        this.colourType = colourType;
    }

    public int getCustomColour() {
        return this.customColour;
    }

    public void setCustomColour(int customColour) {
        this.customColour = customColour;
    }
}

