/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import xaero.map.MapWriter;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;

public class MapBlock
extends MapPixel {
    private byte heightType;
    private byte signed_height;
    private ArrayList<Overlay> overlays;
    private boolean caveBlock = false;
    private int biome = -1;

    public boolean isGrass() {
        return (this.state & 0xFFF) == 2;
    }

    public int getParametres() {
        int parametres = 0;
        parametres |= !this.isGrass() ? 1 : 0;
        parametres |= this.getNumberOfOverlays() != 0 ? 2 : 0;
        parametres |= this.colourType << 2;
        parametres |= this.heightType << 4;
        parametres |= this.caveBlock ? 128 : 0;
        parametres |= this.light << 8;
        parametres |= this.getHeight() << 12;
        return parametres |= this.biome != -1 ? 0x100000 : 0;
    }

    public void getPixelColour(int[] red_dest, int[] green_dest, int[] blue_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTile prevTile, MapTile mapTile, int x, int z, float[] brightnessBuffer, float[] postBrightnessBuffer, BlockPos.MutableBlockPos mutableGlobalPos) {
        super.getPixelColours(red_dest, green_dest, blue_dest, mapWriter, world, tileChunk, prevTile, mapTile, x, z, this, this.getHeight(), this.overlays, 4, brightnessBuffer, postBrightnessBuffer, mutableGlobalPos);
    }

    public String toString() {
        return "S: " + this.getState() + ", HT: " + this.heightType + ", H: " + this.getHeight() + ", CT: " + this.colourType + ", B: " + this.biome + ", CC: " + this.customColour + ", L: " + this.light + ", G: " + this.glowing + ", CB: " + this.caveBlock + ", O: " + this.getNumberOfOverlays();
    }

    public boolean equals(MapBlock p) {
        boolean equal;
        boolean bl = equal = p != null && this.state == p.state && this.colourType == p.colourType && this.light == p.light && this.signed_height == p.signed_height && this.caveBlock == p.caveBlock && this.heightType == p.heightType && this.getNumberOfOverlays() == p.getNumberOfOverlays() && this.biome == p.biome && (this.colourType != 3 || this.customColour == p.customColour);
        if (equal && this.getNumberOfOverlays() != 0) {
            for (int i = 0; i < this.overlays.size(); ++i) {
                if (this.overlays.get(i).equals(p.overlays.get(i))) continue;
                return false;
            }
        }
        return equal;
    }

    public void fixHeightType(World world, int x, int z, MapTile prevTile, MapTile mapTile, MapTileChunk tileChunk) {
        int prevHeight = -1;
        if (z == 0) {
            if (prevTile != null && prevTile.isLoaded()) {
                prevHeight = prevTile.getBlock(x, 15).getHeight();
            } else {
                try {
                    Chunk fullPrevChunk = world.func_72964_e(mapTile.getChunkX(), mapTile.getChunkZ() - 1);
                    if (fullPrevChunk != null && fullPrevChunk.func_177410_o()) {
                        prevHeight = fullPrevChunk.func_76611_b(x, 15) - 1;
                    }
                }
                catch (IllegalStateException fullPrevChunk) {}
            }
        } else {
            MapBlock prevPixel = mapTile.getBlock(x, z - 1);
            prevHeight = prevPixel.getHeight();
        }
        int height = this.getHeight();
        if (prevHeight != -1) {
            this.heightType = height > prevHeight ? (byte)1 : (height != prevHeight ? (byte)2 : (byte)0);
        } else if (z == 0 && (mapTile.getChunkZ() & 3) == 0) {
            tileChunk.setSuccess(false);
        }
    }

    public void prepareForWriting() {
        if (this.overlays != null) {
            this.overlays.clear();
        }
        this.customColour = 0;
        this.colourType = 0;
        this.biome = -1;
        this.state = 0;
        this.heightType = (byte)3;
        this.light = 0;
        this.glowing = false;
    }

    public void write(int state, int height, int[] biomeStuff, byte light, boolean glowing, boolean cave) {
        this.state = state;
        this.setHeight(height);
        this.setColourType((byte)biomeStuff[0]);
        if (biomeStuff[1] != -1) {
            this.biome = biomeStuff[1];
        }
        this.setCustomColour(biomeStuff[2]);
        this.light = light;
        this.glowing = glowing;
        boolean bl = this.caveBlock = cave && !glowing;
        if (this.overlays != null && this.overlays.isEmpty()) {
            this.overlays = null;
        }
    }

    public void addOverlay(Overlay o) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        this.overlays.add(o);
    }

    public int getHeight() {
        return this.signed_height & 0xFF;
    }

    public void setHeight(int h) {
        this.signed_height = (byte)h;
    }

    public int getBiome() {
        return this.biome;
    }

    public void setBiome(int biome) {
        this.biome = biome;
    }

    public ArrayList<Overlay> getOverlays() {
        return this.overlays;
    }

    public byte getHeightType() {
        return this.heightType;
    }

    public void setHeightType(byte heightType) {
        this.heightType = heightType;
    }

    public boolean isCaveBlock() {
        return this.caveBlock;
    }

    public void setCaveBlock(boolean caveBlock) {
        this.caveBlock = caveBlock;
    }

    public int getNumberOfOverlays() {
        return this.overlays == null ? 0 : this.overlays.size();
    }
}

