/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.Misc;
import xaero.map.WorldMap;
import xaero.map.animation.Animation;
import xaero.map.animation.SinAnimation;
import xaero.map.animation.SlowingAnimation;
import xaero.map.controls.ControlsHandler;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;

public class GuiMap
extends GuiScreen {
    private static final double ZOOM_STEP = 1.2;
    public static final int WAYPOINT_MENU_SIZE = 7;
    private static final Color white = new Color(255, 255, 255);
    private static final Color whiteTrans = new Color(255, 255, 255, 40);
    private static final Color black = new Color(0, 0, 0, 255);
    private static int errorCounter = 0;
    private static int lastAmountOfRegionsViewed = 1;
    private long loadingAnimationStart;
    private EntityPlayer player;
    private int screenScale = 0;
    private int mouseDownPosX = -1;
    private int mouseDownPosY = -1;
    private int prevMouseDownPosX = -1;
    private int prevMouseDownPosY = -1;
    private float mouseDownCameraX = -1.0f;
    private float mouseDownCameraZ = -1.0f;
    private long mouseDownStartTimeNano = -1L;
    private long prevMouseDownStartTimeNano = -1L;
    private float cameraX = 0.0f;
    private float cameraZ = 0.0f;
    private int[] cameraDestination = null;
    private SlowingAnimation cameraDestinationAnimX = null;
    private SlowingAnimation cameraDestinationAnimZ = null;
    private double scale = 6.0;
    private double destScale = 3.0;
    private Waypoint viewed = null;
    private float waypointHintAlpha = 0.0f;
    private float waypointHintAlphaDest = 0.0f;
    private Animation zoomAnim = new SlowingAnimation(this.scale, this.destScale, 0.88, 0.001);
    private SlowingAnimation waypointHintAlphaAnim = null;
    private boolean waypointMenu = false;
    private boolean shouldRenderWaypointMenu = false;
    private int waypointMenuSelected = 0;
    private int waypointMenuOffset = 0;
    private Waypoint waypointMenuSelectedObject = null;
    private Animation waypointMenuAnimation = null;
    private StringBuilder waypointMenuSearch = new StringBuilder();
    private Pattern waypointMenuSearchPattern = null;
    private Pattern waypointMenuSearchStartPattern = null;
    private static ImprovedFramebuffer primaryScaleFBO = null;
    private float[] colourBuffer = new float[4];
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private int pressedAtX = -1;
    private int pressedAtY = -1;

    public GuiMap(EntityPlayer player) {
        this.player = player;
        this.cameraX = (float)player.field_70165_t;
        this.cameraZ = (float)player.field_70161_v;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.loadingAnimationStart = System.currentTimeMillis();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
        }
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        this.screenScale = scaledresolution.func_78325_e();
    }

    public int getTextureSize(double scale) {
        if (scale >= 1.0) {
            return 16;
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73863_a(int scaledMouseX, int scaledMouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.cameraDestination != null) {
            this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraDestination[0], 0.9, 0.01);
            this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraDestination[1], 0.9, 0.01);
            this.cameraDestination = null;
        }
        if (this.cameraDestinationAnimX != null) {
            this.cameraX = (float)this.cameraDestinationAnimX.getCurrent();
            if ((double)this.cameraX == this.cameraDestinationAnimX.getDestination()) {
                this.cameraDestinationAnimX = null;
            }
        }
        if (this.cameraDestinationAnimZ != null) {
            this.cameraZ = (float)this.cameraDestinationAnimZ.getCurrent();
            if ((double)this.cameraZ == this.cameraDestinationAnimZ.getDestination()) {
                this.cameraDestinationAnimZ = null;
            }
        }
        Object object = MapProcessor.instance.renderThreadPauseSync;
        synchronized (object) {
            if (!MapProcessor.instance.isRenderingPaused()) {
                if (MapProcessor.instance.getCurrentWorldString() != null) {
                    MapRegion region;
                    int mouseXPos = Mouse.getX();
                    int mouseYPos = mc.field_71440_d - Mouse.getY() - 1;
                    if (!Mouse.isButtonDown((int)0)) {
                        if (this.mouseDownPosX != -1) {
                            double downTime = System.nanoTime() - this.mouseDownStartTimeNano;
                            int draggedX = mouseXPos - this.mouseDownPosX;
                            int draggedY = mouseYPos - this.mouseDownPosY;
                            if (downTime < 1.6E7 && this.prevMouseDownStartTimeNano != -1L) {
                                downTime = System.nanoTime() - this.prevMouseDownStartTimeNano;
                                draggedX = mouseXPos - this.prevMouseDownPosX;
                                draggedY = mouseYPos - this.prevMouseDownPosY;
                            }
                            double frameTime60FPS = 1.6666666666666666E7;
                            double speedScale = downTime / frameTime60FPS;
                            double speed_x = (double)(-draggedX) / this.scale / speedScale;
                            double speed_z = (double)(-draggedY) / this.scale / speedScale;
                            this.mouseDownPosX = -1;
                            this.prevMouseDownPosX = -1;
                            this.mouseDownPosY = -1;
                            this.prevMouseDownPosX = -1;
                            this.prevMouseDownStartTimeNano = -1L;
                            double speed = Math.sqrt(speed_x * speed_x + speed_z * speed_z);
                            if (speed > 0.0) {
                                double cos = speed_x / speed;
                                double sin = speed_z / speed;
                                speed = Math.abs(speed) > 500.0 ? Math.copySign(500.0, speed) : speed;
                                double speed_factor = 0.9;
                                double ln = Math.log(speed_factor);
                                double move_distance = -speed / ln;
                                double moveX = cos * move_distance;
                                double moveZ = sin * move_distance;
                                this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, (double)this.cameraX + moveX, 0.9, 0.1);
                                this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, (double)this.cameraZ + moveZ, 0.9, 0.1);
                            }
                        }
                    } else {
                        if (this.mouseDownPosX != -1) {
                            this.cameraX = (float)((double)(this.mouseDownPosX - mouseXPos) / this.scale + (double)this.mouseDownCameraX);
                            this.cameraZ = (float)((double)(this.mouseDownPosY - mouseYPos) / this.scale + (double)this.mouseDownCameraZ);
                        }
                        if (this.mouseDownPosX == -1 || System.nanoTime() - this.mouseDownStartTimeNano > 30000000L) {
                            this.prevMouseDownPosX = this.mouseDownPosX;
                            this.prevMouseDownPosY = this.mouseDownPosY;
                            this.prevMouseDownStartTimeNano = this.mouseDownStartTimeNano;
                            this.mouseDownPosX = mouseXPos;
                            this.mouseDownPosY = mouseYPos;
                            this.mouseDownCameraX = this.cameraX;
                            this.mouseDownCameraZ = this.cameraZ;
                            this.mouseDownStartTimeNano = System.nanoTime();
                            this.cameraDestinationAnimX = null;
                            this.cameraDestinationAnimZ = null;
                        }
                    }
                    int mouseFromCentreX = mouseXPos - mc.field_71443_c / 2;
                    int mouseFromCentreY = mouseYPos - mc.field_71440_d / 2;
                    double oldMousePosX = (double)mouseFromCentreX / this.scale + (double)this.cameraX;
                    double oldMousePosZ = (double)mouseFromCentreY / this.scale + (double)this.cameraZ;
                    double preScale = this.scale;
                    if (this.destScale != this.scale) {
                        if (this.zoomAnim != null) {
                            this.scale = this.zoomAnim.getCurrent();
                        }
                        if (this.zoomAnim == null || Misc.round(this.zoomAnim.getDestination(), 4) != Misc.round(this.destScale, 4)) {
                            this.zoomAnim = new SinAnimation(this.scale, this.destScale, 100L);
                        }
                    }
                    if (this.scale > preScale) {
                        this.cameraX = (float)(oldMousePosX - (double)mouseFromCentreX / this.scale);
                        this.cameraZ = (float)(oldMousePosZ - (double)mouseFromCentreY / this.scale);
                    }
                    GlStateManager.func_179094_E();
                    double mousePosX = (double)mouseFromCentreX / this.scale + (double)this.cameraX;
                    double mousePosZ = (double)mouseFromCentreY / this.scale + (double)this.cameraZ;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                    this.func_73731_b(mc.field_71466_p, (double)Math.round(this.destScale * 100.0) / 100.0 + "x", 2, 2, white.hashCode());
                    int mouseBlockPosX = (int)Math.floor(mousePosX);
                    int mouseBlockPosZ = (int)Math.floor(mousePosZ);
                    if (WorldMap.settings.debug) {
                        int mouseRegX = mouseBlockPosX >> 9;
                        int mouseRegZ = mouseBlockPosZ >> 9;
                        MapRegion reg = MapProcessor.instance.getMapRegion(mouseRegX, mouseRegZ, false);
                        if (reg != null) {
                            MapTileChunk chunk = reg.getChunk(mouseBlockPosX >> 6 & 7, mouseBlockPosZ >> 6 & 7);
                            if (chunk != null) {
                                MapBlock block;
                                this.func_73731_b(mc.field_71466_p, chunk.getX() + " " + chunk.getZ(), 5, 15, white.hashCode());
                                this.func_73731_b(mc.field_71466_p, "loadState: " + chunk.getLoadState(), 5, 25, white.hashCode());
                                this.func_73731_b(mc.field_71466_p, "toUpload: " + Arrays.toString(chunk.getToUpload()), 5, 35, white.hashCode());
                                this.func_73731_b(mc.field_71466_p, String.format("buffers exist: [%s, %s, %s, %s]", chunk.getBuffer(0) != null, chunk.getBuffer(1) != null, chunk.getBuffer(2) != null, chunk.getBuffer(3) != null), 5, 45, white.hashCode());
                                this.func_73731_b(mc.field_71466_p, "glTextures: " + Arrays.toString(chunk.getGlTextures()), 5, 55, white.hashCode());
                                this.func_73731_b(mc.field_71466_p, "success: " + chunk.wasSuccessful(), 5, 65, white.hashCode());
                                this.func_73731_b(mc.field_71466_p, String.format("changed: %s include: %s", chunk.wasChanged(), chunk.includeInSave()), 5, 75, white.hashCode());
                                this.func_73731_b(mc.field_71466_p, "cachePrepared: " + chunk.isCachePrepared(), 5, 85, white.hashCode());
                                MapTile mouseTile = chunk.getTile(mouseBlockPosX >> 4 & 3, mouseBlockPosZ >> 4 & 3);
                                if (mouseTile != null && (block = mouseTile.getBlock(mouseBlockPosX & 0xF, mouseBlockPosZ & 0xF)) != null) {
                                    this.func_73732_a(mc.field_71466_p, block.toString(), this.field_146294_l / 2, 12, white.hashCode());
                                    if (block.getNumberOfOverlays() != 0) {
                                        for (int i = 0; i < block.getOverlays().size(); ++i) {
                                            this.func_73732_a(mc.field_71466_p, block.getOverlays().get(i).toString(), this.field_146294_l / 2, 22 + i * 10, white.hashCode());
                                        }
                                    }
                                }
                            }
                            this.func_73731_b(mc.field_71466_p, "paused: " + reg.isWritingPaused(), 5, 105, white.hashCode());
                            this.func_73731_b(mc.field_71466_p, String.format("writing: %s refreshing: %s", reg.isBeingWritten(), reg.isRefreshing()), 5, 115, white.hashCode());
                            this.func_73731_b(mc.field_71466_p, "shouldCache: " + reg.shouldCache(), 5, 125, white.hashCode());
                            this.func_73731_b(mc.field_71466_p, "saveExists: " + reg.getSaveExists(), 5, 135, white.hashCode());
                            this.func_73731_b(mc.field_71466_p, mouseRegX + " " + mouseRegZ, 5, 145, white.hashCode());
                            this.func_73731_b(mc.field_71466_p, String.format("reg loadState: %s waiting: %s version: %d/%d", reg.getLoadState(), reg.isWaitingForRegionBelow(), reg.getVersion(), MapProcessor.instance.getGlobalVersion()), 5, 155, white.hashCode());
                            this.func_73731_b(mc.field_71466_p, "processed: " + MapProcessor.instance.getToProcess().contains(reg), 5, 165, white.hashCode());
                            this.func_73731_b(mc.field_71466_p, String.format("recache: %s reload: %s", reg.recacheHasBeenRequested(), reg.reloadHasBeenRequested()), 5, 175, white.hashCode());
                        }
                        if (MapProcessor.instance.getCurrentWorldString().split("_").length > 3) {
                            this.func_73731_b(mc.field_71466_p, "MultiWorld ID: " + MapProcessor.instance.getCurrentWorldString().split("_")[3], 5, 185, white.hashCode());
                        }
                        this.func_73731_b(mc.field_71466_p, String.format("regions: %d processed: %d viewed: %d", MapProcessor.instance.getCurrentMapList(MapProcessor.instance.getCurrentDimension()).size(), MapProcessor.instance.getToProcess().size(), lastAmountOfRegionsViewed), 5, 195, white.hashCode());
                        this.func_73731_b(mc.field_71466_p, String.format("toLoad: %d toSave: %d tile pool: %d overlays: %d", MapProcessor.instance.getMapSaveLoad().getSizeOfToLoad(), MapProcessor.instance.getMapSaveLoad().getToSave().size(), MapProcessor.instance.getTilePool().size(), MapProcessor.instance.getOverlayManager().getNumberOfUniqueOverlays()), 5, 205, white.hashCode());
                        long i = Runtime.getRuntime().maxMemory();
                        long j = Runtime.getRuntime().totalMemory();
                        long k = Runtime.getRuntime().freeMemory();
                        long l = j - k;
                        Minecraft.func_71410_x();
                        this.func_73731_b(mc.field_71466_p, String.format("FPS: %d", Minecraft.func_175610_ah()), 5, 225, white.hashCode());
                        this.func_73731_b(mc.field_71466_p, String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, GuiMap.bytesToMb(l), GuiMap.bytesToMb(i)), 5, 235, white.hashCode());
                        this.func_73731_b(mc.field_71466_p, String.format("Allocated: % 2d%% %03dMB", j * 100L / i, GuiMap.bytesToMb(j)), 5, 245, white.hashCode());
                        this.func_73731_b(mc.field_71466_p, String.format("Available VRAM: %dMB", MapProcessor.instance.getMapLimiter().getAvailableVRAM() / 1024), 5, 255, white.hashCode());
                    }
                    this.func_73732_a(mc.field_71466_p, "X: " + mouseBlockPosX + " Z: " + mouseBlockPosZ, this.field_146294_l / 2, 2, white.hashCode());
                    GlStateManager.func_179121_F();
                    int preferredTextureSize = this.getTextureSize(this.scale);
                    if (primaryScaleFBO == null || GuiMap.primaryScaleFBO.field_147621_c != mc.field_71443_c || GuiMap.primaryScaleFBO.field_147618_d != mc.field_71440_d) {
                        if (!Minecraft.func_71410_x().field_71474_y.field_151448_g) {
                            Minecraft.func_71410_x().field_71474_y.func_74306_a(GameSettings.Options.FBO_ENABLE, 0);
                            System.out.println("FBO is off. Turning it on.");
                        }
                        primaryScaleFBO = new ImprovedFramebuffer(mc.field_71443_c, mc.field_71440_d, false);
                    }
                    double fboScale = 0.5;
                    if (preferredTextureSize > 8) {
                        fboScale = Math.max(1.0, Math.floor(this.scale));
                    }
                    double secondaryScale = this.scale / fboScale;
                    if (GuiMap.primaryScaleFBO.field_147616_f == -1) {
                        GlStateManager.func_179121_F();
                        return;
                    }
                    primaryScaleFBO.func_147610_a(false);
                    GuiMap.func_73734_a((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)black.hashCode());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179152_a((float)(1.0f / (float)this.screenScale), (float)(1.0f / (float)this.screenScale), (float)1.0f);
                    GlStateManager.func_179109_b((float)(mc.field_71443_c / 2), (float)(mc.field_71440_d / 2), (float)0.0f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)fboScale, (double)(-fboScale), (double)1.0);
                    GlStateManager.func_179129_p();
                    int flooredCameraX = (int)Math.floor(this.cameraX);
                    int flooredCameraY = (int)Math.floor(this.cameraZ);
                    double cameraXPartial = this.cameraX - (float)flooredCameraX;
                    double cameraYPartial = this.cameraZ - (float)flooredCameraY;
                    if (fboScale == 0.5) {
                        if ((flooredCameraX & 1) != 0) {
                            --flooredCameraX;
                            cameraXPartial += 1.0;
                        }
                        if ((flooredCameraY & 1) != 0) {
                            --flooredCameraY;
                            cameraYPartial += 1.0;
                        }
                    }
                    GlStateManager.func_179109_b((float)(-flooredCameraX), (float)(-flooredCameraY), (float)0.0f);
                    GL11.glEnable((int)3553);
                    double leftBorder = (double)this.cameraX - (double)(mc.field_71443_c / 2) / this.scale;
                    double rightBorder = (double)this.cameraX + (double)(mc.field_71443_c / 2) / this.scale;
                    double topBorder = (double)this.cameraZ - (double)(mc.field_71440_d / 2) / this.scale;
                    double bottomBorder = (double)this.cameraZ + (double)(mc.field_71440_d / 2) / this.scale;
                    int minRegX = (int)leftBorder >> 9;
                    int maxRegX = (int)rightBorder >> 9;
                    int minRegZ = (int)topBorder >> 9;
                    int maxRegZ = (int)bottomBorder >> 9;
                    lastAmountOfRegionsViewed = (maxRegX - minRegX + 1) * (maxRegZ - minRegZ + 1);
                    if (MapProcessor.instance.getMapLimiter().getMostRegionsAtATime() < lastAmountOfRegionsViewed) {
                        MapProcessor.instance.getMapLimiter().setMostRegionsAtATime(lastAmountOfRegionsViewed);
                    }
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                    this.regionBuffer.clear();
                    for (int regX = minRegX; regX <= maxRegX; ++regX) {
                        for (int regZ = minRegZ; regZ <= maxRegZ; ++regZ) {
                            region = MapProcessor.instance.getMapRegion(regX, regZ, MapProcessor.instance.regionExists(regX, regZ));
                            if (region == null) continue;
                            MapRegion mapRegion = region;
                            synchronized (mapRegion) {
                                if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (region.getVersion() != MapProcessor.instance.getGlobalVersion() || region.getLoadState() == 4 && region.shouldCache())) {
                                    if (region.isBeingWritten() && region.getLoadState() == 2) {
                                        region.requestRefresh();
                                    } else {
                                        if (WorldMap.settings.detailed_debug) {
                                            System.out.println("Added to buffer: " + region + " " + region.getVersion() + " " + MapProcessor.instance.getGlobalVersion());
                                        }
                                        this.regionBuffer.add(region);
                                    }
                                }
                            }
                            if (!MapProcessor.instance.isUploadingPaused()) {
                                List<MapRegion> regions = MapProcessor.instance.getCurrentMapList(MapProcessor.instance.getCurrentDimension());
                                regions.remove(region);
                                regions.add(region);
                            }
                            if (region.getLoadState() < 2) {
                                GlStateManager.func_179094_E();
                                GlStateManager.func_179109_b((float)(512 * region.getRegionX() + 256), (float)(512 * region.getRegionZ() + 256), (float)0.0f);
                                float loadingAnimationPassed = System.currentTimeMillis() - this.loadingAnimationStart;
                                if (loadingAnimationPassed > 0.0f) {
                                    int period = 2000;
                                    int numbersOfActors = 3;
                                    float loadingAnimation = loadingAnimationPassed % (float)period / (float)period * 360.0f;
                                    float step = 360.0f / (float)numbersOfActors;
                                    GlStateManager.func_179114_b((float)loadingAnimation, (float)0.0f, (float)0.0f, (float)1.0f);
                                    int numberOfVisibleActors = 1 + (int)loadingAnimationPassed % (3 * period) / period;
                                    for (int i = 0; i < numberOfVisibleActors; ++i) {
                                        GlStateManager.func_179114_b((float)step, (float)0.0f, (float)0.0f, (float)1.0f);
                                        GuiMap.func_73734_a((int)16, (int)-8, (int)32, (int)8, (int)white.hashCode());
                                    }
                                }
                                GlStateManager.func_179121_F();
                            }
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    MapTileChunk chunk = region.getChunk(o, p);
                                    if (chunk == null || chunk.getGlTexture(MapProcessor.instance.getLightLevel()) == -1 || (double)((chunk.getX() + 1) * 64) < leftBorder || (double)(chunk.getX() * 64) > rightBorder || (double)(chunk.getZ() * 64) > bottomBorder || (double)((chunk.getZ() + 1) * 64) < topBorder || !chunk.bindGlTexture(false, MapProcessor.instance.getLightLevel())) continue;
                                    if (preferredTextureSize == 8) {
                                        GL11.glTexParameterf((int)3553, (int)33082, (float)1.0f);
                                    } else {
                                        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                                    }
                                    GuiMap.drawMyTexturedModalRect(64.0f * (float)chunk.getX(), 64.0f * (float)chunk.getZ(), 0, 0, 64.0f, 64.0f);
                                }
                            }
                            if (!WorldMap.settings.debug) continue;
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179109_b((float)(512 * region.getRegionX() + 32), (float)(512 * region.getRegionZ() + 32), (float)0.0f);
                            GlStateManager.func_179152_a((float)10.0f, (float)10.0f, (float)1.0f);
                            this.func_73731_b(mc.field_71466_p, "" + region.getLoadState(), 0, 0, white.hashCode());
                            GlStateManager.func_179121_F();
                        }
                    }
                    MapRegion nextToLoad = MapProcessor.instance.getMapSaveLoad().getNextToLoadByViewing();
                    boolean shouldRequest = false;
                    if (nextToLoad != null) {
                        region = nextToLoad;
                        synchronized (region) {
                            if (!nextToLoad.getWorld().equals(MapProcessor.instance.getCurrentWorldString()) || !nextToLoad.reloadHasBeenRequested()) {
                                shouldRequest = true;
                            }
                        }
                    } else {
                        shouldRequest = true;
                    }
                    if (shouldRequest) {
                        MapRegion.setComparison(mouseBlockPosX >> 9, mouseBlockPosZ >> 9);
                        Collections.sort(this.regionBuffer);
                        for (int i = 0; i < this.regionBuffer.size(); ++i) {
                            MapRegion region2 = this.regionBuffer.get(i);
                            if (region2 == nextToLoad) continue;
                            MapRegion p = region2;
                            synchronized (p) {
                                if (region2.reloadHasBeenRequested() || region2.recacheHasBeenRequested() || region2.getLoadState() != 0 && region2.getLoadState() != 4) {
                                    continue;
                                }
                                MapProcessor.instance.getMapSaveLoad().requestLoad(region2, "Gui");
                                MapProcessor.instance.getMapSaveLoad().setNextToLoadByViewing(region2);
                                break;
                            }
                        }
                    }
                    GuiMap.func_73734_a((int)((mouseBlockPosX >> 4) * 16), (int)((mouseBlockPosZ >> 4) * 16), (int)(((mouseBlockPosX >> 4) + 1) * 16), (int)(((mouseBlockPosZ >> 4) + 1) * 16), (int)whiteTrans.hashCode());
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    ArrayList<Waypoint> renderResult = null;
                    if (SupportMods.minimap()) {
                        boolean waypointMenuReal;
                        Waypoint oldViewed = this.viewed;
                        renderResult = SupportMods.xaeroMinimap.renderWaypoints(this, flooredCameraX, flooredCameraY, mc.field_71443_c, mc.field_71440_d, fboScale, this.scale, mousePosX, mousePosZ, this.waypointMenuSearchPattern, this.waypointMenuSearchStartPattern);
                        boolean bl = waypointMenuReal = renderResult != null && (renderResult.size() > 1 || this.waypointMenu) && scaledMouseX > this.field_146294_l - 20 && scaledMouseY > this.field_146295_m - 20;
                        if (this.waypointMenu != waypointMenuReal) {
                            int animationEnd;
                            this.waypointMenu = waypointMenuReal;
                            int animationStart = this.waypointMenuAnimation != null ? (int)this.waypointMenuAnimation.getCurrent() : (this.waypointMenu ? 500 : 0);
                            int n = animationEnd = this.waypointMenu ? 0 : 500;
                            if (this.waypointMenu) {
                                this.waypointMenuAnimation = new SlowingAnimation(animationStart, animationEnd, 0.7, 0.001);
                                this.shouldRenderWaypointMenu = true;
                            } else {
                                this.waypointMenuAnimation = new Animation(animationStart, animationEnd, 500L);
                            }
                        }
                        if (!this.shouldRenderWaypointMenu) {
                            this.waypointMenuSelected = 0;
                            this.waypointMenuOffset = 0;
                        }
                        if (renderResult != null) {
                            this.viewed = renderResult.remove(0);
                            if (this.viewed != oldViewed) {
                                this.waypointHintAlphaDest = this.viewed != null ? 255.0f : 0.0f;
                                this.waypointHintAlphaAnim = new SlowingAnimation(this.waypointHintAlpha, this.waypointHintAlphaDest, this.waypointHintAlpha < this.waypointHintAlphaDest ? 0.9 : 0.95, 1.0);
                            }
                            if (this.waypointHintAlphaAnim != null) {
                                this.waypointHintAlpha = (float)this.waypointHintAlphaAnim.getCurrent();
                            }
                        }
                    }
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                    primaryScaleFBO.func_147609_e();
                    Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)secondaryScale, (double)secondaryScale, (double)1.0);
                    primaryScaleFBO.func_147612_c();
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    GuiMap.drawMyTexturedModalRect((float)(-mc.field_71443_c / 2) - (float)(cameraXPartial * fboScale), (float)(-mc.field_71440_d / 2) - (float)(cameraYPartial * fboScale), 0, 0, mc.field_71443_c, mc.field_71440_d);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)1.0);
                    GlStateManager.func_179109_b((float)(-this.cameraX), (float)(-this.cameraZ), (float)0.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    if (WorldMap.settings.footsteps) {
                        for (int i = 0; i < MapProcessor.instance.getFootprints().size(); ++i) {
                            Double[] coords = MapProcessor.instance.getFootprints().get(i);
                            this.setColourBuffer(1.0f, 0.1f, 0.1f, 1.0f);
                            this.drawDotOnMap(coords[0], coords[1], 0.0f, 1.0 / this.scale);
                        }
                    }
                    boolean toTheLeft = this.player.field_70165_t < leftBorder;
                    boolean toTheRight = this.player.field_70165_t > rightBorder;
                    boolean down = this.player.field_70161_v > bottomBorder;
                    boolean up = this.player.field_70161_v < topBorder;
                    GlStateManager.func_179147_l();
                    if (toTheLeft || toTheRight || up || down) {
                        double arrowX = this.player.field_70165_t;
                        double arrowZ = this.player.field_70161_v;
                        float a = 0.0f;
                        if (toTheLeft) {
                            a = up ? 1.5f : (down ? 0.5f : 1.0f);
                            arrowX = leftBorder;
                        } else if (toTheRight) {
                            a = up ? 2.5f : (down ? 3.5f : 3.0f);
                            arrowX = rightBorder;
                        }
                        if (down) {
                            arrowZ = bottomBorder;
                        } else if (up) {
                            if (a == 0.0f) {
                                a = 2.0f;
                            }
                            arrowZ = topBorder;
                        }
                        this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                        this.drawFarArrowOnMap(arrowX, arrowZ + 2.0 / this.scale, a, 1.0 / this.scale);
                        this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                        this.drawFarArrowOnMap(arrowX, arrowZ, a, 1.0 / this.scale);
                    } else {
                        this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                        this.drawArrowOnMap(this.player.field_70165_t, this.player.field_70161_v + 2.0 / this.scale, this.player.field_70177_z, 1.0 / this.scale);
                        this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                        this.drawArrowOnMap(this.player.field_70165_t, this.player.field_70161_v, this.player.field_70177_z, 1.0 / this.scale);
                    }
                    GlStateManager.func_179121_F();
                    if (this.shouldRenderWaypointMenu && renderResult != null) {
                        if (this.waypointMenuSelected >= renderResult.size()) {
                            this.waypointMenuSelected = renderResult.size() - 1;
                            this.waypointMenuOffset = Math.max(this.waypointMenuSelected - 7 + 2, 0);
                        }
                        if (this.waypointMenuSelected < 0) {
                            this.waypointMenuSelected = 0;
                        }
                        this.waypointMenuSelectedObject = renderResult.size() > 0 ? renderResult.get(this.waypointMenuSelected) : null;
                        SupportMods.xaeroMinimap.renderSideWaypoints(this, renderResult, this.scale, this.field_146294_l + (int)this.waypointMenuAnimation.getCurrent(), this.field_146295_m, this.waypointMenuOffset, this.waypointMenuSelected);
                        if (this.waypointMenu && this.waypointMenuSearch != null && this.waypointMenuSearch.length() > 0) {
                            this.func_73732_a(mc.field_71466_p, this.waypointMenuSearch.toString(), this.field_146294_l / 2, this.field_146295_m - 15, Waypoint.white);
                        }
                        if (!this.waypointMenu && this.waypointMenuAnimation.getCurrent() == this.waypointMenuAnimation.getDestination()) {
                            this.shouldRenderWaypointMenu = false;
                            this.waypointMenuSearch = new StringBuilder();
                            this.waypointMenuSearchPattern = null;
                            this.waypointMenuSearchStartPattern = null;
                        }
                    }
                    if ((int)this.waypointHintAlpha > 3) {
                        int hintColour = (int)this.waypointHintAlpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179141_d();
                        this.func_73732_a(mc.field_71466_p, "Edit - Right Click     Teleport - T     Disable - H     Delete - Delete", this.field_146294_l / 2, this.field_146295_m - 25, hintColour);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    errorCounter = 0;
                } else {
                    if (errorCounter > 100) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                        ScaledResolution scaledResolution = new ScaledResolution(mc);
                        this.func_73732_a(mc.field_71466_p, "Something went wrong... Please make a screenshot (F2)", scaledResolution.func_78326_a() / 2, scaledResolution.func_78328_b() / 2, white.hashCode());
                        this.func_73732_a(mc.field_71466_p, "and report it to xaero96 on PlanetMinecraft/MinecraftForum!", scaledResolution.func_78326_a() / 2, scaledResolution.func_78328_b() / 2 + 10, white.hashCode());
                        this.func_73732_a(mc.field_71466_p, MapProcessor.instance.getCurrentWorldString(), scaledResolution.func_78326_a() / 2, scaledResolution.func_78328_b() / 2 + 25, white.hashCode());
                        GlStateManager.func_179121_F();
                    }
                    ++errorCounter;
                }
                mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
                this.func_73729_b(this.field_146294_l - 35, 2, 0, 37, 32, 32);
            }
        }
        super.func_73863_a(scaledMouseX, scaledMouseY, partialTicks);
    }

    public void drawDotOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 2.5f, 2.5f, 0, 69, 5, 5, 9729);
    }

    public void drawArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 13.0f, 5.0f, 0, 0, 28, 29, 9729);
    }

    public void drawFarArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle * 90.0f, sc, 27.0f, 13.0f, 26, 0, 54, 13, 9729);
    }

    public void drawObjectOnMap(double x, double z, float angle, double sc, float offX, float offY, int textureX, int textureY, int w, int h, int filter) {
        GlStateManager.func_179094_E();
        GL11.glColor4f((float)this.colourBuffer[0], (float)this.colourBuffer[1], (float)this.colourBuffer[2], (float)this.colourBuffer[3]);
        GlStateManager.func_179137_b((double)x, (double)z, (double)0.0);
        GlStateManager.func_179139_a((double)sc, (double)sc, (double)1.0);
        if (angle != 0.0f) {
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        this.func_175174_a(-offX, -offY, textureX, textureY, w, h);
        if (filter != 9728) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public void mapClicked(int x, int y) {
        if (!this.waypointMenu && this.viewed != null) {
            SupportMods.xaeroMinimap.openWaypoint(this, this.viewed);
            this.mouseDownPosX = -1;
            this.mouseDownPosY = -1;
        }
        if (this.waypointMenu && this.waypointMenuSelectedObject != null) {
            this.cameraDestination = new int[]{this.waypointMenuSelectedObject.getX(), this.waypointMenuSelectedObject.getZ()};
        }
    }

    private void setSearch(String search, String preChange) {
        try {
            this.waypointMenuSearchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.waypointMenuSearchStartPattern = search.charAt(0) == '^' ? this.waypointMenuSearchPattern : Pattern.compile('^' + search.toString().toLowerCase());
            } else {
                this.waypointMenuSearchPattern = null;
                this.waypointMenuSearchStartPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            if (preChange != null) {
                this.waypointMenuSearch = new StringBuilder(preChange);
                this.setSearch(preChange, null);
            }
            throw e;
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (this.waypointMenu) {
            if (par1 != '\u0000') {
                String preChange = this.waypointMenuSearch.toString();
                if (par1 == '\b') {
                    if (this.waypointMenuSearch.length() > 0) {
                        this.waypointMenuSearch.deleteCharAt(this.waypointMenuSearch.length() - 1);
                    }
                } else if (par1 == '\r') {
                    this.waypointMenuSearch = new StringBuilder();
                } else {
                    this.waypointMenuSearch.append(par1);
                }
                this.setSearch(this.waypointMenuSearch.toString(), preChange);
            }
        } else {
            if (par2 == ControlsHandler.keyOpenMap.func_151463_i()) {
                super.func_73869_a(par1, 1);
            }
            if (this.viewed != null) {
                switch (par2) {
                    case 20: {
                        SupportMods.xaeroMinimap.teleportToWaypoint(this, this.viewed);
                        break;
                    }
                    case 35: {
                        SupportMods.xaeroMinimap.disableWaypoint(this.viewed);
                        break;
                    }
                    case 211: {
                        SupportMods.xaeroMinimap.deleteWaypoint(this.viewed);
                    }
                }
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.pressedAtX == -1 && Mouse.isButtonDown((int)1)) {
            this.pressedAtX = Mouse.getX();
            this.pressedAtY = Mouse.getY();
        } else if (this.pressedAtX != -1 && !Mouse.isButtonDown((int)1)) {
            if (Math.abs(this.pressedAtX - Mouse.getX()) < 5 && Math.abs(this.pressedAtY - Mouse.getY()) < 5) {
                this.mapClicked(this.pressedAtX, this.pressedAtY);
            }
            this.pressedAtX = -1;
            this.pressedAtY = -1;
        }
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            int direction;
            int n = direction = wheel > 0 ? 1 : -1;
            if (this.waypointMenu) {
                this.waypointMenuSelected += direction;
                if (this.waypointMenuSelected < 0) {
                    this.waypointMenuSelected = 0;
                }
                if (this.waypointMenuSelected == this.waypointMenuOffset + 7 - 1) {
                    ++this.waypointMenuOffset;
                }
                if (this.waypointMenuOffset > 0 && this.waypointMenuSelected == this.waypointMenuOffset) {
                    --this.waypointMenuOffset;
                }
            } else {
                this.cameraDestinationAnimX = null;
                this.cameraDestinationAnimZ = null;
                this.destScale *= Math.pow(1.2, wheel / 120);
                if (this.destScale < 0.5) {
                    this.destScale = 0.5;
                } else if (this.destScale > 5.0) {
                    this.destScale = 5.0;
                }
            }
        }
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private void setColourBuffer(float r, float g, float b, float a) {
        this.colourBuffer[0] = r;
        this.colourBuffer[1] = g;
        this.colourBuffer[2] = b;
        this.colourBuffer[3] = a;
    }
}

