/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiUpdate;
import xaero.patreon.GuiUpdateAll;
import xaero.patreon.Patreon4;

public class Events {
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    private GuiScreen lastClickOn;
    private static boolean askedToUpdate = false;
    private boolean listenToTextureStitch;

    @SubscribeEvent
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent event) {
        if (event.getGui() instanceof GuiGameOver || event.getGui() instanceof GuiYesNo && this.lastClickOn instanceof GuiGameOver) {
            MapProcessor.instance.onPlayerDied();
        }
        this.lastClickOn = event.getGui();
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiScreenRealmsProxy && ((GuiScreenRealmsProxy)event.getGui()).func_154321_a() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                RealmsTasks.RealmsGetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("task");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = RealmsTasks.RealmsGetServerDetailsTask.class.getDeclaredField("server");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)((GuiScreenRealmsProxy)event.getGui()).func_154321_a())) instanceof RealmsTasks.RealmsGetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (RealmsTasks.RealmsGetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.id != this.latestRealm.id)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (event.getGui() == null) {
            MapProcessor.instance.onGuiClosed();
        }
    }

    @SubscribeEvent
    public void modelBake(TextureStitchEvent.Post event) throws IOException {
        if (this.listenToTextureStitch) {
            MapProcessor.instance.getMapWriter().requestCachedColoursClear();
            MapProcessor.instance.incrementGlobalVersion();
        } else {
            this.listenToTextureStitch = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END) {
            MapProcessor.instance.onRenderProcess(mc);
            mc.field_71454_w = false;
            MapProcessor.instance.resetRenderStartTime();
            Queue<FutureTask<?>> minecraftScheduledTasks = MapProcessor.instance.getMinecraftScheduledTasks();
            ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(MapProcessor.instance.getRenderStartTimeUpdater());
            Queue<FutureTask<?>> queue = minecraftScheduledTasks;
            synchronized (queue) {
                FutureTask[] currentTasks = minecraftScheduledTasks.toArray(new FutureTask[0]);
                minecraftScheduledTasks.clear();
                minecraftScheduledTasks.add((FutureTask<?>)listenablefuturetask);
                for (FutureTask t : currentTasks) {
                    minecraftScheduledTasks.add(t);
                }
            }
        } else if (event.phase == TickEvent.Phase.START && mc.field_71462_r instanceof GuiMap) {
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            int i1 = scaledresolution.func_78326_a();
            int j1 = scaledresolution.func_78328_b();
            int k1 = Mouse.getX() * i1 / mc.field_71443_c;
            int l1 = j1 - Mouse.getY() * j1 / mc.field_71440_d - 1;
            GlStateManager.func_179126_j();
            GlStateManager.func_179083_b((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            mc.field_71460_t.func_78478_c();
            GlStateManager.func_179086_m((int)256);
            ForgeHooksClient.drawScreen((GuiScreen)mc.field_71462_r, (int)k1, (int)l1, (float)0.0f);
            mc.field_71454_w = true;
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiUpdate) {
            askedToUpdate = true;
        } else if (!askedToUpdate && WorldMap.isOutdated && event.getGui() instanceof GuiMainMenu) {
            if (Patreon4.patronPledge >= 5) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdateAll());
            } else {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdate());
            }
            System.out.println("World Map is outdated!");
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        Patreon4.renderCape(WorldMap.fileLayoutID, event);
    }

    @SubscribeEvent
    public void spawnSet(PlayerSetSpawnEvent event) {
        MapProcessor.instance.updateWorldSpawn(event.getNewSpawn());
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld() == Minecraft.func_71410_x().field_71441_e) {
            MapProcessor.instance.onWorldUnload();
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }
}

