/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.proxies;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.client.renderers.block.CrystalModel;
import thaumcraft.common.blocks.world.ore.ShardType;

public class ProxyBlock {
    static ModelResourceLocation[] crystals = new ModelResourceLocation[ShardType.values().length];
    static ModelResourceLocation[] jars = new ModelResourceLocation[4];
    static ModelResourceLocation[] jarsVoid = new ModelResourceLocation[4];
    static ModelResourceLocation fibres;
    private static ModelResourceLocation fluidGooLocation;
    private static ModelResourceLocation taintDustLocation;
    private static ModelResourceLocation fluidDeathLocation;
    private static ModelResourceLocation fluidPureLocation;

    public void setupBlocks() {
        MinecraftForge.EVENT_BUS.register((Object)BlocksTC.levitator);
        MinecraftForge.EVENT_BUS.register((Object)BlocksTC.tube);
        MinecraftForge.EVENT_BUS.register((Object)BlocksTC.redstoneRelay);
        MinecraftForge.EVENT_BUS.register((Object)BlocksTC.patternCrafter);
        MinecraftForge.EVENT_BUS.register((Object)BlocksTC.taintFibre);
        for (int a = 0; a < ShardType.values().length; ++a) {
            ProxyBlock.crystals[a] = new ModelResourceLocation(GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)ShardType.values()[a].getOre()), "normal");
            final ModelResourceLocation mrl = crystals[a];
            ModelLoader.setCustomStateMapper((Block)ShardType.values()[a].getOre(), (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState p_178132_1_) {
                    return mrl;
                }
            });
        }
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)BlocksTC.banner), (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("thaumcraft:banner_cultist"), "inventory"));
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)BlocksTC.mirror), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("thaumcraft:mirror"), new ResourceLocation("thaumcraft:mirror_on")});
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)BlocksTC.mirrorEssentia), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("thaumcraft:mirror_essentia"), new ResourceLocation("thaumcraft:mirror_essentia_on")});
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)BlocksTC.mirror), (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("thaumcraft:mirror_on"), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)BlocksTC.mirrorEssentia), (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("thaumcraft:mirror_essentia_on"), "inventory"));
        Item fluxGooItem = Item.func_150898_a((Block)BlocksTC.fluxGoo);
        ModelBakery.registerItemVariants((Item)fluxGooItem, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fluxGooItem, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return fluidGooLocation;
            }
        });
        ModelLoader.setCustomStateMapper((Block)BlocksTC.fluxGoo, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidGooLocation;
            }
        });
        Item liquidDeathItem = Item.func_150898_a((Block)BlocksTC.liquidDeath);
        ModelBakery.registerItemVariants((Item)liquidDeathItem, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)liquidDeathItem, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return fluidDeathLocation;
            }
        });
        ModelLoader.setCustomStateMapper((Block)BlocksTC.liquidDeath, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidDeathLocation;
            }
        });
        Item purifyingFluidItem = Item.func_150898_a((Block)BlocksTC.purifyingFluid);
        ModelBakery.registerItemVariants((Item)purifyingFluidItem, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)purifyingFluidItem, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return fluidPureLocation;
            }
        });
        ModelLoader.setCustomStateMapper((Block)BlocksTC.purifyingFluid, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidPureLocation;
            }
        });
    }

    static {
        fluidGooLocation = new ModelResourceLocation("thaumcraft:flux_goo", "fluid");
        taintDustLocation = new ModelResourceLocation("thaumcraft:taint_dust", "fluid");
        fluidDeathLocation = new ModelResourceLocation("thaumcraft:liquid_death", "fluid");
        fluidPureLocation = new ModelResourceLocation("thaumcraft:purifying_fluid", "fluid");
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class BakeBlockEventHandler {
        @SubscribeEvent
        public static void onModelBakeEvent(ModelBakeEvent event) {
            TextureAtlasSprite crystalTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b("thaumcraft:blocks/crystal");
            CrystalModel customCrystalModel = new CrystalModel(crystalTexture);
            for (int a = 0; a < ShardType.values().length; ++a) {
                event.getModelRegistry().func_82595_a((Object)crystals[a], (Object)customCrystalModel);
            }
        }
    }
}

