/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;

public class EntitySpellBat
extends EntityMob
implements IEntityAdditionalSpawnData {
    private BlockPos currentFlightTarget;
    public EntityLivingBase owner = null;
    FocusPackage focusPackage;
    private UUID ownerUniqueId;
    private static final DataParameter<Boolean> FRIENDLY = EntityDataManager.func_187226_a(EntitySpellBat.class, (DataSerializer)DataSerializers.field_187198_h);
    public int damBonus = 0;
    private int attackTime;
    FocusEffect[] effects = null;
    public int color = 0xFFFFFF;

    public EntitySpellBat(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.9f);
    }

    public EntitySpellBat(FocusPackage pac, boolean friendly) {
        super(pac.world);
        this.func_70105_a(0.5f, 0.9f);
        this.focusPackage = pac;
        this.setOwner(pac.getCaster());
        this.setIsFriendly(friendly);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FRIENDLY, (Object)false);
    }

    public boolean getIsFriendly() {
        return (Boolean)this.func_184212_Q().func_187225_a(FRIENDLY);
    }

    public void setIsFriendly(boolean par1) {
        this.func_184212_Q().func_187227_b(FRIENDLY, (Object)par1);
    }

    public void writeSpawnData(ByteBuf data) {
        Utils.writeNBTTagCompoundToBuffer(data, this.focusPackage.serialize());
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.focusPackage = new FocusPackage();
            this.focusPackage.deserialize(Utils.readNBTTagCompoundFromBuffer(data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOwner(@Nullable EntityLivingBase ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.func_110124_au();
    }

    @Nullable
    public EntityLivingBase getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.ownerUniqueId)) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
        return this.owner;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187740_w;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187743_y;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187742_x;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase = this.getOwner();
        if (entitylivingbase != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity otherEntity) {
        EntityLivingBase owner = this.getOwner();
        if (otherEntity == owner) {
            return true;
        }
        if (owner != null) {
            return owner.func_184191_r(otherEntity) || otherEntity.func_184191_r((Entity)owner);
        }
        return super.func_184191_r(otherEntity);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.field_70173_aa <= 600 && this.getOwner() != null)) {
            this.func_70106_y();
        }
        this.field_70181_x *= (double)0.6f;
        if (this.func_70089_S() && this.field_70170_p.field_72995_K) {
            if (this.effects == null) {
                this.effects = this.focusPackage.getFocusEffects();
                int r = 0;
                int g = 0;
                int b = 0;
                for (FocusEffect ef : this.effects) {
                    Color c = new Color(FocusEngine.getElementColor(ef.getKey()));
                    r += c.getRed();
                    g += c.getGreen();
                    b += c.getBlue();
                }
                Color c = new Color(r /= this.effects.length, g /= this.effects.length, b /= this.effects.length);
                this.color = c.getRGB();
            }
            if (this.effects != null && this.effects.length > 0) {
                FocusEffect eff = this.effects[this.field_70146_Z.nextInt(this.effects.length)];
                eff.renderParticleFX(this.field_70170_p, this.field_70165_t + this.field_70170_p.field_73012_v.nextGaussian() * 0.125, this.field_70163_u + (double)(this.field_70131_O / 2.0f) + this.field_70170_p.field_73012_v.nextGaussian() * 0.125, this.field_70161_v + this.field_70170_p.field_73012_v.nextGaussian() * 0.125, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_70619_bc() {
        double var1;
        super.func_70619_bc();
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177984_a();
        if (this.func_70638_az() == null) {
            if (!(this.currentFlightTarget == null || this.field_70170_p.func_175623_d(this.currentFlightTarget) && this.currentFlightTarget.func_177956_o() >= 1)) {
                this.currentFlightTarget = null;
            }
            if (this.currentFlightTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.func_174831_c(this.currentFlightTarget) < 4.0) {
                this.currentFlightTarget = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
            }
            var1 = (double)this.currentFlightTarget.func_177958_n() + 0.5 - this.field_70165_t;
            double var3 = (double)this.currentFlightTarget.func_177956_o() + 0.1 - this.field_70163_u;
            double var5 = (double)this.currentFlightTarget.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(var1) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(var3) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(var5) * 0.5 - this.field_70179_y) * (double)0.1f;
            float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70177_z += var8;
        } else {
            var1 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double var3 = this.func_70638_az().field_70163_u + (double)(this.func_70638_az().func_70047_e() * 0.66f) - this.field_70163_u;
            double var5 = this.func_70638_az().field_70161_v - this.field_70161_v;
            this.field_70159_w += (Math.signum(var1) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(var3) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(var5) * 0.5 - this.field_70179_y) * (double)0.1f;
            float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70177_z += var8;
        }
        if (this.func_70638_az() == null) {
            this.func_70624_b(this.findTargetToAttack());
        } else if (this.func_70638_az().func_70089_S()) {
            float f = this.func_70638_az().func_70032_d((Entity)this);
            if (this.func_70685_l((Entity)this.func_70638_az())) {
                this.attackEntity((Entity)this.func_70638_az(), f);
            }
        } else {
            this.func_70624_b(null);
        }
        if (!this.getIsFriendly() && this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75102_a) {
            this.func_70624_b(null);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float par1, float damageMultiplier) {
    }

    protected void func_184231_a(double p_180433_1_, boolean p_180433_3_, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        return super.func_70097_a(par1DamageSource, par2);
    }

    protected void attackEntity(Entity target, float par2) {
        if (this.attackTime <= 0 && par2 < Math.max(2.5f, target.field_70130_N * 1.1f) && target.func_174813_aQ().field_72337_e > this.func_174813_aQ().field_72338_b && target.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
            this.attackTime = 40;
            if (!this.field_70170_p.field_72995_K) {
                RayTraceResult ray = new RayTraceResult(target);
                ray.field_72307_f = target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0);
                Trajectory tra = new Trajectory(this.func_174791_d(), this.func_174791_d().func_72444_a(ray.field_72307_f));
                FocusEngine.runFocusPackage(this.focusPackage.copy(this.getOwner()), new Trajectory[]{tra}, new RayTraceResult[]{ray});
                this.func_70606_j(this.func_110143_aJ() - 1.0f);
            }
            this.func_184185_a(SoundEvents.field_187743_y, 0.5f, 0.9f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.getIsFriendly()) {
            return;
        }
        super.func_82167_n(entityIn);
    }

    protected EntityLivingBase findTargetToAttack() {
        double var1 = 12.0;
        List<EntityLivingBase> list = EntityUtils.getEntitiesInRange(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (Entity)this, EntityLivingBase.class, var1);
        double d = Double.MAX_VALUE;
        EntityLivingBase ret = null;
        for (EntityLivingBase e : list) {
            double ed;
            if (e.field_70128_L) continue;
            if (this.getIsFriendly()) {
                if (!EntityUtils.isFriendly((Entity)this.getOwner(), (Entity)e)) {
                    System.out.println(e);
                    continue;
                }
            } else if (EntityUtils.isFriendly((Entity)this.getOwner(), (Entity)e) || this.func_184191_r((Entity)e)) continue;
            if (!((ed = this.func_70068_e((Entity)e)) < d)) continue;
            d = ed;
            ret = e;
        }
        return ret;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.ownerUniqueId = nbt.func_186857_a("OwnerUUID");
        this.setIsFriendly(nbt.func_74767_n("friendly"));
        try {
            this.focusPackage = new FocusPackage();
            this.focusPackage.deserialize(nbt.func_74775_l("pack"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.ownerUniqueId != null) {
            nbt.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
        nbt.func_74782_a("pack", (NBTBase)this.focusPackage.serialize());
        nbt.func_74757_a("friendly", this.getIsFriendly());
    }

    public boolean func_70601_bi() {
        int var5;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        int var4 = this.field_70170_p.func_175699_k(blockpos);
        return var4 > this.field_70146_Z.nextInt(var5 = 7) ? false : super.func_70601_bi();
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

