/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.essentia;

import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.ICaster;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.codechicken.lib.raytracer.ExtendedMOP;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.codechicken.lib.vec.BlockCoord;
import thaumcraft.codechicken.lib.vec.Cuboid6;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.items.tools.ItemResonator;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.essentia.TileTube;
import thaumcraft.common.tiles.essentia.TileTubeBuffer;
import thaumcraft.common.tiles.essentia.TileTubeFilter;
import thaumcraft.common.tiles.essentia.TileTubeValve;

public class BlockTube
extends BlockTCDevice {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private RayTracer rayTracer = new RayTracer();

    public BlockTube(Class tile) {
        super(Material.field_151573_f, tile);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TileTube) {
            ((TileTube)tile).facing = BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer);
            tile.func_70296_d();
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Boolean[] cons = this.makeConnections(state, worldIn, pos);
        return state.func_177226_a((IProperty)DOWN, (Comparable)cons[0]).func_177226_a((IProperty)UP, (Comparable)cons[1]).func_177226_a((IProperty)NORTH, (Comparable)cons[2]).func_177226_a((IProperty)SOUTH, (Comparable)cons[3]).func_177226_a((IProperty)WEST, (Comparable)cons[4]).func_177226_a((IProperty)EAST, (Comparable)cons[5]);
    }

    private Boolean[] makeConnections(IBlockState state, IBlockAccess world, BlockPos pos) {
        Boolean[] cons = new Boolean[]{false, false, false, false, false, false};
        TileEntity t = world.func_175625_s(pos);
        if (t != null && t instanceof IEssentiaTransport) {
            IEssentiaTransport tube = (IEssentiaTransport)t;
            int a = 0;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (tube.isConnectable(face) && ThaumcraftApiHelper.getConnectableTile(world, pos, face) != null) {
                    cons[a] = true;
                }
                ++a;
            }
        }
        return cons;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        boolean noDoodads = InventoryUtils.isHoldingItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ICaster.class) == null && InventoryUtils.isHoldingItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ItemResonator.class) == null;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileTube) {
            RayTraceResult hit = RayTracer.retraceBlock(world, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos);
            LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
            ((TileTube)tile).addTraceableCuboids(cuboids);
            if (hit != null && hit.subHit >= 0 && hit.subHit <= 6 && !noDoodads) {
                for (IndexedCuboid6 cc : cuboids) {
                    if ((Integer)cc.data != hit.subHit) continue;
                    Vector3 v = new Vector3(pos);
                    Cuboid6 c = cc.sub(v);
                    return new AxisAlignedBB((double)((float)c.min.x), (double)((float)c.min.y), (double)((float)c.min.z), (double)((float)c.max.x), (double)((float)c.max.y), (double)((float)c.max.z)).func_186670_a(pos);
                }
            }
        }
        return super.func_180640_a(state, world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float minx = 0.3125f;
        float maxx = 0.6875f;
        float miny = 0.3125f;
        float maxy = 0.6875f;
        float minz = 0.3125f;
        float maxz = 0.6875f;
        EnumFacing fd = null;
        block8: for (int side = 0; side < 6; ++side) {
            fd = EnumFacing.field_82609_l[side];
            TileEntity te = ThaumcraftApiHelper.getConnectableTile(source, pos, fd);
            if (te == null) continue;
            switch (side) {
                case 0: {
                    miny = 0.0f;
                    continue block8;
                }
                case 1: {
                    maxy = 1.0f;
                    continue block8;
                }
                case 2: {
                    minz = 0.0f;
                    continue block8;
                }
                case 3: {
                    maxz = 1.0f;
                    continue block8;
                }
                case 4: {
                    minx = 0.0f;
                    continue block8;
                }
                case 5: {
                    maxx = 1.0f;
                }
            }
        }
        return new AxisAlignedBB((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTubeBuffer) {
            float f = ((TileTubeBuffer)te).aspects.visSize();
            ((TileTubeBuffer)te).getClass();
            float r = f / 8.0f;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileTubeBuffer)te).aspects.visSize() > 0 ? 1 : 0);
        }
        return 0;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileTube && ((TileTube)te).getEssentiaAmount(EnumFacing.UP) > 0) {
            if (!worldIn.field_72995_K) {
                AuraHelper.polluteAura(worldIn, pos, ((TileTube)te).getEssentiaAmount(EnumFacing.UP), true);
            } else {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.1f, 1.0f + worldIn.field_73012_v.nextFloat() * 0.1f, false);
                for (int a = 0; a < 5; ++a) {
                    FXDispatcher.INSTANCE.drawVentParticles((double)pos.func_177958_n() + 0.33 + (double)worldIn.field_73012_v.nextFloat() * 0.33, (double)pos.func_177956_o() + 0.33 + (double)worldIn.field_73012_v.nextFloat() * 0.33, (double)pos.func_177952_p() + 0.33 + (double)worldIn.field_73012_v.nextFloat() * 0.33, 0.0, 0.0, 0.0, Aspect.FLUX.getColor());
                }
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (state.func_177230_c() == BlocksTC.tubeValve) {
            if (heldItem != null && (heldItem.func_77973_b() instanceof ICaster || heldItem.func_77973_b() instanceof ItemResonator || heldItem.func_77973_b() == Item.func_150898_a((Block)this))) {
                return false;
            }
            te = world.func_175625_s(pos);
            if (te instanceof TileTubeValve) {
                ((TileTubeValve)te).allowFlow = !((TileTubeValve)te).allowFlow;
                world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 3);
                te.func_70296_d();
                if (!world.field_72995_K) {
                    world.func_184133_a(null, pos, SoundsTC.squeek, SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                }
                return true;
            }
        }
        if (state.func_177230_c() == BlocksTC.tubeFilter) {
            te = world.func_175625_s(pos);
            if (te != null && te instanceof TileTubeFilter && player.func_70093_af() && ((TileTubeFilter)te).aspectFilter != null) {
                ((TileTubeFilter)te).aspectFilter = null;
                world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 3);
                te.func_70296_d();
                if (world.field_72995_K) {
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundsTC.key, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
            if (te != null && te instanceof TileTubeFilter && heldItem != null && ((TileTubeFilter)te).aspectFilter == null && heldItem.func_77973_b() instanceof IEssentiaContainerItem) {
                if (((IEssentiaContainerItem)heldItem.func_77973_b()).getAspects(heldItem) != null) {
                    ((TileTubeFilter)te).aspectFilter = ((IEssentiaContainerItem)heldItem.func_77973_b()).getAspects(heldItem).getAspects()[0];
                    world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 3);
                    te.func_70296_d();
                    if (world.field_72995_K) {
                        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundsTC.key, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    }
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && event.getPlayer().field_70170_p.func_180495_p(event.getTarget().func_178782_a()).func_177230_c() == this && (InventoryUtils.isHoldingItem(event.getPlayer(), ICaster.class) != null || InventoryUtils.isHoldingItem(event.getPlayer(), ItemResonator.class) != null)) {
            RayTracer.retraceBlock(event.getPlayer().field_70170_p, event.getPlayer(), event.getTarget().func_178782_a());
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileTube) && !(tile instanceof TileTubeBuffer)) {
            return super.func_180636_a(state, world, pos, start, end);
        }
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        if (tile instanceof TileTube) {
            ((TileTube)tile).addTraceableCuboids(cuboids);
        } else if (tile instanceof TileTubeBuffer) {
            ((TileTubeBuffer)tile).addTraceableCuboids(cuboids);
        }
        ArrayList<ExtendedMOP> list = new ArrayList<ExtendedMOP>();
        this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(pos), this, list);
        return list.size() > 0 ? (RayTraceResult)list.get(0) : super.func_180636_a(state, world, pos, start, end);
    }
}

