/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.renderers.models.block.ModelBellows;
import thaumcraft.client.renderers.models.block.ModelBoreBase;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.devices.TileBellows;
import thaumcraft.common.tiles.essentia.TileTubeBuffer;

public class TileBellowsRenderer
extends TileEntitySpecialRenderer<TileBellows> {
    private ModelBellows model = new ModelBellows();
    private ModelBoreBase model2 = new ModelBoreBase();
    private static final ResourceLocation TEX = new ResourceLocation("thaumcraft", "textures/blocks/bellows.png");
    private static final ResourceLocation TEX_BORE = new ResourceLocation("thaumcraft", "textures/models/bore.png");

    public void renderTileEntityAt(TileBellows bellows, double x, double y, double z, float fq, int destroyStage) {
        float scale = 0.0f;
        EnumFacing dir = EnumFacing.WEST;
        boolean extension = false;
        if (bellows == null) {
            EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
            scale = MathHelper.func_76126_a((float)((float)p.field_70173_aa / 8.0f)) * 0.3f + 0.7f;
        } else {
            scale = bellows.inflation;
            dir = BlockStateUtils.getFacing(bellows.func_145832_p());
            TileEntity te = bellows.func_145831_w().func_175625_s(bellows.func_174877_v().func_177972_a(BlockStateUtils.getFacing(bellows.func_145832_p())));
            if (te != null && te instanceof TileTubeBuffer) {
                extension = true;
            }
        }
        float tscale = 0.125f + scale * 0.875f;
        if (extension) {
            this.func_147499_a(TEX_BORE);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f + (float)dir.func_82601_c()), (float)((float)y + (float)dir.func_96559_d()), (float)((float)z + 0.5f + (float)dir.func_82599_e()));
            switch (dir.func_176734_d().ordinal()) {
                case 0: {
                    GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                case 1: {
                    GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 5: {
                    GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            this.model2.renderNozzle();
            GL11.glPopMatrix();
        }
        this.func_147499_a(TEX);
        GL11.glPushMatrix();
        GL11.glEnable((int)2977);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.translateFromOrientation((float)x, (float)y, (float)z, dir.ordinal());
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        }
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)((scale + 0.1f) / 2.0f), (float)0.5f);
        this.model.Bag.func_78793_a(0.0f, 0.5f, 0.0f);
        this.model.Bag.func_78785_a(0.0625f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-tscale / 2.0f + 0.5f), (float)0.0f);
        this.model.TopPlank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.0f, (float)(tscale / 2.0f - 0.5f), (float)0.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(tscale / 2.0f - 0.5f), (float)0.0f);
        this.model.BottomPlank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.0f, (float)(-tscale / 2.0f + 0.5f), (float)0.0f);
        GL11.glPopMatrix();
        this.model.render();
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    private void translateFromOrientation(double x, double y, double z, int orientation) {
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y - 0.5f), (float)((float)z + 0.5f));
        if (orientation == 0) {
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 1) {
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 2) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (orientation == 4) {
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (orientation == 5) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }
}

