/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.api.research.ResearchStage;
import thaumcraft.client.gui.GuiFocalManipulator;
import thaumcraft.client.gui.GuiResearchPage;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketSyncProgressToServer;
import thaumcraft.common.lib.network.playerdata.PacketSyncResearchFlagsToServer;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.InventoryUtils;

@SideOnly(value=Side.CLIENT)
public class GuiResearchBrowser
extends GuiScreen {
    private static int guiBoundsLeft;
    private static int guiBoundsTop;
    private static int guiBoundsRight;
    private static int guiBoundsBottom;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected float screenZoom = 1.0f;
    protected double curMouseX;
    protected double curMouseY;
    protected double guiMapX;
    protected double guiMapY;
    protected double tempMapX;
    protected double tempMapY;
    private int isMouseButtonDown = 0;
    public static double lastX;
    public static double lastY;
    GuiResearchBrowser instance = null;
    private int screenX;
    private int screenY;
    private int startX = 16;
    private int startY = 16;
    long t = 0L;
    private LinkedList<ResearchEntry> research = new LinkedList();
    static String selectedCategory;
    private ResearchEntry currentHighlight = null;
    private EntityPlayer player = null;
    long popuptime = 0L;
    String popupmessage = "";
    private GuiTextField searchField;
    private static boolean searching;
    private ArrayList<String> categoriesTC = new ArrayList();
    private ArrayList<String> categoriesOther = new ArrayList();
    static int catScrollPos;
    static int catScrollMax;
    public int addonShift = 0;
    private ArrayList<String> invisible = new ArrayList();
    ArrayList<Pair<String, SearchResult>> searchResults = new ArrayList();
    ResourceLocation tx1 = new ResourceLocation("thaumcraft", "textures/gui/gui_research_browser.png");

    public GuiResearchBrowser() {
        this.guiMapX = this.tempMapX = lastX;
        this.curMouseX = this.tempMapX;
        this.guiMapY = this.tempMapY = lastY;
        this.curMouseY = this.tempMapY;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.instance = this;
    }

    public GuiResearchBrowser(double x, double y) {
        this.guiMapX = this.tempMapX = x;
        this.curMouseX = this.tempMapX;
        this.guiMapY = this.tempMapY = y;
        this.curMouseY = this.tempMapY;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.instance = this;
    }

    public void func_73866_w_() {
        this.updateResearch();
    }

    public void updateResearch() {
        if (this.field_146297_k == null) {
            this.field_146297_k = Minecraft.func_71410_x();
        }
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiSearchButton(2, 1, this.field_146295_m - 17, 16, 16, I18n.func_74837_a((String)"tc.search", (Object[])new Object[0])));
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(0, this.field_146289_q, 20, 20, 89, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(15);
        this.searchField.func_146185_a(true);
        this.searchField.func_146189_e(false);
        this.searchField.func_146193_g(0xFFFFFF);
        if (searching) {
            this.searchField.func_146189_e(true);
            this.searchField.func_146205_d(false);
            this.searchField.func_146195_b(true);
            this.searchField.func_146180_a("");
            this.updateSearch();
        }
        this.screenX = this.field_146294_l - 32;
        this.screenY = this.field_146295_m - 32;
        this.research.clear();
        if (selectedCategory == null) {
            Set<String> cats = ResearchCategories.researchCategories.keySet();
            selectedCategory = (String)cats.iterator().next();
        }
        int limit = (int)Math.floor((float)(this.screenY - 28) / 24.0f);
        this.addonShift = 0;
        int count = 0;
        this.categoriesTC.clear();
        this.categoriesOther.clear();
        block0: for (String rcl : ResearchCategories.researchCategories.keySet()) {
            int rt = 0;
            int rco = 0;
            Collection<ResearchEntry> col = ResearchCategories.getResearchCategory((String)rcl).research.values();
            for (ResearchEntry res : col) {
                if (res.hasMeta(ResearchEntry.EnumResearchMeta.AUTOUNLOCK)) continue;
                ++rt;
                if (!ThaumcraftCapabilities.knowsResearch(this.player, res.getKey())) continue;
                ++rco;
            }
            int v = (int)((float)rco / (float)rt * 100.0f);
            ResearchCategory rc = ResearchCategories.getResearchCategory(rcl);
            if (rc.researchKey != null && !ThaumcraftCapabilities.knowsResearchStrict(this.player, rc.researchKey)) continue;
            for (String tcc : ConfigResearch.TCCategories) {
                if (!tcc.equals(rcl)) continue;
                this.categoriesTC.add(rcl);
                this.field_146292_n.add(new GuiCategoryButton(rc, rcl, false, 20 + this.categoriesTC.size(), 1, 10 + this.categoriesTC.size() * 24, 16, 16, I18n.func_74837_a((String)("tc.research_category." + rcl), (Object[])new Object[0]), v));
                continue block0;
            }
            if (++count > limit + catScrollPos || count - 1 < catScrollPos) continue;
            this.categoriesOther.add(rcl);
            this.field_146292_n.add(new GuiCategoryButton(rc, rcl, true, 50 + this.categoriesOther.size(), this.field_146294_l - 17, 10 + this.categoriesOther.size() * 24, 16, 16, I18n.func_74837_a((String)("tc.research_category." + rcl), (Object[])new Object[0]), v));
        }
        if (count > limit || count < catScrollPos) {
            this.addonShift = (this.screenY - 28) % 24 / 2;
            this.field_146292_n.add(new GuiScrollButton(false, 3, this.field_146294_l - 14, 20, 10, 11, ""));
            this.field_146292_n.add(new GuiScrollButton(true, 4, this.field_146294_l - 14, this.screenY + 1, 10, 11, ""));
        }
        catScrollMax = count - limit;
        if (selectedCategory == null || selectedCategory.equals("")) {
            return;
        }
        Collection<ResearchEntry> col = ResearchCategories.getResearchCategory((String)GuiResearchBrowser.selectedCategory).research.values();
        for (ResearchEntry res : col) {
            this.research.add(res);
        }
        guiBoundsLeft = 99999;
        guiBoundsTop = 99999;
        guiBoundsRight = -99999;
        guiBoundsBottom = -99999;
        for (ResearchEntry res : this.research) {
            if (res == null || !this.isVisible(res)) continue;
            if (res.getDisplayColumn() * 24 - this.screenX + 48 < guiBoundsLeft) {
                guiBoundsLeft = res.getDisplayColumn() * 24 - this.screenX + 48;
            }
            if (res.getDisplayColumn() * 24 - 24 > guiBoundsRight) {
                guiBoundsRight = res.getDisplayColumn() * 24 - 24;
            }
            if (res.getDisplayRow() * 24 - this.screenY + 48 < guiBoundsTop) {
                guiBoundsTop = res.getDisplayRow() * 24 - this.screenY + 48;
            }
            if (res.getDisplayRow() * 24 - 24 <= guiBoundsBottom) continue;
            guiBoundsBottom = res.getDisplayRow() * 24 - 24;
        }
    }

    private boolean isVisible(ResearchEntry res) {
        if (ThaumcraftCapabilities.knowsResearch(this.player, res.getKey())) {
            return true;
        }
        if (this.invisible.contains(res.getKey()) || res.hasMeta(ResearchEntry.EnumResearchMeta.HIDDEN) && !this.canUnlockResearch(res)) {
            return false;
        }
        if (res.getParents() == null && res.hasMeta(ResearchEntry.EnumResearchMeta.HIDDEN)) {
            return false;
        }
        if (res.getParents() != null) {
            for (String r : res.getParents()) {
                ResearchEntry ri = ResearchCategories.getResearch(r);
                if (ri == null || this.isVisible(ri)) continue;
                this.invisible.add(r);
                return false;
            }
        }
        return true;
    }

    private boolean canUnlockResearch(ResearchEntry res) {
        return ResearchManager.doesPlayerHaveRequisites(this.player, res.getKey());
    }

    public void func_146281_b() {
        lastX = this.guiMapX;
        lastY = this.guiMapY;
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.updateResearch();
        if (lastX == -9999.0 || this.guiMapX > (double)guiBoundsRight || this.guiMapX < (double)guiBoundsLeft) {
            this.guiMapX = this.tempMapX = (double)((guiBoundsLeft + guiBoundsRight) / 2);
        }
        if (lastY == -9999.0 || this.guiMapY > (double)guiBoundsBottom || this.guiMapY < (double)guiBoundsTop) {
            this.guiMapY = this.tempMapY = (double)((guiBoundsBottom + guiBoundsTop) / 2);
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (searching && this.searchField.func_146201_a(par1, par2)) {
            this.updateSearch();
        } else if (par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
        super.func_73869_a(par1, par2);
    }

    private void updateSearch() {
        this.searchResults.clear();
        this.invisible.clear();
        String s1 = this.searchField.func_146179_b().toLowerCase();
        for (String cat : this.categoriesTC) {
            if (!cat.toLowerCase().contains(s1)) continue;
            this.searchResults.add((Pair<String, SearchResult>)Pair.of((Object)I18n.func_74837_a((String)("tc.research_category." + cat), (Object[])new Object[0]), (Object)new SearchResult(cat, null, true)));
        }
        for (String cat : this.categoriesOther) {
            if (!cat.toLowerCase().contains(s1)) continue;
            this.searchResults.add((Pair<String, SearchResult>)Pair.of((Object)I18n.func_74837_a((String)("tc.research_category." + cat), (Object[])new Object[0]), (Object)new SearchResult(cat, null, true)));
        }
        ArrayList<String> dupCheck = new ArrayList<String>();
        for (String pre : ThaumcraftCapabilities.getKnowledge(this.player).getResearchList()) {
            int s;
            ResearchEntry ri = ResearchCategories.getResearch(pre);
            if (ri == null || ri.getLocalizedName() == null) continue;
            if (ri.getLocalizedName().toLowerCase().contains(s1)) {
                this.searchResults.add((Pair<String, SearchResult>)Pair.of((Object)ri.getLocalizedName(), (Object)new SearchResult(pre, null)));
            }
            int stage = ThaumcraftCapabilities.getKnowledge(this.player).getResearchStage(pre);
            if (ri.getStages() == null) continue;
            int n = s = ri.getStages().length - 1 < stage + 1 ? ri.getStages().length - 1 : stage + 1;
            ResearchStage page = ri.getStages()[s];
            if (page == null || page.getRecipes() == null) continue;
            for (String rec : page.getRecipes()) {
                Object[] recipeArray;
                if (dupCheck.contains(rec)) continue;
                dupCheck.add(rec);
                Object recipeObject = CommonInternals.craftingRecipeCatalog.get(rec);
                ItemStack ro = null;
                for (Object robj : recipeArray = (Object[])recipeObject) {
                    if (robj instanceof IRecipe) {
                        ro = ((IRecipe)robj).func_77571_b();
                    } else if (robj instanceof InfusionRecipe && ((InfusionRecipe)robj).getRecipeOutput() instanceof ItemStack) {
                        ro = (ItemStack)((InfusionRecipe)robj).getRecipeOutput();
                    } else if (robj instanceof CrucibleRecipe) {
                        ro = ((CrucibleRecipe)robj).getRecipeOutput();
                    }
                    if (ro == null || !ro.func_82833_r().toLowerCase().contains(s1)) continue;
                    this.searchResults.add((Pair<String, SearchResult>)Pair.of((Object)ro.func_82833_r(), (Object)new SearchResult(pre, rec)));
                }
            }
        }
        Collections.sort(this.searchResults);
    }

    public void func_73863_a(int mx, int my, float par3) {
        if (!searching) {
            int k;
            if (Mouse.isButtonDown((int)0)) {
                if ((this.isMouseButtonDown == 0 || this.isMouseButtonDown == 1) && mx >= this.startX && mx < this.startX + this.screenX && my >= this.startY && my < this.startY + this.screenY) {
                    if (this.isMouseButtonDown == 0) {
                        this.isMouseButtonDown = 1;
                    } else {
                        this.guiMapX -= (double)(mx - this.mouseX) * (double)this.screenZoom;
                        this.guiMapY -= (double)(my - this.mouseY) * (double)this.screenZoom;
                        this.tempMapX = this.curMouseX = this.guiMapX;
                        this.tempMapY = this.curMouseY = this.guiMapY;
                    }
                    this.mouseX = mx;
                    this.mouseY = my;
                }
                if (this.tempMapX < (double)guiBoundsLeft * (double)this.screenZoom) {
                    this.tempMapX = (double)guiBoundsLeft * (double)this.screenZoom;
                }
                if (this.tempMapY < (double)guiBoundsTop * (double)this.screenZoom) {
                    this.tempMapY = (double)guiBoundsTop * (double)this.screenZoom;
                }
                if (this.tempMapX >= (double)guiBoundsRight * (double)this.screenZoom) {
                    this.tempMapX = (float)guiBoundsRight * this.screenZoom - 1.0f;
                }
                if (this.tempMapY >= (double)guiBoundsBottom * (double)this.screenZoom) {
                    this.tempMapY = (float)guiBoundsBottom * this.screenZoom - 1.0f;
                }
            } else {
                this.isMouseButtonDown = 0;
            }
            if ((k = Mouse.getDWheel()) < 0) {
                this.screenZoom += 0.25f;
            } else if (k > 0) {
                this.screenZoom -= 0.25f;
            }
            this.screenZoom = MathHelper.func_76131_a((float)this.screenZoom, (float)1.0f, (float)2.0f);
        }
        this.func_146276_q_();
        this.t = System.nanoTime() / 50000000L;
        int locX = MathHelper.func_76128_c((double)(this.curMouseX + (this.guiMapX - this.curMouseX) * (double)par3));
        int locY = MathHelper.func_76128_c((double)(this.curMouseY + (this.guiMapY - this.curMouseY) * (double)par3));
        if ((float)locX < (float)guiBoundsLeft * this.screenZoom) {
            locX = (int)((float)guiBoundsLeft * this.screenZoom);
        }
        if ((float)locY < (float)guiBoundsTop * this.screenZoom) {
            locY = (int)((float)guiBoundsTop * this.screenZoom);
        }
        if ((float)locX >= (float)guiBoundsRight * this.screenZoom) {
            locX = (int)((float)guiBoundsRight * this.screenZoom - 1.0f);
        }
        if ((float)locY >= (float)guiBoundsBottom * this.screenZoom) {
            locY = (int)((float)guiBoundsBottom * this.screenZoom - 1.0f);
        }
        this.genResearchBackgroundFixedPre(mx, my, par3, locX, locY);
        if (!searching) {
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / this.screenZoom), (float)(1.0f / this.screenZoom), (float)1.0f);
            this.genResearchBackgroundZoomable(mx, my, par3, locX, locY);
            GL11.glPopMatrix();
        } else {
            this.searchField.func_146194_f();
            int q = 0;
            for (Pair<String, SearchResult> p : this.searchResults) {
                int color;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                SearchResult sr = (SearchResult)p.getRight();
                int n = sr.cat ? 0xDDAAAA : (color = sr.recipe == null ? 0xDDDDDD : 0xAAAADD);
                if (sr.recipe != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(this.tx1);
                    GL11.glPushMatrix();
                    GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                    this.func_73729_b(44, (32 + q * 10) * 2, 224, 48, 16, 16);
                    GL11.glPopMatrix();
                }
                if (mx > 22 && mx < 18 + this.screenX && my >= 32 + q * 10 && my < 40 + q * 10) {
                    color = sr.recipe == null ? 0xFFFFFF : (sr.cat ? 0xFFCCCC : 0xCCCCFF);
                }
                this.field_146289_q.func_78276_b((String)p.getLeft(), 32, 32 + q * 10, color);
                if (32 + (++q + 1) * 10 <= this.screenY) continue;
                this.field_146289_q.func_78276_b(I18n.func_74837_a((String)"tc.search.more", (Object[])new Object[0]), 22, 34 + q * 10, 0xAAAAAA);
                break;
            }
        }
        this.genResearchBackgroundFixedPost(mx, my, par3, locX, locY);
        if (this.popuptime > System.currentTimeMillis()) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(this.popupmessage);
            UtilsFX.drawCustomTooltip(this, this.field_146289_q, text, 10, 34, -99);
        }
    }

    public void func_73876_c() {
        this.curMouseX = this.guiMapX;
        this.curMouseY = this.guiMapY;
        double var1 = this.tempMapX - this.guiMapX;
        double var3 = this.tempMapY - this.guiMapY;
        if (var1 * var1 + var3 * var3 < 4.0) {
            this.guiMapX += var1;
            this.guiMapY += var3;
        } else {
            this.guiMapX += var1 * 0.85;
            this.guiMapY += var3 * 0.85;
        }
    }

    private void genResearchBackgroundFixedPre(int par1, int par2, float par3, int locX, int locY) {
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)518);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
    }

    protected void genResearchBackgroundZoomable(int mx, int my, float par3, int locX, int locY) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GL11.glEnable((int)3042);
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResearchCategories.getResearchCategory((String)GuiResearchBrowser.selectedCategory).background);
        this.drawTexturedModalRectWithDoubles((float)(this.startX - 2) * this.screenZoom, (float)(this.startY - 2) * this.screenZoom, (double)locX / 2.0, (double)locY / 2.0, (float)(this.screenX + 4) * this.screenZoom, (float)(this.screenY + 4) * this.screenZoom);
        if (ResearchCategories.getResearchCategory((String)GuiResearchBrowser.selectedCategory).background2 != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResearchCategories.getResearchCategory((String)GuiResearchBrowser.selectedCategory).background2);
            this.drawTexturedModalRectWithDoubles((float)(this.startX - 2) * this.screenZoom, (float)(this.startY - 2) * this.screenZoom, (double)locX / 1.5, (double)locY / 1.5, (float)(this.screenX + 4) * this.screenZoom, (float)(this.screenY + 4) * this.screenZoom);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        this.field_146297_k.field_71446_o.func_110577_a(this.tx1);
        if (ThaumcraftCapabilities.getKnowledge(this.player).getResearchList() != null) {
            for (int index = 0; index < this.research.size(); ++index) {
                int a;
                ResearchEntry source = this.research.get(index);
                if (source.getParents() != null && source.getParents().length > 0) {
                    for (a = 0; a < source.getParents().length; ++a) {
                        boolean b;
                        ResearchEntry parent;
                        if (source.getParents()[a] == null || ResearchCategories.getResearch(source.getParentsClean()[a]) == null || !ResearchCategories.getResearch(source.getParentsClean()[a]).getCategory().equals(selectedCategory) || (parent = ResearchCategories.getResearch(source.getParentsClean()[a])).getSiblings() != null && Arrays.asList(parent.getSiblings()).contains(source.getKey())) continue;
                        boolean knowsParent = ThaumcraftCapabilities.knowsResearchStrict(this.player, source.getParents()[a]);
                        boolean bl = b = this.isVisible(source) && !source.getParents()[a].startsWith("~");
                        if (!b) continue;
                        if (knowsParent) {
                            this.drawLine(source.getDisplayColumn(), source.getDisplayRow(), parent.getDisplayColumn(), parent.getDisplayRow(), 0.6f, 0.6f, 0.6f, locX, locY, 3.0f, true, source.hasMeta(ResearchEntry.EnumResearchMeta.REVERSE));
                            continue;
                        }
                        if (!this.isVisible(parent)) continue;
                        this.drawLine(source.getDisplayColumn(), source.getDisplayRow(), parent.getDisplayColumn(), parent.getDisplayRow(), 0.2f, 0.2f, 0.2f, locX, locY, 2.0f, true, source.hasMeta(ResearchEntry.EnumResearchMeta.REVERSE));
                    }
                }
                if (source.getSiblings() == null || source.getSiblings().length <= 0) continue;
                for (a = 0; a < source.getSiblings().length; ++a) {
                    if (source.getSiblings()[a] == null || ResearchCategories.getResearch(source.getSiblings()[a]) == null || !ResearchCategories.getResearch(source.getSiblings()[a]).getCategory().equals(selectedCategory)) continue;
                    ResearchEntry sibling = ResearchCategories.getResearch(source.getSiblings()[a]);
                    boolean knowsSibling = ThaumcraftCapabilities.knowsResearchStrict(this.player, sibling.getKey());
                    if (!this.isVisible(source) || source.getSiblings()[a].startsWith("~")) continue;
                    if (knowsSibling) {
                        this.drawLine(sibling.getDisplayColumn(), sibling.getDisplayRow(), source.getDisplayColumn(), source.getDisplayRow(), 0.3f, 0.3f, 0.4f, locX, locY, 1.0f, false, source.hasMeta(ResearchEntry.EnumResearchMeta.REVERSE));
                        continue;
                    }
                    if (!this.isVisible(sibling)) continue;
                    this.drawLine(sibling.getDisplayColumn(), sibling.getDisplayRow(), source.getDisplayColumn(), source.getDisplayRow(), 0.1875f, 0.1875f, 0.25f, locX, locY, 0.0f, false, source.hasMeta(ResearchEntry.EnumResearchMeta.REVERSE));
                }
            }
        }
        this.currentHighlight = null;
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        for (int var24 = 0; var24 < this.research.size(); ++var24) {
            float var38;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            ResearchEntry iconResearch = this.research.get(var24);
            boolean hasWarp = false;
            if (iconResearch.getStages() != null) {
                for (ResearchStage stage : iconResearch.getStages()) {
                    if (stage.getWarp() <= 0) continue;
                    hasWarp = true;
                    break;
                }
            }
            int var26 = iconResearch.getDisplayColumn() * 24 - locX;
            int var27 = iconResearch.getDisplayRow() * 24 - locY;
            if (var26 < -24 || var27 < -24 || !((float)var26 <= (float)this.screenX * this.screenZoom) || !((float)var27 <= (float)this.screenY * this.screenZoom)) continue;
            int iconX = this.startX + var26;
            int iconY = this.startY + var27;
            if (!this.isVisible(iconResearch)) continue;
            if (hasWarp) {
                GuiResearchBrowser.drawForbidden(iconX + 8, iconY + 8);
            }
            if (ThaumcraftCapabilities.getKnowledge(this.player).isResearchComplete(iconResearch.getKey())) {
                var38 = 1.0f;
                GL11.glColor4f((float)var38, (float)var38, (float)var38, (float)1.0f);
            } else if (this.canUnlockResearch(iconResearch)) {
                var38 = (float)Math.sin((double)(Minecraft.func_71386_F() % 600L) / 600.0 * Math.PI * 2.0) * 0.25f + 0.75f;
                GL11.glColor4f((float)var38, (float)var38, (float)var38, (float)1.0f);
            } else {
                var38 = 0.3f;
                GL11.glColor4f((float)var38, (float)var38, (float)var38, (float)1.0f);
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.tx1);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (iconResearch.hasMeta(ResearchEntry.EnumResearchMeta.ROUND)) {
                this.func_73729_b(iconX - 8, iconY - 8, 144, 48 + (iconResearch.hasMeta(ResearchEntry.EnumResearchMeta.HIDDEN) ? 32 : 0), 32, 32);
            } else {
                int ix = 80;
                int iy = 48;
                if (iconResearch.hasMeta(ResearchEntry.EnumResearchMeta.HIDDEN)) {
                    iy += 32;
                }
                if (iconResearch.hasMeta(ResearchEntry.EnumResearchMeta.HEX)) {
                    ix += 32;
                }
                this.func_73729_b(iconX - 8, iconY - 8, ix, iy, 32, 32);
            }
            if (iconResearch.hasMeta(ResearchEntry.EnumResearchMeta.SPIKY)) {
                this.func_73729_b(iconX - 8, iconY - 8, 176, 48 + (iconResearch.hasMeta(ResearchEntry.EnumResearchMeta.HIDDEN) ? 32 : 0), 32, 32);
            }
            boolean bw = false;
            if (!this.canUnlockResearch(iconResearch)) {
                float var40 = 0.1f;
                GL11.glColor4f((float)var40, (float)var40, (float)var40, (float)1.0f);
                this.field_146296_j.func_175039_a(false);
                bw = true;
            }
            if (ThaumcraftCapabilities.getKnowledge(this.player).hasResearchFlag(iconResearch.getKey(), IPlayerKnowledge.EnumResearchFlag.RESEARCH)) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)(iconX - 9), (float)(iconY - 9), (float)0.0f);
                GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
                this.func_73729_b(0, 0, 176, 16, 32, 32);
                GL11.glPopMatrix();
            }
            if (ThaumcraftCapabilities.getKnowledge(this.player).hasResearchFlag(iconResearch.getKey(), IPlayerKnowledge.EnumResearchFlag.PAGE)) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)(iconX - 9), (float)(iconY + 9), (float)0.0f);
                GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
                this.func_73729_b(0, 0, 208, 16, 32, 32);
                GL11.glPopMatrix();
            }
            GuiResearchBrowser.drawResearchIcon(iconResearch, iconX, iconY, this.field_73735_i, bw);
            if (!this.canUnlockResearch(iconResearch)) {
                this.field_146296_j.func_175039_a(true);
                bw = false;
            }
            if (mx >= this.startX && my >= this.startY && mx < this.startX + this.screenX && my < this.startY + this.screenY && (float)mx >= (float)(iconX - 2) / this.screenZoom && (float)mx <= (float)(iconX + 18) / this.screenZoom && (float)my >= (float)(iconY - 2) / this.screenZoom && (float)my <= (float)(iconY + 18) / this.screenZoom) {
                this.currentHighlight = iconResearch;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glDisable((int)2929);
    }

    public static void drawResearchIcon(ResearchEntry iconResearch, int iconX, int iconY, float zLevel, boolean bw) {
        if (iconResearch.getIcons() != null && iconResearch.getIcons().length > 0) {
            String k;
            IFocusElement fp;
            int idx = (int)(System.currentTimeMillis() / 1000L % (long)iconResearch.getIcons().length);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (iconResearch.getIcons()[idx] instanceof ResourceLocation) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a((ResourceLocation)iconResearch.getIcons()[idx]);
                if (bw) {
                    GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
                }
                int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                if (h > w && h % w == 0) {
                    int m = h / w;
                    float q = 16.0f / (float)m;
                    float idx1 = (float)(System.currentTimeMillis() / 150L % (long)m) * q;
                    UtilsFX.drawTexturedQuadF(iconX, iconY, 0.0f, idx1, 16.0f, q, zLevel);
                } else if (w > h && w % h == 0) {
                    int m = w / h;
                    float q = 16.0f / (float)m;
                    float idx1 = (float)(System.currentTimeMillis() / 150L % (long)m) * q;
                    UtilsFX.drawTexturedQuadF(iconX, iconY, idx1, 0.0f, q, 16.0f, zLevel);
                } else {
                    UtilsFX.drawTexturedQuadFull(iconX, iconY, zLevel);
                }
            } else if (iconResearch.getIcons()[idx] instanceof ItemStack) {
                RenderHelper.func_74520_c();
                GL11.glDisable((int)2896);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2903);
                GL11.glEnable((int)2896);
                Minecraft.func_71410_x().func_175599_af().func_180450_b(InventoryUtils.cycleItemStack(iconResearch.getIcons()[idx]), iconX, iconY);
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
            } else if (iconResearch.getIcons()[idx] instanceof String && ((String)iconResearch.getIcons()[idx]).startsWith("focus") && (fp = FocusEngine.getElement((k = ((String)iconResearch.getIcons()[idx]).replaceAll("focus:", "")).trim())) != null && fp instanceof FocusNode) {
                GuiFocalManipulator.drawPart((FocusNode)fp, iconX + 8, iconY + 8, 24.0f, bw ? 50 : 220, false);
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    private void genResearchBackgroundFixedPost(int mx, int my, float par3, int locX, int locY) {
        int p;
        int c;
        this.field_146297_k.field_71446_o.func_110577_a(this.tx1);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (c = 16; c < this.field_146294_l - 16; c += 64) {
            p = 64;
            if (c + p > this.field_146294_l - 16) {
                p = this.field_146294_l - 16 - c;
            }
            if (p <= 0) continue;
            this.func_73729_b(c, -2, 48, 13, p, 22);
            this.func_73729_b(c, this.field_146295_m - 20, 48, 13, p, 22);
        }
        for (c = 16; c < this.field_146295_m - 16; c += 64) {
            p = 64;
            if (c + p > this.field_146295_m - 16) {
                p = this.field_146295_m - 16 - c;
            }
            if (p <= 0) continue;
            this.func_73729_b(-2, c, 13, 48, 22, p);
            this.func_73729_b(this.field_146294_l - 20, c, 13, 48, 22, p);
        }
        this.func_73729_b(-2, -2, 13, 13, 22, 22);
        this.func_73729_b(-2, this.field_146295_m - 20, 13, 13, 22, 22);
        this.func_73729_b(this.field_146294_l - 20, -2, 13, 13, 22, 22);
        this.func_73729_b(this.field_146294_l - 20, this.field_146295_m - 20, 13, 13, 22, 22);
        GL11.glPopMatrix();
        this.field_73735_i = 0.0f;
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        super.func_73863_a(mx, my, par3);
        if (this.currentHighlight != null) {
            ArrayList<String> text = new ArrayList<String>();
            text.add("\u00a76" + this.currentHighlight.getLocalizedName());
            if (this.canUnlockResearch(this.currentHighlight)) {
                if (!ThaumcraftCapabilities.getKnowledge(this.player).isResearchComplete(this.currentHighlight.getKey()) && this.currentHighlight.getStages() != null) {
                    int stage = ThaumcraftCapabilities.getKnowledge(this.player).getResearchStage(this.currentHighlight.getKey());
                    if (stage > 0) {
                        text.add("@@" + TextFormatting.AQUA + I18n.func_74838_a((String)"tc.research.stage") + " " + stage + "/" + this.currentHighlight.getStages().length + TextFormatting.RESET);
                    } else {
                        text.add("@@" + TextFormatting.GREEN + I18n.func_74838_a((String)"tc.research.begin") + TextFormatting.RESET);
                    }
                }
            } else {
                text.add("@@\u00a7c" + I18n.func_74838_a((String)"tc.researchmissing"));
                int a = 0;
                for (String p2 : this.currentHighlight.getParents()) {
                    if (!ThaumcraftCapabilities.knowsResearchStrict(this.player, p2)) {
                        String s = "?";
                        try {
                            s = ResearchCategories.getResearch(this.currentHighlight.getParentsClean()[a]).getLocalizedName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        text.add("@@\u00a7e - " + s);
                    }
                    ++a;
                }
            }
            if (ThaumcraftCapabilities.getKnowledge(this.player).hasResearchFlag(this.currentHighlight.getKey(), IPlayerKnowledge.EnumResearchFlag.RESEARCH)) {
                text.add("@@" + I18n.func_74838_a((String)"tc.research.newresearch"));
            }
            if (ThaumcraftCapabilities.getKnowledge(this.player).hasResearchFlag(this.currentHighlight.getKey(), IPlayerKnowledge.EnumResearchFlag.PAGE)) {
                text.add("@@" + I18n.func_74838_a((String)"tc.research.newpage"));
            }
            UtilsFX.drawCustomTooltip(this, this.field_146289_q, text, mx + 3, my - 3, -99);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        RenderHelper.func_74518_a();
    }

    protected void func_73864_a(int mx, int my, int par3) {
        this.popuptime = System.currentTimeMillis() - 1L;
        if (!searching && this.currentHighlight != null && !ThaumcraftCapabilities.knowsResearch(this.player, this.currentHighlight.getKey()) && this.canUnlockResearch(this.currentHighlight)) {
            this.updateResearch();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncProgressToServer(this.currentHighlight.getKey(), true));
            this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchPage(this.currentHighlight, null, this.guiMapX, this.guiMapY));
            this.popuptime = System.currentTimeMillis() + 3000L;
            this.popupmessage = new TextComponentTranslation(I18n.func_74838_a((String)"tc.research.popup"), new Object[]{"" + this.currentHighlight.getLocalizedName()}).func_150260_c();
        } else if (this.currentHighlight != null && ThaumcraftCapabilities.knowsResearch(this.player, this.currentHighlight.getKey())) {
            ThaumcraftCapabilities.getKnowledge(this.player).clearResearchFlag(this.currentHighlight.getKey(), IPlayerKnowledge.EnumResearchFlag.RESEARCH);
            ThaumcraftCapabilities.getKnowledge(this.player).clearResearchFlag(this.currentHighlight.getKey(), IPlayerKnowledge.EnumResearchFlag.PAGE);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncResearchFlagsToServer((EntityPlayer)this.field_146297_k.field_71439_g, this.currentHighlight.getKey()));
            this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchPage(this.currentHighlight, null, this.guiMapX, this.guiMapY));
        } else if (searching) {
            int q = 0;
            for (Pair<String, SearchResult> p : this.searchResults) {
                SearchResult sr = (SearchResult)p.getRight();
                if (mx > 22 && mx < 18 + this.screenX && my >= 32 + q * 10 && my < 40 + q * 10) {
                    if (ThaumcraftCapabilities.knowsResearch(this.player, sr.key) && !sr.cat) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchPage(ResearchCategories.getResearch(sr.key), sr.recipe, this.guiMapX, this.guiMapY));
                        break;
                    }
                    if (this.categoriesTC.contains(sr.key) || this.categoriesOther.contains(sr.key)) {
                        searching = false;
                        this.searchField.func_146189_e(false);
                        this.searchField.func_146205_d(true);
                        this.searchField.func_146195_b(false);
                        selectedCategory = sr.key;
                        this.updateResearch();
                        this.guiMapX = this.tempMapX = (double)((guiBoundsLeft + guiBoundsRight) / 2);
                        this.guiMapY = this.tempMapY = (double)((guiBoundsBottom + guiBoundsTop) / 2);
                        break;
                    }
                }
                if (32 + (++q + 1) * 10 <= this.screenY) continue;
                break;
            }
        }
        try {
            super.func_73864_a(mx, my, par3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 2) {
            selectedCategory = "";
            searching = true;
            this.searchField.func_146189_e(true);
            this.searchField.func_146205_d(false);
            this.searchField.func_146195_b(true);
            this.searchField.func_146180_a("");
            this.updateSearch();
        }
        if (button.field_146127_k == 3) {
            if (catScrollPos > 0) {
                --catScrollPos;
                this.updateResearch();
            }
        }
        if (button.field_146127_k == 4) {
            if (catScrollPos < catScrollMax) {
                ++catScrollPos;
                this.updateResearch();
            }
        }
        if (button.field_146127_k >= 20 && button instanceof GuiCategoryButton) {
            if (((GuiCategoryButton)button).key != selectedCategory) {
                searching = false;
                this.searchField.func_146189_e(false);
                this.searchField.func_146205_d(true);
                this.searchField.func_146195_b(false);
                selectedCategory = ((GuiCategoryButton)button).key;
                this.updateResearch();
                this.guiMapX = this.tempMapX = (double)((guiBoundsLeft + guiBoundsRight) / 2);
                this.guiMapY = this.tempMapY = (double)((guiBoundsBottom + guiBoundsTop) / 2);
            }
        }
    }

    private void playButtonClick() {
        this.field_146297_k.func_175606_aa().func_184185_a(SoundsTC.clack, 0.4f, 1.0f);
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawLine(int x, int y, int x2, int y2, float r, float g, float b, int locX, int locY, float zMod, boolean arrow, boolean flipped) {
        int v;
        int yy;
        int xx;
        int ym;
        int xm;
        int yd;
        int xd;
        float zt = this.field_73735_i;
        this.field_73735_i += zMod;
        boolean bigCorner = false;
        if (flipped) {
            xd = Math.abs(x2 - x);
            yd = Math.abs(y2 - y);
            int n = xd == 0 ? 0 : (xm = x2 - x > 0 ? -1 : 1);
            int n2 = yd == 0 ? 0 : (ym = y2 - y > 0 ? -1 : 1);
            if (xd > 1 && yd > 1) {
                bigCorner = true;
            }
            xx = x2 * 24 - 4 - locX + this.startX;
            yy = y2 * 24 - 4 - locY + this.startY;
        } else {
            xd = Math.abs(x - x2);
            yd = Math.abs(y - y2);
            int n = xd == 0 ? 0 : (xm = x - x2 > 0 ? -1 : 1);
            int n3 = yd == 0 ? 0 : (ym = y - y2 > 0 ? -1 : 1);
            if (xd > 1 && yd > 1) {
                bigCorner = true;
            }
            xx = x * 24 - 4 - locX + this.startX;
            yy = y * 24 - 4 - locY + this.startY;
        }
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        if (arrow) {
            if (flipped) {
                int xx3 = x * 24 - 8 - locX + this.startX;
                int yy3 = y * 24 - 8 - locY + this.startY;
                if (xm < 0) {
                    this.func_73729_b(xx3, yy3, 160, 112, 32, 32);
                } else if (xm > 0) {
                    this.func_73729_b(xx3, yy3, 128, 112, 32, 32);
                } else if (ym > 0) {
                    this.func_73729_b(xx3, yy3, 64, 112, 32, 32);
                } else if (ym < 0) {
                    this.func_73729_b(xx3, yy3, 96, 112, 32, 32);
                }
            } else if (ym < 0) {
                this.func_73729_b(xx - 4, yy - 4, 64, 112, 32, 32);
            } else if (ym > 0) {
                this.func_73729_b(xx - 4, yy - 4, 96, 112, 32, 32);
            } else if (xm > 0) {
                this.func_73729_b(xx - 4, yy - 4, 160, 112, 32, 32);
            } else if (xm < 0) {
                this.func_73729_b(xx - 4, yy - 4, 128, 112, 32, 32);
            }
        }
        int h = 0;
        for (v = 1; v < yd - (bigCorner ? 1 : 0); ++v) {
            this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 0, 228, 24, 24);
        }
        if (bigCorner) {
            if (xm < 0 && ym > 0) {
                this.func_73729_b(xx + xm * 24 * h - 24, yy + ym * 24 * v, 0, 180, 48, 48);
            }
            if (xm > 0 && ym > 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 48, 180, 48, 48);
            }
            if (xm < 0 && ym < 0) {
                this.func_73729_b(xx + xm * 24 * h - 24, yy + ym * 24 * v - 24, 96, 180, 48, 48);
            }
            if (xm > 0 && ym < 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v - 24, 144, 180, 48, 48);
            }
        } else {
            if (xm < 0 && ym > 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 48, 228, 24, 24);
            }
            if (xm > 0 && ym > 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 72, 228, 24, 24);
            }
            if (xm < 0 && ym < 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 96, 228, 24, 24);
            }
            if (xm > 0 && ym < 0) {
                this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 120, 228, 24, 24);
            }
        }
        v += bigCorner ? 1 : 0;
        h += bigCorner ? 2 : 1;
        while (h < xd) {
            this.func_73729_b(xx + xm * 24 * h, yy + ym * 24 * v, 24, 228, 24, 24);
            ++h;
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
        this.field_73735_i = zt;
    }

    public static void drawForbidden(double x, double y) {
        int count = FMLClientHandler.instance().getClient().field_71439_g.field_70173_aa;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        UtilsFX.renderQuadCentered(UtilsFX.nodeTexture, 32, 32, 160 + count % 32, 90.0f, 0.33f, 0.0f, 0.44f, 220, 1, 0.9f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawTexturedModalRectWithDoubles(float xCoord, float yCoord, double minU, double minV, double maxU, double maxV) {
        float f2 = 0.00390625f;
        float f3 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer VertexBuffer2 = tessellator.func_178180_c();
        VertexBuffer2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        VertexBuffer2.func_181662_b((double)(xCoord + 0.0f), (double)yCoord + maxV, (double)this.field_73735_i).func_187315_a((minU + 0.0) * (double)f2, (minV + maxV) * (double)f3).func_181675_d();
        VertexBuffer2.func_181662_b((double)xCoord + maxU, (double)yCoord + maxV, (double)this.field_73735_i).func_187315_a((minU + maxU) * (double)f2, (minV + maxV) * (double)f3).func_181675_d();
        VertexBuffer2.func_181662_b((double)xCoord + maxU, (double)(yCoord + 0.0f), (double)this.field_73735_i).func_187315_a((minU + maxU) * (double)f2, (minV + 0.0) * (double)f3).func_181675_d();
        VertexBuffer2.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)this.field_73735_i).func_187315_a((minU + 0.0) * (double)f2, (minV + 0.0) * (double)f3).func_181675_d();
        tessellator.func_78381_a();
    }

    static {
        lastX = -9999.0;
        lastY = -9999.0;
        selectedCategory = null;
        searching = false;
        catScrollPos = 0;
        catScrollMax = 0;
    }

    private class GuiSearchButton
    extends GuiButton {
        public GuiSearchButton(int p_i1021_1_, int p_i1021_2_, int p_i1021_3_, int p_i1021_4_, int p_i1021_5_, String p_i1021_6_) {
            super(p_i1021_1_, p_i1021_2_, p_i1021_3_, p_i1021_4_, p_i1021_5_, p_i1021_6_);
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                mc.field_71446_o.func_110577_a(GuiResearchBrowser.this.tx1);
                GL11.glPushMatrix();
                if (this.field_146123_n) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 160, 16, 16, 16);
                GL11.glPopMatrix();
                if (this.field_146123_n) {
                    this.func_73731_b(mc.field_71466_p, this.field_146126_j, this.field_146128_h + 19, this.field_146129_i + 4, 0xFFFFFF);
                }
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }

    private class GuiScrollButton
    extends GuiButton {
        boolean flip;

        public GuiScrollButton(boolean flip, int p_i1021_1_, int p_i1021_2_, int p_i1021_3_, int p_i1021_4_, int p_i1021_5_, String p_i1021_6_) {
            super(p_i1021_1_, p_i1021_2_, p_i1021_3_, p_i1021_4_, p_i1021_5_, p_i1021_6_);
            this.flip = flip;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                mc.field_71446_o.func_110577_a(GuiResearchBrowser.this.tx1);
                GL11.glPushMatrix();
                if (this.field_146123_n) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 51, this.flip ? 71 : 55, 10, 11);
                GL11.glPopMatrix();
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }

    private class GuiCategoryButton
    extends GuiButton {
        ResearchCategory rc;
        String key;
        boolean flip;
        int completion;

        public GuiCategoryButton(ResearchCategory rc, String key, boolean flip, int p_i1021_1_, int p_i1021_2_, int p_i1021_3_, int p_i1021_4_, int p_i1021_5_, String p_i1021_6_, int completion) {
            super(p_i1021_1_, p_i1021_2_, p_i1021_3_, p_i1021_4_, p_i1021_5_, p_i1021_6_);
            this.rc = rc;
            this.key = key;
            this.flip = flip;
            this.completion = completion;
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i + GuiResearchBrowser.this.addonShift && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g + GuiResearchBrowser.this.addonShift;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i + GuiResearchBrowser.this.addonShift && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g + GuiResearchBrowser.this.addonShift;
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                mc.field_71446_o.func_110577_a(GuiResearchBrowser.this.tx1);
                GL11.glPushMatrix();
                if (!selectedCategory.equals(this.key)) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.6f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                this.func_73729_b(this.field_146128_h - 3, this.field_146129_i - 3 + GuiResearchBrowser.this.addonShift, 13, 13, 22, 22);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                mc.field_71446_o.func_110577_a(this.rc.icon);
                if (selectedCategory.equals(this.key) || this.field_146123_n) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.66f, (float)0.66f, (float)0.66f, (float)0.8f);
                }
                UtilsFX.drawTexturedQuadFull(this.field_146128_h, this.field_146129_i + GuiResearchBrowser.this.addonShift, -80.0);
                GL11.glPopMatrix();
                mc.field_71446_o.func_110577_a(GuiResearchBrowser.this.tx1);
                boolean nr = false;
                boolean np = false;
                for (String rk : this.rc.research.keySet()) {
                    if (!ThaumcraftCapabilities.knowsResearch(GuiResearchBrowser.this.player, rk)) continue;
                    if (!nr && ThaumcraftCapabilities.getKnowledge(GuiResearchBrowser.this.player).hasResearchFlag(rk, IPlayerKnowledge.EnumResearchFlag.RESEARCH)) {
                        nr = true;
                    }
                    if (!np && ThaumcraftCapabilities.getKnowledge(GuiResearchBrowser.this.player).hasResearchFlag(rk, IPlayerKnowledge.EnumResearchFlag.PAGE)) {
                        np = true;
                    }
                    if (!nr || !np) continue;
                    break;
                }
                if (nr) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    GL11.glTranslated((double)(this.field_146128_h - 2), (double)(this.field_146129_i + GuiResearchBrowser.this.addonShift - 2), (double)0.0);
                    GL11.glScaled((double)0.25, (double)0.25, (double)1.0);
                    this.func_73729_b(0, 0, 176, 16, 32, 32);
                    GL11.glPopMatrix();
                }
                if (np) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    GL11.glTranslated((double)(this.field_146128_h - 2), (double)(this.field_146129_i + GuiResearchBrowser.this.addonShift + 9), (double)0.0);
                    GL11.glScaled((double)0.25, (double)0.25, (double)1.0);
                    this.func_73729_b(0, 0, 208, 16, 32, 32);
                    GL11.glPopMatrix();
                }
                if (this.field_146123_n) {
                    String dp = this.field_146126_j + " (" + this.completion + "%)";
                    this.func_73731_b(mc.field_71466_p, dp, !this.flip ? this.field_146128_h + 22 : GuiResearchBrowser.this.screenX + 9 - mc.field_71466_p.func_78256_a(dp), this.field_146129_i + 4 + GuiResearchBrowser.this.addonShift, 0xFFFFFF);
                    int t = 9;
                    if (nr) {
                        this.func_73731_b(mc.field_71466_p, I18n.func_74838_a((String)"tc.research.newresearch"), !this.flip ? this.field_146128_h + 22 : GuiResearchBrowser.this.screenX + 9 - mc.field_71466_p.func_78256_a(I18n.func_74838_a((String)"tc.research.newresearch")), this.field_146129_i + 4 + t + GuiResearchBrowser.this.addonShift, 0xFFFFFF);
                        t += 9;
                    }
                    if (np) {
                        this.func_73731_b(mc.field_71466_p, I18n.func_74838_a((String)"tc.research.newpage"), !this.flip ? this.field_146128_h + 22 : GuiResearchBrowser.this.screenX + 9 - mc.field_71466_p.func_78256_a(I18n.func_74838_a((String)"tc.research.newpage")), this.field_146129_i + 4 + t + GuiResearchBrowser.this.addonShift, 0xFFFFFF);
                    }
                }
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }

    private class SearchResult
    implements Comparable {
        String key;
        String recipe;
        boolean cat;

        private SearchResult(String key, String recipe) {
            this.key = key;
            this.recipe = recipe;
            this.cat = false;
        }

        private SearchResult(String key, String recipe, boolean cat) {
            this.key = key;
            this.recipe = recipe;
            this.cat = cat;
        }

        public int compareTo(Object arg0) {
            SearchResult arg = (SearchResult)arg0;
            int k = this.key.compareTo(arg.key);
            return k == 0 && this.recipe != null && arg.recipe != null ? this.recipe.compareTo(arg.recipe) : k;
        }
    }
}

