/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusMedium;
import thaumcraft.api.casters.FocusMediumRoot;
import thaumcraft.api.casters.FocusMod;
import thaumcraft.api.casters.FocusModSplit;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.casters.Trajectory;

public class FocusEngine {
    public static HashMap<String, Class<IFocusElement>> elements = new HashMap();
    private static HashMap<String, ResourceLocation> elementIcons = new HashMap();
    private static HashMap<String, Integer> elementColor = new HashMap();
    private static ArrayList<String> damageResistList = new ArrayList();

    public static void registerElement(Class element, ResourceLocation icon, int color) {
        try {
            IFocusElement fe = (IFocusElement)element.newInstance();
            elements.put(fe.getKey(), element);
            elementIcons.put(fe.getKey(), icon);
            elementColor.put(fe.getKey(), color);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IFocusElement getElement(String key) {
        try {
            return elements.get(key).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ResourceLocation getElementIcon(String key) {
        return elementIcons.get(key);
    }

    public static int getElementColor(String key) {
        return elementColor.get(key);
    }

    public static boolean doesPackageContainElement(FocusPackage focusPackage, String key) {
        for (IFocusElement node : focusPackage.nodes) {
            if (!node.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public static void castFocusPackage(EntityLivingBase caster, FocusPackage focusPackage) {
        FocusPackage focusPackageCopy = focusPackage.copy(caster);
        focusPackageCopy.initialize(caster);
        focusPackageCopy.setUniqueID(UUID.randomUUID());
        for (FocusEffect effect : focusPackageCopy.getFocusEffects()) {
            effect.onCast((Entity)caster);
        }
        FocusEngine.runFocusPackage(focusPackageCopy, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runFocusPackage(FocusPackage focusPackage, Trajectory[] trajectories, RayTraceResult[] targets) {
        Trajectory[] prevTrajectories = trajectories;
        RayTraceResult[] prevTargets = targets;
        List<IFocusElement> list = focusPackage.nodes;
        synchronized (list) {
            if (!(focusPackage.nodes.get(0) instanceof FocusMediumRoot)) {
                focusPackage.nodes.add(0, new FocusMediumRoot(trajectories, targets));
            }
            for (int idx = 0; idx < focusPackage.nodes.size(); ++idx) {
                focusPackage.setExecutionIndex(idx);
                IFocusElement node = focusPackage.nodes.get(idx);
                if (idx > 0 && ((FocusNode)node).getParent() == null) {
                    IFocusElement nodePrev = focusPackage.nodes.get(idx - 1);
                    if (node instanceof FocusNode && nodePrev instanceof FocusNode) {
                        ((FocusNode)node).setParent((FocusNode)nodePrev);
                    }
                }
                if (node instanceof FocusNode && ((FocusNode)node).getPackage() == null) {
                    ((FocusNode)node).setPackage(focusPackage);
                }
                if (node instanceof FocusNode) {
                    focusPackage.multiplyPower(((FocusNode)node).getPowerMultiplier());
                }
                if (node instanceof FocusPackage) {
                    FocusEngine.runFocusPackage((FocusPackage)node, prevTrajectories, prevTargets);
                    break;
                }
                if (node instanceof FocusMedium) {
                    FocusMedium medium = (FocusMedium)node;
                    if (prevTrajectories != null) {
                        for (Trajectory trajectory : prevTrajectories) {
                            medium.execute(trajectory);
                        }
                    }
                    if (medium.hasIntermediary()) {
                        break;
                    }
                } else if (node instanceof FocusMod) {
                    if (node instanceof FocusModSplit) {
                        FocusModSplit split = (FocusModSplit)node;
                        for (FocusPackage sp : split.getSplitPackages()) {
                            split.setPackage(sp);
                            sp.multiplyPower(focusPackage.getPower());
                            split.execute();
                            FocusEngine.runFocusPackage(sp, split.supplyTrajectories(), split.supplyTargets());
                        }
                        break;
                    }
                    ((FocusMod)node).execute();
                } else if (node instanceof FocusEffect) {
                    FocusEffect effect = (FocusEffect)node;
                    if (prevTargets != null) {
                        int num = 0;
                        for (RayTraceResult target : prevTargets) {
                            if (target.field_72308_g != null) {
                                String k = target.field_72308_g.func_145782_y() + focusPackage.getUniqueID().toString();
                                if (damageResistList.contains(k) && target.field_72308_g.field_70172_ad > 0) {
                                    target.field_72308_g.field_70172_ad = 0;
                                } else {
                                    if (damageResistList.size() > 10) {
                                        damageResistList.remove(0);
                                    }
                                    damageResistList.add(k);
                                }
                            }
                            Trajectory tra = prevTrajectories != null ? (prevTrajectories.length == prevTargets.length ? prevTrajectories[num] : prevTrajectories[0]) : null;
                            effect.execute(target, tra, focusPackage.getPower(), num);
                            ++num;
                        }
                    }
                }
                if (!(node instanceof FocusNode)) continue;
                prevTrajectories = ((FocusNode)node).supplyTrajectories();
                prevTargets = ((FocusNode)node).supplyTargets();
            }
        }
    }
}

