/*
 * Decompiled with CFR 0.152.
 */
package net.tofweb.starlite;

import java.util.LinkedList;
import net.tofweb.starlite.BlockManager;
import net.tofweb.starlite.Cell;
import net.tofweb.starlite.CellSpace;
import net.tofweb.starlite.Geometry;
import net.tofweb.starlite.Path;

public class Pathfinder {
    private Path path = new Path();
    private BlockManager blockManager;

    public Pathfinder(BlockManager blockManager) {
        this.blockManager = blockManager;
    }

    public Path findPath() {
        this.path.clear();
        CellSpace space = this.blockManager.getSpace();
        LinkedList<Object> potentialNextCells = new LinkedList();
        Cell currentCell = space.getStartCell();
        if (space.getG(space.getStartCell()) == Double.POSITIVE_INFINITY) {
            return this.path;
        }
        boolean isTrapped = false;
        while (!currentCell.equals(space.getGoalCell()) && !isTrapped) {
            isTrapped = true;
            this.path.add(currentCell);
            potentialNextCells = space.getSuccessors(currentCell);
            if (potentialNextCells.isEmpty()) {
                return this.path;
            }
            double minimumCost = Double.POSITIVE_INFINITY;
            Cell minimumCell = new Cell();
            for (Cell cell : potentialNextCells) {
                if (this.blockManager.isBlocked(cell)) continue;
                isTrapped = false;
                double costToMove = Geometry.euclideanDistance(currentCell, cell);
                double euclideanDistance = Geometry.euclideanDistance(cell, space.getGoalCell()) + Geometry.euclideanDistance(space.getStartCell(), cell);
                if (space.isClose(costToMove += space.getG(cell), minimumCost)) {
                    if (!(0.0 > euclideanDistance)) continue;
                    minimumCost = costToMove;
                    minimumCell = cell;
                    continue;
                }
                if (!(costToMove < minimumCost)) continue;
                minimumCost = costToMove;
                minimumCell = cell;
            }
            if (isTrapped) continue;
            potentialNextCells.clear();
            currentCell = new Cell(minimumCell);
        }
        if (!isTrapped) {
            this.path.add(space.getGoalCell());
        }
        this.path.setComplete(this.blockManager.getSpace().getGoalCell().equals(this.path.getLast()));
        return this.path;
    }
}

