/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util;

import com.khorn.terraincontrol.exception.InvalidConfigException;
import java.util.Random;

public enum Rotation {
    NORTH(0),
    WEST(1),
    SOUTH(2),
    EAST(3);

    private final int ROTATION_ID;

    private Rotation(int id) {
        this.ROTATION_ID = id;
    }

    public int getRotationId() {
        return this.ROTATION_ID;
    }

    public static Rotation getRotation(int id) {
        for (Rotation rotation : Rotation.values()) {
            if (rotation.ROTATION_ID != id) continue;
            return rotation;
        }
        return null;
    }

    public static Rotation getRandomRotation(Random random) {
        return Rotation.values()[random.nextInt(Rotation.values().length)];
    }

    public Rotation next() {
        int id = this.getRotationId();
        if (++id >= Rotation.values().length) {
            id = 0;
        }
        return Rotation.getRotation(id);
    }

    public static Rotation getRotation(String string) throws InvalidConfigException {
        Rotation rotation = null;
        try {
            rotation = Rotation.getRotation(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (rotation != null) {
            return rotation;
        }
        try {
            rotation = Rotation.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (rotation != null) {
            return rotation;
        }
        throw new InvalidConfigException("Unknown rotation: " + string);
    }
}

