/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util;

import com.khorn.terraincontrol.util.helpers.MathHelper;

public class ChunkCoordinate {
    public static final int CHUNK_X_SIZE = 16;
    public static final int CHUNK_Y_SIZE = 256;
    public static final int CHUNK_Z_SIZE = 16;
    private static final int CHUNK_POPULATION_OFFSET_X = 7;
    private static final int CHUNK_POPULATION_OFFSET_Z = 7;
    private final int chunkX;
    private final int chunkZ;

    protected ChunkCoordinate(int chunkX, int chunkZ) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public int hashCode() {
        return this.chunkX >> 13 ^ this.chunkZ;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof ChunkCoordinate)) {
            return false;
        }
        ChunkCoordinate otherChunkCoordinate = (ChunkCoordinate)otherObject;
        if (otherChunkCoordinate.chunkX != this.chunkX) {
            return false;
        }
        return otherChunkCoordinate.chunkZ == this.chunkZ;
    }

    public static ChunkCoordinate getPopulatingChunk(int blockX, int blockZ) {
        return new ChunkCoordinate(MathHelper.floor((double)(blockX - 7) / 16.0), MathHelper.floor((double)(blockZ - 7) / 16.0));
    }

    public static ChunkCoordinate fromBlockCoords(int blockX, int blockZ) {
        return new ChunkCoordinate(MathHelper.floor((double)blockX / 16.0), MathHelper.floor((double)blockZ / 16.0));
    }

    public static ChunkCoordinate fromChunkCoords(int chunkX, int chunkZ) {
        return new ChunkCoordinate(chunkX, chunkZ);
    }

    public String toString() {
        return this.chunkX + "," + this.chunkZ;
    }

    public int getBlockXCenter() {
        return this.chunkX * 16 + 7;
    }

    public int getBlockZCenter() {
        return this.chunkZ * 16 + 7;
    }

    public int getBlockX() {
        return this.chunkX * 16;
    }

    public int getBlockZ() {
        return this.chunkZ * 16;
    }

    public boolean coordsMatch(int chunkX, int chunkZ) {
        return this.chunkX == chunkX && this.chunkZ == chunkZ;
    }

    public boolean populatesForBlock(int blockX, int blockZ) {
        return this.coordsMatch(MathHelper.floor((double)(blockX - 7) / 16.0), MathHelper.floor((double)(blockZ - 7) / 16.0));
    }
}

