/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.logging;

import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.List;

public abstract class Logger {
    protected LogMarker minimumLevel = LogMarker.INFO;

    public void setLevel(LogMarker level) {
        this.minimumLevel = level;
    }

    public void log(LogMarker level, List<String> message) {
        this.log(level, "{}", StringHelper.join(message, " "));
    }

    public abstract void log(LogMarker var1, String var2, Object ... var3);

    public void logIfLevel(LogMarker ifLevel, List<String> messages) {
        if (this.minimumLevel == ifLevel) {
            this.log(ifLevel, messages);
        }
    }

    public void logIfLevel(LogMarker ifLevel, String message, Object ... params) {
        if (this.minimumLevel == ifLevel) {
            this.log(ifLevel, message, params);
        }
    }

    public void logIfLevel(LogMarker min, LogMarker max, List<String> messages) {
        if (this.minimumLevel.compareTo(max) <= 0 && this.minimumLevel.compareTo(min) >= 0) {
            this.log(max, messages);
        }
    }

    public void logIfLevel(LogMarker min, LogMarker max, String message, Object ... params) {
        if (this.minimumLevel.compareTo(max) <= 0 && this.minimumLevel.compareTo(min) >= 0) {
            this.log(max, message, params);
        }
    }
}

