/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.surface;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.generator.ChunkBuffer;
import com.khorn.terraincontrol.generator.GeneratingChunk;
import com.khorn.terraincontrol.generator.surface.SurfaceGenerator;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;

public class SimpleSurfaceGenerator
implements SurfaceGenerator {
    private final LocalMaterialData air = TerrainControl.toLocalMaterialData(DefaultMaterial.AIR, 0);
    private final LocalMaterialData sandstone = TerrainControl.toLocalMaterialData(DefaultMaterial.SANDSTONE, 0);

    @Override
    public void spawn(GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, BiomeConfig biomeConfig, int xInWorld, int zInWorld) {
        this.spawnColumn(biomeConfig.surfaceBlock, biomeConfig.groundBlock, generatingChunk, chunkBuffer, biomeConfig, xInWorld & 0xF, zInWorld & 0xF);
    }

    protected final void spawnColumn(LocalMaterialData defaultSurfaceBlock, LocalMaterialData defaultGroundBlock, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, BiomeConfig biomeConfig, int x, int z) {
        WorldConfig worldConfig = biomeConfig.worldConfig;
        float currentTemperature = biomeConfig.biomeTemperature;
        int surfaceBlocksNoise = (int)(generatingChunk.getNoise(x, z) / 3.0 + 3.0 + generatingChunk.random.nextDouble() * 0.25);
        if (worldConfig.ceilingBedrock) {
            chunkBuffer.setBlock(x, generatingChunk.heightCap - 2, z, worldConfig.bedrockBlock);
        }
        LocalMaterialData currentSurfaceBlock = defaultSurfaceBlock;
        LocalMaterialData currentGroundBlock = defaultGroundBlock;
        int surfaceBlocksCount = -1;
        int currentWaterLevel = generatingChunk.getWaterLevel(x, z);
        for (int y = 255; y >= 0; --y) {
            if (generatingChunk.mustCreateBedrockAt(worldConfig, y)) {
                chunkBuffer.setBlock(x, y, z, worldConfig.bedrockBlock);
                continue;
            }
            LocalMaterialData blockOnCurrentPos = chunkBuffer.getBlock(x, y, z);
            if (blockOnCurrentPos.isAir()) {
                surfaceBlocksCount = -1;
                continue;
            }
            if (!blockOnCurrentPos.equals(biomeConfig.stoneBlock)) continue;
            if (surfaceBlocksCount == -1) {
                if (surfaceBlocksNoise <= 0 && !worldConfig.removeSurfaceStone) {
                    currentSurfaceBlock = this.air;
                    currentGroundBlock = biomeConfig.stoneBlock;
                } else if (y >= currentWaterLevel - 4 && y <= currentWaterLevel + 1) {
                    currentSurfaceBlock = defaultSurfaceBlock;
                    currentGroundBlock = defaultGroundBlock;
                }
                if (y < currentWaterLevel && y > worldConfig.waterLevelMin && currentSurfaceBlock.isAir()) {
                    currentSurfaceBlock = currentTemperature < 0.15f ? biomeConfig.iceBlock : biomeConfig.waterBlock;
                }
                surfaceBlocksCount = surfaceBlocksNoise;
                if (y >= currentWaterLevel - 1) {
                    chunkBuffer.setBlock(x, y, z, currentSurfaceBlock);
                    continue;
                }
                chunkBuffer.setBlock(x, y, z, currentGroundBlock);
                continue;
            }
            if (surfaceBlocksCount <= 0) continue;
            chunkBuffer.setBlock(x, y, z, currentGroundBlock);
            if (--surfaceBlocksCount != 0 || !currentGroundBlock.isMaterial(DefaultMaterial.SAND)) continue;
            surfaceBlocksCount = generatingChunk.random.nextInt(4);
            currentGroundBlock = this.sandstone;
        }
    }

    @Override
    public String toString() {
        return "";
    }
}

