/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class CustomObjectGen
extends Resource {
    private List<CustomObject> objects;
    private List<String> objectNames;

    public CustomObjectGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        if (args.isEmpty() || args.size() == 1 && args.get(0).trim().isEmpty()) {
            args = new ArrayList<String>();
            args.add("UseWorld");
        }
        this.objects = new ArrayList<CustomObject>();
        this.objectNames = new ArrayList<String>();
        for (String arg : args) {
            CustomObject object = ((BiomeConfig)this.getHolder()).worldConfig.worldObjects.parseCustomObject(arg);
            if (object == null || !object.canSpawnAsObject()) {
                throw new InvalidConfigException("No custom object found with the name " + arg);
            }
            this.objects.add(object);
            this.objectNames.add(arg);
        }
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z) {
    }

    @Override
    protected void spawnInChunk(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        for (CustomObject object : this.objects) {
            object.process(world, random, chunkCoord);
        }
    }

    @Override
    public String toString() {
        return "CustomObject(" + StringHelper.join(this.objectNames, ",") + ")";
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        if (this.getClass() == other.getClass()) {
            try {
                CustomObjectGen otherO = (CustomObjectGen)other;
                return otherO.objectNames.size() == this.objectNames.size() && otherO.objectNames.containsAll(this.objectNames);
            }
            catch (Exception ex) {
                TerrainControl.log(LogMarker.WARN, ex.getMessage(), new Object[0]);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + super.hashCode();
        hash = 41 * hash + (this.objects != null ? this.objects.hashCode() : 0);
        hash = 41 * hash + (this.objectNames != null ? this.objectNames.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CustomObjectGen compare = (CustomObjectGen)other;
        return (this.objects == null ? this.objects == compare.objects : this.objects.equals(compare.objects)) && (this.objectNames == null ? this.objectNames == compare.objectNames : this.objectNames.equals(compare.objectNames));
    }

    @Override
    public int getPriority() {
        return -40;
    }
}

