/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome.layers;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.configuration.BiomeGroup;
import com.khorn.terraincontrol.configuration.BiomeGroupManager;
import com.khorn.terraincontrol.generator.biome.ArraysCache;
import com.khorn.terraincontrol.generator.biome.layers.Layer;
import java.util.Map;
import java.util.SortedMap;

public class LayerBiome
extends Layer {
    private BiomeGroupManager manager;
    private int depth;
    private double freezeTemp;

    public LayerBiome(long seed, Layer childLayer, BiomeGroupManager groupManager, int depth, double freezeTemp) {
        super(seed);
        this.child = childLayer;
        this.manager = groupManager;
        this.depth = depth;
        this.freezeTemp = freezeTemp;
    }

    @Override
    public int[] getInts(ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        for (int i = 0; i < zSize; ++i) {
            for (int j = 0; j < xSize; ++j) {
                BiomeGroup group;
                SortedMap<Integer, LocalBiome> possibleBiomes;
                this.initChunkSeed(j + x, i + z);
                int currentPiece = childInts[j + i * xSize];
                if ((currentPiece & 0xFE000) != 0 && (currentPiece & 0x3FF) == 0 && !(possibleBiomes = (group = this.manager.getGroupById((currentPiece & 0xFE000) >> 13)).getDepthMap(this.depth)).isEmpty()) {
                    int newBiomeRarity = this.nextInt(BiomeGroupManager.getMaxRarityFromPossibles(possibleBiomes));
                    for (Map.Entry<Integer, LocalBiome> biome : possibleBiomes.entrySet()) {
                        if (newBiomeRarity >= biome.getKey()) continue;
                        if (biome.getValue() == null) break;
                        currentPiece |= biome.getValue().getIds().getGenerationId() | ((double)biome.getValue().getBiomeConfig().biomeTemperature <= this.freezeTemp ? 4096 : 0);
                        break;
                    }
                }
                thisInts[j + i * xSize] = currentPiece;
            }
        }
        return thisInts;
    }
}

