/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.bo3.BO3;
import com.khorn.terraincontrol.customobjects.bo3.BO3Settings;
import com.khorn.terraincontrol.generator.FrozenSurfaceHelper;
import com.khorn.terraincontrol.generator.noise.NoiseGeneratorNewOctaves;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import java.util.Arrays;
import java.util.Random;

public class ObjectSpawner {
    private final ConfigProvider configProvider;
    private final Random rand;
    private final LocalWorld world;
    public boolean processing = false;

    public ObjectSpawner(ConfigProvider configProvider, LocalWorld localWorld) {
        this.configProvider = configProvider;
        this.rand = new Random();
        this.world = localWorld;
        new NoiseGeneratorNewOctaves(new Random(this.world.getSeed()), 4);
    }

    public void populate(ChunkCoordinate chunkCoord) {
        if (!this.processing) {
            int z;
            this.processing = true;
            int x = chunkCoord.getChunkX() * 16;
            LocalBiome biome = this.world.getBiome(x + 15, (z = chunkCoord.getChunkZ() * 16) + 15);
            if (biome == null) {
                TerrainControl.log(LogMarker.WARN, "Unknown biome at {},{}  (chunk {}). Could not populate chunk.", x + 15, z + 15, chunkCoord);
                return;
            }
            BiomeConfig biomeConfig = biome.getBiomeConfig();
            WorldConfig worldConfig = this.configProvider.getWorldConfig();
            long resourcesSeed = worldConfig.resourcesSeed != 0L ? worldConfig.resourcesSeed : this.world.getSeed();
            this.rand.setSeed(resourcesSeed);
            long l1 = this.rand.nextLong() / 2L * 2L + 1L;
            long l2 = this.rand.nextLong() / 2L * 2L + 1L;
            this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
            ChunkCoordinate spawnChunk = this.world.getSpawnChunk();
            boolean hasVillage = false;
            if (spawnChunk.equals(chunkCoord) && this.world.getConfigs().getWorldConfig().BO3AtSpawn != null && this.world.getConfigs().getWorldConfig().BO3AtSpawn.trim().length() > 0) {
                CustomObject customObject = this.world.getConfigs().getCustomObjects().getObjectByName(this.world.getConfigs().getWorldConfig().BO3AtSpawn);
                if (customObject != null && customObject instanceof BO3) {
                    int y = 1;
                    if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
                        y = this.world.getHighestBlockYAt(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter()) - 1;
                    } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
                        y = this.world.getSolidHeight(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter()) - 1;
                    } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
                        y = (int)((double)((BO3)customObject).getSettings().minHeight + Math.random() * (double)(((BO3)customObject).getSettings().maxHeight - ((BO3)customObject).getSettings().minHeight));
                    }
                    ((BO3)customObject).spawnForced(this.world, this.rand, Rotation.NORTH, spawnChunk.getBlockXCenter(), y += ((BO3)customObject).getSettings().spawnHeightOffset, spawnChunk.getBlockZCenter());
                }
            } else {
                hasVillage = this.world.placeDefaultStructures(this.rand, chunkCoord);
            }
            this.world.startPopulation(chunkCoord);
            TerrainControl.firePopulationStartEvent(this.world, this.rand, hasVillage, chunkCoord);
            for (ConfigFunction<BiomeConfig> res : biomeConfig.resourceSequence) {
                if (!(res instanceof Resource)) continue;
                ((Resource)res).process(this.world, this.rand, hasVillage, chunkCoord);
            }
            this.world.placePopulationMobs(biome, this.rand, chunkCoord);
            new FrozenSurfaceHelper(this.world).freezeChunk(chunkCoord);
            this.world.replaceBlocks(chunkCoord);
            TerrainControl.firePopulationEndEvent(this.world, this.rand, hasVillage, chunkCoord);
            this.world.endPopulation();
            this.processing = false;
        } else {
            TerrainControl.log(LogMarker.TRACE, "Error, minecraft engine attempted to populate two chunks at once! Chunk X" + chunkCoord.getChunkX() + " Z" + chunkCoord.getChunkZ() + ". This is probably caused by a mod spawning blocks in unloaded chunks and can cause lag as well as missing trees, ores and other OTG resources. Please try to find out which mod causes this, disable the feature causing it and alert the mod creator. Set the log level to Trace in mods/OpenTerrainGenerator/TerranControl.ini file for a stack trace. (Update: The recently added multi-dimension features may be causing this log message occasionally, will fix a.s.a.p).", new Object[0]);
            TerrainControl.log(LogMarker.TRACE, Arrays.toString(Thread.currentThread().getStackTrace()), new Object[0]);
        }
    }
}

