/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.util;

import com.khorn.terraincontrol.forge.TXWorldType;
import com.khorn.terraincontrol.forge.generator.TXBiome;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;

public abstract class WorldHelper {
    public static boolean isVanillaWorld(World world) {
        int dimensionId = world.field_73011_w.getDimension();
        return dimensionId == 0 || dimensionId == 1 || dimensionId == -1;
    }

    public static int getGenerationId(Biome biomeBase) {
        if (biomeBase instanceof TXBiome) {
            return ((TXBiome)biomeBase).generationId;
        }
        return Biome.func_185362_a((Biome)biomeBase);
    }

    public static String getName(World world) {
        if (world.func_72912_H().func_76067_t() instanceof TXWorldType && world.field_73011_w.getDimension() > 1) {
            return DimensionManager.getProviderType((int)world.field_73011_w.getDimension()).func_186065_b();
        }
        WorldServer defaultWorld = DimensionManager.getWorld((int)0);
        if (WorldHelper.isVanillaWorld(world) || defaultWorld != null && world.func_72912_H() != null && world.func_72860_G() != defaultWorld.func_72860_G()) {
            return world.func_72912_H().func_76065_j();
        }
        return world.field_73011_w.getSaveFolder();
    }

    private WorldHelper() {
    }
}

