/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.gui;

import com.khorn.terraincontrol.forge.gui.TXGuiListWorldSelection;
import com.khorn.terraincontrol.forge.gui.TXGuiWorldSelection;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.GuiWorldEdit;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiOldSaveLoadConfirm;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class TXGuiListWorldSelectionEntry
implements GuiListExtended.IGuiListEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/world_selection.png");
    private final Minecraft client;
    private final TXGuiWorldSelection worldSelScreen;
    private final WorldSummary worldSummary;
    private final ResourceLocation iconLocation;
    private final TXGuiListWorldSelection containingListSel;
    private File iconFile;
    private DynamicTexture icon;
    private long lastClickTime;

    public String getSelectedWorldName() {
        return this.worldSummary != null ? this.worldSummary.func_75786_a() : null;
    }

    public TXGuiListWorldSelectionEntry(TXGuiListWorldSelection listWorldSelIn, WorldSummary p_i46591_2_, ISaveFormat p_i46591_3_) {
        this.containingListSel = listWorldSelIn;
        this.worldSelScreen = listWorldSelIn.getGuiWorldSelection();
        this.worldSummary = p_i46591_2_;
        this.client = Minecraft.func_71410_x();
        this.iconLocation = new ResourceLocation("worlds/" + p_i46591_2_.func_75786_a() + "/icon");
        this.iconFile = p_i46591_3_.func_186352_b(p_i46591_2_.func_75786_a(), "icon.png");
        if (!this.iconFile.isFile()) {
            this.iconFile = null;
        }
        this.loadServerIcon();
    }

    public void func_180790_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
        String s = this.worldSummary.func_75788_b();
        String s1 = this.worldSummary.func_75786_a() + " (" + DATE_FORMAT.format(new Date(this.worldSummary.func_75784_e())) + ")";
        String s2 = "";
        if (StringUtils.isEmpty((CharSequence)s)) {
            s = I18n.func_135052_a((String)"selectWorld.world", (Object[])new Object[0]) + " " + (slotIndex + 1);
        }
        if (this.worldSummary.func_75785_d()) {
            s2 = I18n.func_135052_a((String)"selectWorld.conversion", (Object[])new Object[0]) + " " + s2;
        } else {
            s2 = I18n.func_135052_a((String)("gameMode." + this.worldSummary.func_75790_f().func_77149_b()), (Object[])new Object[0]);
            if (this.worldSummary.func_75789_g()) {
                s2 = TextFormatting.DARK_RED + I18n.func_135052_a((String)"gameMode.hardcore", (Object[])new Object[0]) + TextFormatting.RESET;
            }
            if (this.worldSummary.func_75783_h()) {
                s2 = s2 + ", " + I18n.func_135052_a((String)"selectWorld.cheats", (Object[])new Object[0]);
            }
            String s3 = this.worldSummary.func_186357_i();
            s2 = this.worldSummary.func_186355_l() ? (this.worldSummary.func_186356_m() ? s2 + ", " + I18n.func_135052_a((String)"selectWorld.version", (Object[])new Object[0]) + " " + TextFormatting.RED + s3 + TextFormatting.RESET : s2 + ", " + I18n.func_135052_a((String)"selectWorld.version", (Object[])new Object[0]) + " " + TextFormatting.ITALIC + s3 + TextFormatting.RESET) : s2 + ", " + I18n.func_135052_a((String)"selectWorld.version", (Object[])new Object[0]) + " " + s3;
        }
        this.client.field_71466_p.func_78276_b(s, x + 32 + 3, y + 1, 0xFFFFFF);
        this.client.field_71466_p.func_78276_b(s1, x + 32 + 3, y + this.client.field_71466_p.field_78288_b + 3, 0x808080);
        this.client.field_71466_p.func_78276_b(s2, x + 32 + 3, y + this.client.field_71466_p.field_78288_b + this.client.field_71466_p.field_78288_b + 3, 0x808080);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.client.func_110434_K().func_110577_a(this.icon != null ? this.iconLocation : ICON_MISSING);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        GlStateManager.func_179084_k();
        if (this.client.field_71474_y.field_85185_A || isSelected) {
            int i;
            this.client.func_110434_K().func_110577_a(ICON_OVERLAY_LOCATION);
            Gui.func_73734_a((int)x, (int)y, (int)(x + 32), (int)(y + 32), (int)-1601138544);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int j = mouseX - x;
            int n = i = j < 32 ? 32 : 0;
            if (this.worldSummary.func_186355_l()) {
                Gui.func_146110_a((int)x, (int)y, (float)32.0f, (float)i, (int)32, (int)32, (float)256.0f, (float)256.0f);
                if (this.worldSummary.func_186356_m()) {
                    Gui.func_146110_a((int)x, (int)y, (float)96.0f, (float)i, (int)32, (int)32, (float)256.0f, (float)256.0f);
                    if (j < 32) {
                        this.worldSelScreen.setVersionTooltip(TextFormatting.RED + I18n.func_135052_a((String)"selectWorld.tooltip.fromNewerVersion1", (Object[])new Object[0]) + "\n" + TextFormatting.RED + I18n.func_135052_a((String)"selectWorld.tooltip.fromNewerVersion2", (Object[])new Object[0]));
                    }
                } else {
                    Gui.func_146110_a((int)x, (int)y, (float)64.0f, (float)i, (int)32, (int)32, (float)256.0f, (float)256.0f);
                    if (j < 32) {
                        this.worldSelScreen.setVersionTooltip(TextFormatting.GOLD + I18n.func_135052_a((String)"selectWorld.tooltip.snapshot1", (Object[])new Object[0]) + "\n" + TextFormatting.GOLD + I18n.func_135052_a((String)"selectWorld.tooltip.snapshot2", (Object[])new Object[0]));
                    }
                }
            } else {
                Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)i, (int)32, (int)32, (float)256.0f, (float)256.0f);
            }
        }
    }

    public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        this.containingListSel.selectWorld(slotIndex);
        if (relativeX <= 32 && relativeX < 32) {
            this.joinWorld();
            return true;
        }
        if (Minecraft.func_71386_F() - this.lastClickTime < 250L) {
            this.joinWorld();
            return true;
        }
        this.lastClickTime = Minecraft.func_71386_F();
        return false;
    }

    public void joinWorld() {
        if (this.worldSummary.func_186356_m()) {
            this.client.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                public void func_73878_a(boolean result, int id) {
                    if (result) {
                        TXGuiListWorldSelectionEntry.this.loadWorld();
                    } else {
                        TXGuiListWorldSelectionEntry.this.client.func_147108_a((GuiScreen)TXGuiListWorldSelectionEntry.this.worldSelScreen);
                    }
                }
            }, I18n.func_135052_a((String)"selectWorld.versionQuestion", (Object[])new Object[0]), I18n.func_135052_a((String)"selectWorld.versionWarning", (Object[])new Object[]{this.worldSummary.func_186357_i()}), I18n.func_135052_a((String)"selectWorld.versionJoinButton", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), 0));
        } else {
            this.loadWorld();
        }
    }

    public void deleteWorld() {
        this.client.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

            public void func_73878_a(boolean result, int id) {
                if (result) {
                    TXGuiListWorldSelectionEntry.this.client.func_147108_a((GuiScreen)new GuiScreenWorking());
                    ISaveFormat isaveformat = TXGuiListWorldSelectionEntry.this.client.func_71359_d();
                    isaveformat.func_75800_d();
                    isaveformat.func_75802_e(TXGuiListWorldSelectionEntry.this.worldSummary.func_75786_a());
                    TXGuiListWorldSelectionEntry.this.containingListSel.refreshList();
                }
                TXGuiListWorldSelectionEntry.this.client.func_147108_a((GuiScreen)TXGuiListWorldSelectionEntry.this.worldSelScreen);
            }
        }, I18n.func_135052_a((String)"selectWorld.deleteQuestion", (Object[])new Object[0]), "'" + this.worldSummary.func_75788_b() + "' " + I18n.func_135052_a((String)"selectWorld.deleteWarning", (Object[])new Object[0]), I18n.func_135052_a((String)"selectWorld.deleteButton", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), 0));
    }

    public void editWorld() {
        this.client.func_147108_a((GuiScreen)new GuiWorldEdit((GuiScreen)this.worldSelScreen, this.worldSummary.func_75786_a()));
    }

    public void recreateWorld() {
        this.client.func_147108_a((GuiScreen)new GuiScreenWorking());
        GuiCreateWorld guicreateworld = new GuiCreateWorld((GuiScreen)this.worldSelScreen);
        ISaveHandler isavehandler = this.client.func_71359_d().func_75804_a(this.worldSummary.func_75786_a(), false);
        WorldInfo worldinfo = isavehandler.func_75757_d();
        isavehandler.func_75759_a();
        guicreateworld.func_146318_a(worldinfo);
        this.client.func_147108_a((GuiScreen)guicreateworld);
    }

    private void loadWorld() {
        this.client.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        if (this.client.func_71359_d().func_90033_f(this.worldSummary.func_75786_a())) {
            this.tryLoadExistingWorld(FMLClientHandler.instance(), this.worldSelScreen, this.worldSummary);
        }
    }

    public void tryLoadExistingWorld(FMLClientHandler clientHandler, TXGuiWorldSelection selectWorldGUI, WorldSummary comparator) {
        NBTTagCompound leveldat;
        File dir = new File(clientHandler.getSavesDir(), comparator.func_75786_a());
        try {
            leveldat = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(new File(dir, "level.dat")));
        }
        catch (Exception e) {
            try {
                leveldat = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(new File(dir, "level.dat_old")));
            }
            catch (Exception e1) {
                FMLLog.warning((String)"There appears to be a problem loading the save %s, both level files are unreadable.", (Object[])new Object[]{comparator.func_75786_a()});
                return;
            }
        }
        NBTTagCompound fmlData = leveldat.func_74775_l("FML");
        if (fmlData.func_74764_b("ModItemData")) {
            clientHandler.showGuiScreen((Object)new GuiOldSaveLoadConfirm(comparator.func_75786_a(), comparator.func_75788_b(), (GuiScreen)selectWorldGUI));
        } else {
            try {
                clientHandler.getClient().func_71371_a(comparator.func_75786_a(), comparator.func_75788_b(), null);
            }
            catch (StartupQuery.AbortedException abortedException) {
                // empty catch block
            }
        }
    }

    private void loadServerIcon() {
        boolean flag;
        boolean bl = flag = this.iconFile != null && this.iconFile.isFile();
        if (flag) {
            BufferedImage bufferedimage;
            try {
                bufferedimage = ImageIO.read(this.iconFile);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                LOGGER.error("Invalid icon for world {}", new Object[]{this.worldSummary.func_75786_a(), throwable});
                this.iconFile = null;
                return;
            }
            if (this.icon == null) {
                this.icon = new DynamicTexture(bufferedimage.getWidth(), bufferedimage.getHeight());
                this.client.func_110434_K().func_110579_a(this.iconLocation, (ITextureObject)this.icon);
            }
            bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), this.icon.func_110565_c(), 0, bufferedimage.getWidth());
            this.icon.func_110564_a();
        } else if (!flag) {
            this.client.func_110434_K().func_147645_c(this.iconLocation);
            this.icon = null;
        }
    }

    public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
    }

    public void func_178011_a(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
    }
}

