/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator.structure;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ServerConfigProvider;
import com.khorn.terraincontrol.forge.ForgeBiome;
import com.khorn.terraincontrol.forge.generator.structure.TXVillageStart;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;

public class TXVillageGen
extends MapGenStructure {
    public List<Biome> villageSpawnBiomes;
    private int size;
    private int distance;
    private int minimumDistance;

    public TXVillageGen(ServerConfigProvider configs) {
        this.size = configs.getWorldConfig().villageSize;
        this.distance = configs.getWorldConfig().villageDistance;
        this.minimumDistance = 8;
        this.villageSpawnBiomes = new ArrayList<Biome>();
        for (LocalBiome biome : configs.getBiomeArray()) {
            if (biome == null || biome.getBiomeConfig().villageType == BiomeConfig.VillageType.disabled) continue;
            this.villageSpawnBiomes.add(((ForgeBiome)biome).getHandle());
        }
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean canSpawn;
        int var3 = chunkX;
        int var4 = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int var5 = chunkX / this.distance;
        int var6 = chunkZ / this.distance;
        Random var7 = this.field_75039_c.func_72843_D(var5, var6, 10387312);
        var5 *= this.distance;
        var6 *= this.distance;
        return var3 == (var5 += var7.nextInt(this.distance - this.minimumDistance)) && var4 == (var6 += var7.nextInt(this.distance - this.minimumDistance)) && (canSpawn = this.field_75039_c.func_72959_q().func_76940_a(var3 * 16 + 8, var4 * 16 + 8, 0, this.villageSpawnBiomes));
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new TXVillageStart(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.size);
    }

    public String func_143025_a() {
        return "OTGVillage";
    }
}

