/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeMaterialData;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.generator.Cartographer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TXTeleporter {
    public static Entity changeDimension(int dimensionIn, Entity _this) {
        if (!_this.field_70170_p.field_72995_K && !_this.field_70128_L) {
            if (!ForgeHooks.onTravelToDimension((Entity)_this, (int)dimensionIn)) {
                return null;
            }
            _this.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer minecraftserver = _this.func_184102_h();
            int i = _this.field_71093_bK;
            WorldServer worldserver = minecraftserver.func_71218_a(i);
            WorldServer worldserver1 = minecraftserver.func_71218_a(dimensionIn);
            _this.field_71093_bK = dimensionIn;
            if (i == 1 && dimensionIn == 1) {
                worldserver1 = minecraftserver.func_71218_a(0);
                _this.field_71093_bK = 0;
            }
            _this.field_70170_p.func_72900_e(_this);
            _this.field_70128_L = false;
            _this.field_70170_p.field_72984_F.func_76320_a("reposition");
            worldserver.func_72866_a(_this, false);
            _this.field_70170_p.field_72984_F.func_76318_c("reloading");
            Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)_this), (World)worldserver1);
            if (entity != null) {
                TXTeleporter.copyDataFromOld(_this, entity);
                boolean flag = entity.field_98038_p;
                entity.field_98038_p = true;
                LocalWorld forgeWorld = ((ForgeEngine)TerrainControl.getEngine()).getWorld((World)DimensionManager.getWorld((int)i));
                ArrayList<LocalMaterialData> portalMaterials = forgeWorld.getConfigs().getWorldConfig().DimensionPortalMaterials;
                TXTeleporter.placeInPortal((ForgeMaterialData)portalMaterials.get(0), worldserver1, entity, entity.field_70177_z, worldserver1.func_85176_s());
                worldserver1.func_72838_d(entity);
                entity.field_98038_p = flag;
                worldserver1.func_72866_a(entity, false);
            }
            _this.field_70128_L = true;
            _this.field_70170_p.field_72984_F.func_76319_b();
            worldserver.func_82742_i();
            worldserver1.func_82742_i();
            _this.field_70170_p.field_72984_F.func_76319_b();
            return entity;
        }
        return null;
    }

    private static void copyDataFromOld(Entity entityIn, Entity _this) {
        NBTTagCompound nbttagcompound = entityIn.func_189511_e(new NBTTagCompound());
        nbttagcompound.func_82580_o("Dimension");
        _this.func_70020_e(nbttagcompound);
        _this.field_71088_bW = entityIn.field_71088_bW;
    }

    public static Entity changeDimension(int dimensionIn, EntityPlayerMP _this) {
        return TXTeleporter.changeDimension(dimensionIn, _this, true);
    }

    public static Entity changeDimension(int dimensionIn, EntityPlayerMP _this, boolean createPortal) {
        ForgeWorld forgeWorld = ((ForgeEngine)TerrainControl.getEngine()).getWorldByDimId(dimensionIn);
        if (forgeWorld == null) {
            DimensionManager.initDimension((int)dimensionIn);
            forgeWorld = ((ForgeEngine)TerrainControl.getEngine()).getWorldByDimId(dimensionIn);
        }
        if (forgeWorld == null) {
            throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
        }
        if (forgeWorld.getConfigs().getWorldConfig().teleportToSpawnOnly) {
            BlockPos forgeWorldSpawnPoint = forgeWorld.getSpawnPoint();
            _this.func_70012_b((double)forgeWorldSpawnPoint.func_177958_n(), 256.0, (double)forgeWorldSpawnPoint.func_177952_p(), 0.0f, 0.0f);
        }
        if (!ForgeHooks.onTravelToDimension((Entity)_this, (int)dimensionIn)) {
            return _this;
        }
        if (((ForgeEngine)TerrainControl.getEngine()).getCartographerEnabled() && dimensionIn == Cartographer.CartographerDimension) {
            _this.field_71075_bZ.field_75099_e = false;
            _this.field_71075_bZ.field_75101_c = true;
            _this.func_71016_p();
        } else {
            _this.field_71075_bZ.field_75099_e = true;
            _this.field_71075_bZ.field_75101_c = _this.field_71075_bZ.field_75098_d;
            _this.func_71016_p();
        }
        TXTeleporter.changePlayerDimension(_this, dimensionIn, _this.field_71133_b.func_184103_al(), createPortal);
        _this.field_71135_a.func_147359_a((Packet)new SPacketEffect(1032, BlockPos.field_177992_a, 0, false));
        return _this;
    }

    public static void changePlayerDimension(EntityPlayerMP player, int dimensionIn, PlayerList _this, boolean createPortal) {
        TXTeleporter.transferPlayerToDimension(player, dimensionIn, _this.func_72365_p().func_71218_a(dimensionIn).func_85176_s(), _this, createPortal);
    }

    public static void transferPlayerToDimension(EntityPlayerMP player, int dimensionIn, Teleporter teleporter, PlayerList _this, boolean createPortal) {
        int i = player.field_71093_bK;
        WorldServer worldserver = _this.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimensionIn;
        WorldServer worldserver1 = _this.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, worldserver1.func_175659_aa(), worldserver1.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        _this.func_187243_f(player);
        worldserver.func_72973_f((Entity)player);
        player.field_70128_L = false;
        TXTeleporter.transferEntityToWorld((Entity)player, i, worldserver, worldserver1, teleporter, createPortal);
        _this.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        _this.func_72354_b(player, worldserver1);
        _this.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, i, dimensionIn);
    }

    public static void transferEntityToWorld(Entity entityIn, int lastDimension, WorldServer oldWorldIn, WorldServer toWorldIn, Teleporter teleporter, boolean createPortal) {
        double entityPosY = entityIn.func_180425_c().func_177956_o();
        WorldProvider pOld = oldWorldIn.field_73011_w;
        WorldProvider pNew = toWorldIn.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double d0 = entityIn.field_70165_t * moveFactor;
        double d1 = entityIn.field_70161_v * moveFactor;
        float f = entityIn.field_70177_z;
        oldWorldIn.field_72984_F.func_76320_a("moving");
        oldWorldIn.field_72984_F.func_76319_b();
        if (lastDimension != 1) {
            oldWorldIn.field_72984_F.func_76320_a("placing");
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            if (entityIn.func_70089_S()) {
                entityIn.func_70012_b(d0, (double)entityIn.func_180425_c().func_177956_o(), d1, entityIn.field_70177_z, entityIn.field_70125_A);
                if (!((ForgeEngine)TerrainControl.getEngine()).getCartographerEnabled() || entityIn.field_71093_bK != Cartographer.CartographerDimension && lastDimension != Cartographer.CartographerDimension) {
                    LocalWorld forgeWorld = ((ForgeEngine)TerrainControl.getEngine()).getWorld((World)DimensionManager.getWorld((int)lastDimension));
                    ArrayList<LocalMaterialData> portalMaterials = forgeWorld.getConfigs().getWorldConfig().DimensionPortalMaterials;
                    if (createPortal) {
                        TXTeleporter.placeInPortal((ForgeMaterialData)portalMaterials.get(0), toWorldIn, entityIn, f, teleporter);
                    } else if (entityPosY < 0.0) {
                        toWorldIn.func_175698_g(new BlockPos(d0, 254.0, d1));
                        toWorldIn.func_175698_g(new BlockPos(d0, 255.0, d1));
                        entityIn.func_70012_b(d0 + 0.5, 255.0, d1 + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
                        ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a(d0 + 0.5, 254.0, d1 + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
                    } else if (entityPosY > 255.0) {
                        toWorldIn.func_175656_a(new BlockPos(d0, 0.0, d1), Blocks.field_150349_c.func_176223_P());
                        toWorldIn.func_175698_g(new BlockPos(d0, 1.0, d1));
                        toWorldIn.func_175698_g(new BlockPos(d0, 2.0, d1));
                        entityIn.func_70012_b(d0 + 0.5, 1.0, d1 + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
                        ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a(d0 + 0.5, 1.0, d1 + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
                    } else {
                        return;
                    }
                }
                toWorldIn.func_72838_d(entityIn);
                toWorldIn.func_72866_a(entityIn, false);
            }
            oldWorldIn.field_72984_F.func_76319_b();
        }
        entityIn.func_70029_a((World)toWorldIn);
    }

    private static Long2ObjectMap<Teleporter.PortalPosition> getPortals(int dimensionId) {
        Long2ObjectMap destinationCoordinateCache = null;
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer worldserver1 = mcServer.func_71218_a(dimensionId);
        try {
            Field[] fields;
            for (Field field : fields = worldserver1.func_85176_s().getClass().getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(Long2ObjectMap.class)) continue;
                field.setAccessible(true);
                destinationCoordinateCache = (Long2ObjectMap)field.get(worldserver1.func_85176_s());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return destinationCoordinateCache;
    }

    public static boolean placeInExistingPortal(WorldServer destinationWorld, Entity entityIn, float rotationYaw, Teleporter _this) {
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        boolean flag = true;
        BlockPos blockpos = BlockPos.field_177992_a;
        long l = ChunkPos.func_77272_a((int)j, (int)k);
        Long2ObjectMap<Teleporter.PortalPosition> destinationCoordinateCache = TXTeleporter.getPortals(destinationWorld.field_73011_w.getDimension());
        if (destinationCoordinateCache.containsKey(l)) {
            Teleporter.PortalPosition teleporter$portalposition = (Teleporter.PortalPosition)destinationCoordinateCache.get(l);
            d0 = 0.0;
            blockpos = teleporter$portalposition;
            teleporter$portalposition.field_85087_d = destinationWorld.func_82737_E();
            flag = false;
        } else {
            BlockPos blockpos3 = new BlockPos(entityIn);
            for (int i1 = -128; i1 <= 128; ++i1) {
                for (int j1 = -128; j1 <= 128; ++j1) {
                    BlockPos blockpos1 = blockpos3.func_177982_a(i1, destinationWorld.func_72940_L() - 1 - blockpos3.func_177956_o(), j1);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (destinationWorld.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150427_aO) {
                            blockpos2 = blockpos1.func_177977_b();
                            while (destinationWorld.func_180495_p(blockpos2).func_177230_c() == Blocks.field_150427_aO) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.func_177977_b();
                            }
                            double d1 = blockpos1.func_177951_i((Vec3i)blockpos3);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (d0 >= 0.0) {
            if (flag) {
                Teleporter teleporter = _this;
                teleporter.getClass();
                destinationCoordinateCache.put(l, (Object)new Teleporter.PortalPosition(teleporter, blockpos, destinationWorld.func_82737_E()));
            }
            double d5 = (double)blockpos.func_177958_n() + 0.5;
            double d7 = (double)blockpos.func_177952_p() + 0.5;
            BlockPattern.PatternHelper blockpattern$patternhelper = Blocks.field_150427_aO.func_181089_f((World)destinationWorld, blockpos);
            boolean flag1 = blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
            double d2 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
            double xCoord = entityIn.func_181014_aG() == null ? 0.0 : entityIn.func_181014_aG().field_72450_a;
            double yCoord = entityIn.func_181014_aG() == null ? 2.0 : entityIn.func_181014_aG().field_72448_b;
            double d6 = (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() + 1) - yCoord * (double)blockpattern$patternhelper.func_181119_e();
            if (flag1) {
                d2 += 1.0;
            }
            if (blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
                d7 = d2 + (1.0 - xCoord) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
            } else {
                d5 = d2 + (1.0 - xCoord) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
            }
            entityIn.field_70159_w = 0.0;
            entityIn.field_70179_y = 0.0;
            entityIn.field_70177_z = 0.0f;
            if (entityIn instanceof EntityPlayerMP) {
                int radius = 2;
                boolean invertX = Math.random() > 0.5;
                boolean invertY = Math.random() > 0.5;
                boolean invertZ = Math.random() > 0.5;
                for (int x = -radius; x <= radius; ++x) {
                    int randomX = invertX ? -x : x;
                    for (int y = -radius; y <= radius; ++y) {
                        int randomY = invertY ? -y : y;
                        for (int z = -radius; z <= radius; ++z) {
                            int randomZ = invertZ ? -z : z;
                            BlockPos blockPos1 = new BlockPos(d5 + (double)randomX, d6 + (double)randomY, d7 + (double)randomZ);
                            BlockPos blockPos2 = new BlockPos(d5 + (double)randomX, d6 + (double)randomY + 1.0, d7 + (double)randomZ);
                            BlockPos blockPos3 = new BlockPos(d5 + (double)randomX, d6 + (double)randomY + 2.0, d7 + (double)randomZ);
                            IBlockState blockState1 = destinationWorld.func_180495_p(blockPos1);
                            IBlockState blockState2 = destinationWorld.func_180495_p(blockPos2);
                            IBlockState blockState3 = destinationWorld.func_180495_p(blockPos3);
                            if (!blockState1.func_185904_a().func_76230_c() || blockState2.func_185904_a().func_76230_c() || blockState3.func_185904_a().func_76230_c() || blockState2.func_185904_a().func_76224_d() || blockState3.func_185904_a().func_76224_d() || blockState2.func_177230_c() == Blocks.field_150480_ab || blockState3.func_177230_c() == Blocks.field_150480_ab || blockState2.func_177230_c() == Blocks.field_150427_aO || blockState3.func_177230_c() == Blocks.field_150427_aO) continue;
                            ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a((double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o(), (double)blockPos2.func_177952_p() + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
                            return true;
                        }
                    }
                }
                destinationWorld.func_175685_c(new BlockPos(d5, d6 + 1.0, d7), destinationWorld.func_180495_p(new BlockPos(d5, d6 + 1.0, d7)).func_177230_c());
                ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a(d5, d6 + 1.0, d7, entityIn.field_70177_z, entityIn.field_70125_A);
            } else {
                int radius = 2;
                boolean invertX = Math.random() > 0.5;
                boolean invertY = Math.random() > 0.5;
                boolean invertZ = Math.random() > 0.5;
                for (int x = -radius; x <= radius; ++x) {
                    int randomX = invertX ? -x : x;
                    for (int y = -radius; y <= radius; ++y) {
                        int randomY = invertY ? -y : y;
                        for (int z = -radius; z <= radius; ++z) {
                            int randomZ = invertZ ? -z : z;
                            BlockPos blockPos1 = new BlockPos(d5 + (double)randomX, d6 + (double)randomY, d7 + (double)randomZ);
                            BlockPos blockPos2 = new BlockPos(d5 + (double)randomX, d6 + (double)randomY + 1.0, d7 + (double)randomZ);
                            BlockPos blockPos3 = new BlockPos(d5 + (double)randomX, d6 + (double)randomY + 2.0, d7 + (double)randomZ);
                            IBlockState blockState1 = destinationWorld.func_180495_p(blockPos1);
                            IBlockState blockState2 = destinationWorld.func_180495_p(blockPos2);
                            IBlockState blockState3 = destinationWorld.func_180495_p(blockPos3);
                            if (!blockState1.func_185904_a().func_76230_c() || blockState2.func_185904_a().func_76230_c() || blockState3.func_185904_a().func_76230_c() || blockState2.func_185904_a().func_76224_d() || blockState3.func_185904_a().func_76224_d() || blockState2.func_177230_c() == Blocks.field_150480_ab || blockState3.func_177230_c() == Blocks.field_150480_ab || blockState2.func_177230_c() == Blocks.field_150427_aO || blockState3.func_177230_c() == Blocks.field_150427_aO) continue;
                            entityIn.func_70012_b((double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o(), (double)blockPos2.func_177952_p() + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
                            return true;
                        }
                    }
                }
                destinationWorld.func_175685_c(new BlockPos(d5, d6 + 1.0, d7), destinationWorld.func_180495_p(new BlockPos(d5, d6 + 1.0, d7)).func_177230_c());
                entityIn.func_70012_b(d5, d6 + 1.0, d7, entityIn.field_70177_z, entityIn.field_70125_A);
            }
            return true;
        }
        return false;
    }

    public static void placeInPortal(ForgeMaterialData portalMaterial, WorldServer destinationWorld, Entity entityIn, float rotationYaw, Teleporter _this) {
        if (destinationWorld.field_73011_w.func_186058_p().func_186068_a() != 1) {
            if (!TXTeleporter.placeInExistingPortal(destinationWorld, entityIn, rotationYaw, _this)) {
                TXTeleporter.makePortal(portalMaterial, destinationWorld, entityIn, _this);
                TXTeleporter.placeInExistingPortal(destinationWorld, entityIn, rotationYaw, _this);
            }
        } else {
            throw new RuntimeException("DOH!");
        }
    }

    public static boolean makePortal(ForgeMaterialData portalMaterial, WorldServer destinationWorld, Entity entityIn, Teleporter _this) {
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int k = MathHelper.func_76128_c((double)entityIn.field_70163_u);
        int l = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        int i1 = j;
        int j1 = k;
        int k1 = l;
        int l1 = 0;
        int i2 = new Random().nextInt(4);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j2 = j - 16; j2 <= j + 16; ++j2) {
            double d1 = (double)j2 + 0.5 - entityIn.field_70165_t;
            for (int l2 = l - 16; l2 <= l + 16; ++l2) {
                double d2 = (double)l2 + 0.5 - entityIn.field_70161_v;
                block2: for (int j3 = destinationWorld.func_72940_L() - 1; j3 >= 0; --j3) {
                    if (!destinationWorld.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3, l2))) continue;
                    while (j3 > 0 && destinationWorld.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3 - 1, l2))) {
                        --j3;
                    }
                    for (int k3 = i2; k3 < i2 + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                    int j5 = j3 + l4;
                                    int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                    blockpos$mutableblockpos.func_181079_c(i5, j5, k5);
                                    if (l4 < 0 && !destinationWorld.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || l4 >= 0 && !destinationWorld.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)j3 + 0.5 - entityIn.field_70163_u;
                        double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(d0 < 0.0) && !(d7 < d0)) continue;
                        d0 = d7;
                        i1 = j2;
                        j1 = j3;
                        k1 = l2;
                        l1 = k3 % 4;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (int l5 = j - 16; l5 <= j + 16; ++l5) {
                double d3 = (double)l5 + 0.5 - entityIn.field_70165_t;
                for (int j6 = l - 16; j6 <= l + 16; ++j6) {
                    double d4 = (double)j6 + 0.5 - entityIn.field_70161_v;
                    block10: for (int i7 = destinationWorld.func_72940_L() - 1; i7 >= 0; --i7) {
                        if (!destinationWorld.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7, j6))) continue;
                        while (i7 > 0 && destinationWorld.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7 - 1, j6))) {
                            --i7;
                        }
                        for (int k7 = i2; k7 < i2 + 2; ++k7) {
                            int j8 = k7 % 2;
                            int j9 = 1 - j8;
                            for (int j10 = 0; j10 < 4; ++j10) {
                                for (int j11 = -1; j11 < 4; ++j11) {
                                    int j12 = l5 + (j10 - 1) * j8;
                                    int i13 = i7 + j11;
                                    int j13 = j6 + (j10 - 1) * j9;
                                    blockpos$mutableblockpos.func_181079_c(j12, i13, j13);
                                    if (j11 < 0 && !destinationWorld.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || j11 >= 0 && !destinationWorld.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block10;
                                }
                            }
                            double d6 = (double)i7 + 0.5 - entityIn.field_70163_u;
                            double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(d0 < 0.0) && !(d8 < d0)) continue;
                            d0 = d8;
                            i1 = l5;
                            j1 = i7;
                            k1 = j6;
                            l1 = k7 % 2;
                        }
                    }
                }
            }
        }
        int i6 = i1;
        int k2 = j1;
        int k6 = k1;
        int l6 = l1 % 2;
        int i3 = 1 - l6;
        if (l1 % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (d0 < 0.0) {
            k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(destinationWorld.func_72940_L() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int l7 = 1; l7 < 3; ++l7) {
                    for (int k8 = -1; k8 < 3; ++k8) {
                        int k9 = i6 + (l7 - 1) * l6 + j7 * i3;
                        int k10 = k2 + k8;
                        int k11 = k6 + (l7 - 1) * i3 - j7 * l6;
                        boolean flag = k8 < 0;
                        destinationWorld.func_175656_a(new BlockPos(k9, k10, k11), flag ? portalMaterial.internalBlock() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        IBlockState iblockstate = Blocks.field_150427_aO.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)(l6 == 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
        for (int i8 = 0; i8 < 4; ++i8) {
            for (int l8 = 0; l8 < 4; ++l8) {
                for (int l9 = -1; l9 < 4; ++l9) {
                    int l10 = i6 + (l8 - 1) * l6;
                    int l11 = k2 + l9;
                    int k12 = k6 + (l8 - 1) * i3;
                    boolean flag1 = l8 == 0 || l8 == 3 || l9 == -1 || l9 == 3;
                    destinationWorld.func_180501_a(new BlockPos(l10, l11, k12), flag1 ? portalMaterial.internalBlock() : iblockstate, 2);
                }
            }
        }
        return true;
    }
}

