/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator;

import com.google.common.base.Strings;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.TXWorldType;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Pregenerator {
    private int pregenerationRadius;
    boolean preGeneratorIsRunning;
    boolean processing = false;
    int radius = 0;
    int currentX;
    int currentZ;
    long startTime;
    int spawned = 1;
    double total;
    int left = 0;
    int right = 0;
    int top = 0;
    int bottom = 0;
    int cycle = 0;
    int iLeft = Integer.MIN_VALUE;
    int iRight = Integer.MIN_VALUE;
    int iTop = Integer.MIN_VALUE;
    int iBottom = Integer.MIN_VALUE;
    int lastWorldHash = 0;
    int spawnedThisTick = 0;
    String pregenerationWorld = "";
    String preGeneratorProgressStatus = "";
    String preGeneratorProgress = "";
    String progressScreenElapsedTime = "";
    String progressScreenEstimatedTime = "";
    int progressScreenWorldSizeInBlocks;
    static long lastMessage = System.currentTimeMillis();
    public boolean menuOpen = true;

    public int getPregenerationRadius() {
        return this.pregenerationRadius;
    }

    public int setPregenerationRadius(int radius) {
        return this.setPregenerationRadius(radius, null);
    }

    public int setPregenerationRadius(int radius, World world) {
        if (this.pregenerationRadius == 0) {
            this.resetPregenerator();
        }
        this.pregenerationRadius = !this.preGeneratorIsRunning || radius > this.cycle && radius > 0 ? radius : this.cycle;
        if (world != null) {
            this.SavePreGeneratorData(world);
        }
        return this.pregenerationRadius;
    }

    public void resetPregenerator() {
        this.left = 0;
        this.right = 0;
        this.top = 0;
        this.bottom = 0;
        this.spawned = 1;
        this.cycle = 0;
        this.iLeft = Integer.MIN_VALUE;
        this.iRight = Integer.MIN_VALUE;
        this.iTop = Integer.MIN_VALUE;
        this.iBottom = Integer.MIN_VALUE;
        this.startTime = System.currentTimeMillis();
    }

    public void ProcessTick() {
        if (!this.processing) {
            this.processing = true;
            MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            for (WorldServer worldServer : mcServer.field_71305_c) {
                if (!(worldServer.func_72912_H().func_76067_t() instanceof TXWorldType) || worldServer.field_73011_w.getDimension() != 0) continue;
                LocalWorld world = ((ForgeEngine)TerrainControl.getEngine()).getWorld((World)worldServer);
                if (world == null) {
                    this.processing = false;
                    return;
                }
                ConfigProvider configProvider = world.getConfigs();
                if (configProvider == null) {
                    this.processing = false;
                    return;
                }
                WorldConfig worldConfig = configProvider.getWorldConfig();
                if (worldConfig == null) {
                    this.processing = false;
                    return;
                }
                if (worldConfig.PreGenerationRadius > 0) {
                    this.Pregenerate(worldServer, worldConfig.PreGenerationRadius);
                    continue;
                }
                this.preGeneratorIsRunning = false;
            }
            this.processing = false;
        }
    }

    void Pregenerate(WorldServer worldServer, int pregenerationRadius) {
        if (worldServer.hashCode() != this.lastWorldHash) {
            this.LoadPreGeneratorData(worldServer);
        }
        this.lastWorldHash = worldServer.hashCode();
        this.radius = pregenerationRadius;
        this.total = (this.radius * 2 + 1) * (this.radius * 2 + 1);
        if ((double)this.spawned < this.total && this.radius > 0) {
            this.currentX = -this.radius;
            this.currentZ = -this.radius;
            this.preGeneratorIsRunning = true;
            this.pregenerationWorld = worldServer.func_72912_H().func_76065_j();
            boolean leftEdgeFound = false;
            boolean rightEdgeFound = false;
            boolean topEdgeFound = false;
            boolean bottomEdgeFound = false;
            int maxSpawnPerTick = TerrainControl.getPluginConfig().PregeneratorMaxChunksPerTick;
            this.spawnedThisTick = 0;
            BlockPos spawnPoint = worldServer.func_175694_M();
            ChunkCoordinate spawnChunk = ChunkCoordinate.fromBlockCoords(spawnPoint.func_177958_n(), spawnPoint.func_177952_p());
            int spawnChunkX = spawnChunk.getChunkX();
            int spawnChunkZ = spawnChunk.getChunkZ();
            while (!(leftEdgeFound && rightEdgeFound && topEdgeFound && bottomEdgeFound)) {
                int i;
                boolean bSpawned;
                ++this.cycle;
                if (this.right >= this.radius) {
                    rightEdgeFound = true;
                }
                if (!rightEdgeFound && this.iLeft == Integer.MIN_VALUE && this.iTop == Integer.MIN_VALUE && this.iBottom == Integer.MIN_VALUE) {
                    bSpawned = false;
                    for (i = -this.top; i <= this.bottom; ++i) {
                        this.currentX = spawnChunkX + this.cycle;
                        this.currentZ = spawnChunkZ + i;
                        if (i <= this.iRight) continue;
                        bSpawned = true;
                        this.iRight = i;
                        ++this.spawned;
                        this.PreGenerateChunk(this.currentX, this.currentZ, worldServer);
                        if (this.spawnedThisTick < maxSpawnPerTick) continue;
                        if (i == this.bottom) {
                            ++this.right;
                        }
                        this.Pause(worldServer);
                        return;
                    }
                    if (bSpawned) {
                        ++this.right;
                    }
                }
                if (this.left >= this.radius) {
                    leftEdgeFound = true;
                }
                if (!leftEdgeFound && this.iTop == Integer.MIN_VALUE && this.iBottom == Integer.MIN_VALUE) {
                    bSpawned = false;
                    for (i = -this.top; i <= this.bottom; ++i) {
                        this.currentX = spawnChunkX - this.cycle;
                        this.currentZ = spawnChunkZ + i;
                        if (i <= this.iLeft) continue;
                        bSpawned = true;
                        this.iLeft = i;
                        ++this.spawned;
                        this.PreGenerateChunk(this.currentX, this.currentZ, worldServer);
                        if (this.spawnedThisTick < maxSpawnPerTick) continue;
                        if (i == this.bottom) {
                            ++this.left;
                        }
                        this.Pause(worldServer);
                        return;
                    }
                    if (bSpawned) {
                        ++this.left;
                    }
                }
                if (this.bottom >= this.radius) {
                    bottomEdgeFound = true;
                }
                if (!bottomEdgeFound && this.iTop == Integer.MIN_VALUE) {
                    bSpawned = false;
                    for (i = -this.left; i <= this.right; ++i) {
                        this.currentX = spawnChunkX + i;
                        this.currentZ = spawnChunkZ + this.cycle;
                        if (i <= this.iBottom) continue;
                        bSpawned = true;
                        this.iBottom = i;
                        ++this.spawned;
                        this.PreGenerateChunk(this.currentX, this.currentZ, worldServer);
                        if (this.spawnedThisTick < maxSpawnPerTick) continue;
                        if (i == this.right) {
                            ++this.bottom;
                        }
                        this.Pause(worldServer);
                        return;
                    }
                    if (bSpawned) {
                        ++this.bottom;
                    }
                }
                if (this.top >= this.radius) {
                    topEdgeFound = true;
                }
                if (!topEdgeFound) {
                    bSpawned = false;
                    for (i = -this.left; i <= this.right; ++i) {
                        this.currentX = spawnChunkX + i;
                        this.currentZ = spawnChunkZ - this.cycle;
                        if (i <= this.iTop) continue;
                        bSpawned = true;
                        this.iTop = i;
                        ++this.spawned;
                        this.PreGenerateChunk(this.currentX, this.currentZ, worldServer);
                        if (this.spawnedThisTick < maxSpawnPerTick) continue;
                        if (i == this.right) {
                            ++this.top;
                        }
                        this.Pause(worldServer);
                        return;
                    }
                    if (bSpawned) {
                        ++this.top;
                    }
                }
                this.iLeft = Integer.MIN_VALUE;
                this.iBottom = Integer.MIN_VALUE;
                this.iRight = Integer.MIN_VALUE;
                this.iTop = Integer.MIN_VALUE;
            }
            this.UpdateProgressMessage(false);
            this.SavePreGeneratorData((World)worldServer);
        }
        this.preGeneratorIsRunning = false;
    }

    void Pause(WorldServer worldServer) {
        if ((double)this.spawned == this.total) {
            this.iLeft = Integer.MIN_VALUE;
            this.iBottom = Integer.MIN_VALUE;
            this.iRight = Integer.MIN_VALUE;
            this.iTop = Integer.MIN_VALUE;
            this.UpdateProgressMessage(false);
            this.SavePreGeneratorData((World)worldServer);
        } else {
            --this.cycle;
            this.processing = false;
        }
    }

    void PreGenerateChunk(int currentX, int currentZ, WorldServer worldServer) {
        this.UpdateProgressMessage(true);
        ChunkProviderServer chunkProvider = worldServer.func_72863_F();
        if (!chunkProvider.func_73149_a(currentX, currentZ) && !RegionFileCache.func_76550_a((File)worldServer.getChunkSaveLocation(), (int)currentX, (int)currentZ).chunkExists(currentX & 0x1F, currentZ & 0x1F) || !chunkProvider.func_186025_d(currentX, currentZ).func_150802_k()) {
            ++this.spawnedThisTick;
            chunkProvider.func_186025_d(currentX, currentZ).func_76601_a(true);
            chunkProvider.func_186025_d(currentX, currentZ + 1).func_76601_a(true);
            chunkProvider.func_186025_d(currentX + 1, currentZ).func_76601_a(true);
            chunkProvider.func_186025_d(currentX + 1, currentZ + 1).func_76601_a(true);
        }
    }

    void UpdateProgressMessage(boolean loggingCanBeIgnored) {
        boolean dontLog = false;
        loggingCanBeIgnored = System.currentTimeMillis() - lastMessage < 1000L;
        if (loggingCanBeIgnored) {
            dontLog = true;
        } else {
            lastMessage = System.currentTimeMillis();
        }
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        int hours = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0 / 60.0);
        int minutes = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0) - hours * 60;
        int seconds = (int)Math.floor((double)elapsedTime / 1000.0) - minutes * 60 - hours * 60 * 60;
        String sElapsedTime = (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
        double eTA = this.total / (double)this.spawned * (double)elapsedTime - (double)elapsedTime;
        hours = (int)Math.floor(eTA / 1000.0 / 60.0 / 60.0);
        minutes = (int)Math.floor(eTA / 1000.0 / 60.0) - hours * 60;
        seconds = (int)Math.floor(eTA / 1000.0) - minutes * 60 - hours * 60 * 60;
        String estimatedTime = (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
        if ((double)this.spawned < this.total) {
            long i = Runtime.getRuntime().maxMemory();
            long j = Runtime.getRuntime().totalMemory();
            long k = Runtime.getRuntime().freeMemory();
            long l = j - k;
            String memoryUsage = " Mem: " + Long.valueOf(l * 100L / i) + "% " + Long.valueOf(this.BytesToMb(l)) + " / " + Long.valueOf(this.BytesToMb(i)) + " MB ";
            this.progressScreenWorldSizeInBlocks = (this.radius * 2 + 1) * 16;
            this.preGeneratorProgressStatus = this.spawned + "/" + (int)this.total;
            this.preGeneratorProgress = (int)Math.round((double)this.spawned / this.total * 100.0) + "";
            this.progressScreenElapsedTime = sElapsedTime;
            this.progressScreenEstimatedTime = estimatedTime;
            if (!dontLog) {
                TerrainControl.log(LogMarker.INFO, "Pre-generating chunk X" + this.currentX + " Z" + this.currentZ + ". Radius: " + this.radius + " Spawned: " + this.spawned + "/" + (int)this.total + " " + (int)Math.round((double)this.spawned / this.total * 100.0) + "% done. Elapsed: " + sElapsedTime + " ETA: " + estimatedTime + memoryUsage, new Object[0]);
            }
        } else {
            this.preGeneratorProgressStatus = "Done";
            this.preGeneratorProgress = "";
            this.progressScreenElapsedTime = "";
            this.progressScreenEstimatedTime = "";
            this.progressScreenWorldSizeInBlocks = 0;
            if (!dontLog) {
                TerrainControl.log(LogMarker.INFO, "Pre-generating chunks done for world " + this.pregenerationWorld + ", " + this.spawned + " chunks spawned in " + sElapsedTime, new Object[0]);
            }
        }
    }

    public void ShowInGameUI() {
        if (this.menuOpen) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71474_y.field_74330_P = false;
            if (this.preGeneratorIsRunning && this.preGeneratorProgressStatus != "Done") {
                FontRenderer fontRenderer = mc.field_71466_p;
                GlStateManager.func_179094_E();
                ArrayList<String> list = new ArrayList<String>();
                list.add("Generating \"" + this.pregenerationWorld + "\" " + (this.progressScreenWorldSizeInBlocks > 0 ? "(" + this.progressScreenWorldSizeInBlocks + "x" + this.progressScreenWorldSizeInBlocks + " blocks)" : ""));
                list.add("Progress: " + this.preGeneratorProgress + "%");
                list.add("Chunks: " + this.preGeneratorProgressStatus);
                list.add("Elapsed: " + this.progressScreenElapsedTime);
                list.add("Estimated: " + this.progressScreenEstimatedTime);
                long i = Runtime.getRuntime().maxMemory();
                long j = Runtime.getRuntime().totalMemory();
                long k = Runtime.getRuntime().freeMemory();
                long l = j - k;
                list.add("Memory: " + Long.valueOf(this.BytesToMb(l)) + "/" + Long.valueOf(this.BytesToMb(i)) + " MB");
                for (int zi = 0; zi < list.size(); ++zi) {
                    String s = (String)list.get(zi);
                    if (Strings.isNullOrEmpty((String)s)) continue;
                    int zj = fontRenderer.field_78288_b;
                    int zk = fontRenderer.func_78256_a(s);
                    int zi1 = 2 + zj * zi;
                    Gui.func_73734_a((int)1, (int)(zi1 - 1), (int)(2 + zk + 1), (int)(zi1 + zj - 1), (int)-1873784752);
                    fontRenderer.func_78276_b(s, 2, zi1, 0xE0E0E0);
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    public void ToggleIngameUI() {
        if (this.preGeneratorIsRunning && this.preGeneratorProgressStatus != "Done" || this.menuOpen) {
            if (this.menuOpen) {
                Minecraft.func_71410_x().field_71474_y.field_74330_P = false;
                this.menuOpen = false;
            } else if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                this.menuOpen = true;
            }
        }
    }

    private long BytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public void shutDown(World world) {
        if (this.preGeneratorIsRunning) {
            this.SavePreGeneratorData(world);
            this.preGeneratorIsRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SavePreGeneratorData(World world) {
        if (this.preGeneratorIsRunning) {
            File pregeneratedChunksFile = new File(world.func_72860_G().func_75765_b() + "/OpenTerrainGenerator/PregeneratedChunks.txt");
            if (pregeneratedChunksFile.exists()) {
                pregeneratedChunksFile.delete();
            }
            StringBuilder stringbuilder = new StringBuilder();
            stringbuilder.append(this.spawned + "," + this.left + "," + this.top + "," + this.right + "," + this.bottom + "," + this.cycle + "," + (System.currentTimeMillis() - this.startTime) + "," + this.iTop + "," + this.iBottom + "," + this.iLeft + "," + this.iRight);
            BufferedWriter writer = null;
            try {
                pregeneratedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(pregeneratedChunksFile));
                writer.write(stringbuilder.toString());
                TerrainControl.log(LogMarker.TRACE, "Pre-generator data saved", new Object[0]);
            }
            catch (IOException e) {
                TerrainControl.log(LogMarker.ERROR, "Could not save pre-generator data.", new Object[0]);
                e.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void LoadPreGeneratorData(WorldServer worldServer) {
        File pregeneratedChunksFile = new File(worldServer.func_72860_G().func_75765_b() + "/OpenTerrainGenerator/PregeneratedChunks.txt");
        String[] pregeneratedChunksFileValues = new String[]{};
        if (pregeneratedChunksFile.exists()) {
            try {
                StringBuilder stringbuilder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new FileReader(pregeneratedChunksFile));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        pregeneratedChunksFileValues = stringbuilder.toString().split(",");
                    }
                    TerrainControl.log(LogMarker.TRACE, "Pre-generator data loaded", new Object[0]);
                }
                finally {
                    reader.close();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (pregeneratedChunksFileValues.length > 0) {
            this.spawned = Integer.parseInt(pregeneratedChunksFileValues[0]);
            this.left = Integer.parseInt(pregeneratedChunksFileValues[1]);
            this.top = Integer.parseInt(pregeneratedChunksFileValues[2]);
            this.right = Integer.parseInt(pregeneratedChunksFileValues[3]);
            this.bottom = Integer.parseInt(pregeneratedChunksFileValues[4]);
            this.cycle = Integer.parseInt(pregeneratedChunksFileValues[5]);
            this.startTime = System.currentTimeMillis() - Long.parseLong(pregeneratedChunksFileValues[6]);
            this.iTop = Integer.parseInt(pregeneratedChunksFileValues[7]);
            this.iBottom = Integer.parseInt(pregeneratedChunksFileValues[8]);
            this.iLeft = Integer.parseInt(pregeneratedChunksFileValues[9]);
            this.iRight = Integer.parseInt(pregeneratedChunksFileValues[10]);
        }
    }
}

