/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.TXWorldType;
import com.khorn.terraincontrol.forge.generator.Cartographer;
import com.khorn.terraincontrol.forge.generator.TXTeleporter;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerEventListener {
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            boolean cartographerEnabled;
            ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().ProcessTick();
            if (((ForgeEngine)TerrainControl.getEngine()).getOverWorld() != null && (cartographerEnabled = ((ForgeEngine)TerrainControl.getEngine()).getCartographerEnabled())) {
                Cartographer.UpdateWorldMap();
            }
            this.TeleportPlayers();
        }
    }

    private void TeleportPlayers() {
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (WorldServer worldServer : mcServer.field_71305_c) {
            if (!(worldServer.func_72912_H().func_76067_t() instanceof TXWorldType)) continue;
            ArrayList players = new ArrayList(worldServer.field_73010_i);
            for (EntityPlayer player : players) {
                this.tryTeleportPlayer(player);
            }
        }
    }

    public void tryTeleportPlayer(EntityPlayer player) {
        ForgeWorld playerWorld;
        if (player.func_180425_c().func_177956_o() < 0) {
            ForgeWorld playerWorld2 = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(player.field_70170_p);
            if (playerWorld2 != null && playerWorld2.getConfigs().getWorldConfig().dimensionBelow != null && playerWorld2.getConfigs().getWorldConfig().dimensionBelow.trim().length() > 0) {
                ForgeWorld destinationWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(playerWorld2.getConfigs().getWorldConfig().dimensionBelow);
                if (destinationWorld == null) {
                    destinationWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getUnloadedWorld(playerWorld2.getConfigs().getWorldConfig().dimensionBelow);
                }
                if (destinationWorld != null) {
                    if (destinationWorld == playerWorld2) {
                        player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n(), 254, player.func_180425_c().func_177952_p()));
                        player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n(), 255, player.func_180425_c().func_177952_p()));
                        player.func_70634_a((double)player.func_180425_c().func_177958_n(), 254.0, (double)player.func_180425_c().func_177952_p());
                    } else {
                        this.TeleportPlayerToDimension(playerWorld2.getWorld().field_73011_w.getDimension(), destinationWorld.getWorld().field_73011_w.getDimension(), player);
                    }
                }
            }
        } else if (player.func_180425_c().func_177956_o() > 255 && (playerWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(player.field_70170_p)) != null && playerWorld.getConfigs().getWorldConfig().dimensionAbove != null && playerWorld.getConfigs().getWorldConfig().dimensionAbove.trim().length() > 0) {
            ForgeWorld destinationWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(playerWorld.getConfigs().getWorldConfig().dimensionAbove);
            if (destinationWorld == null) {
                destinationWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getUnloadedWorld(playerWorld.getConfigs().getWorldConfig().dimensionAbove);
            }
            if (destinationWorld != null && destinationWorld != playerWorld) {
                this.TeleportPlayerToDimension(playerWorld.getWorld().field_73011_w.getDimension(), destinationWorld.getWorld().field_73011_w.getDimension(), player);
            }
        }
    }

    private void TeleportPlayerToDimension(int originDimension, int newDimension, EntityPlayer e) {
        boolean cartographerEnabled = ((ForgeEngine)TerrainControl.getEngine()).getCartographerEnabled();
        if (e instanceof EntityPlayerMP) {
            TXTeleporter.changeDimension(newDimension, (EntityPlayerMP)e, false);
        }
        if (originDimension == 0 && cartographerEnabled) {
            Cartographer.CreateBlockWorldMapAtSpawn(ChunkCoordinate.fromBlockCoords(e.func_180425_c().func_177958_n(), e.func_180425_c().func_177952_p()), true);
        }
    }
}

