/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeMaterialData;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.generator.Cartographer;
import com.khorn.terraincontrol.forge.generator.TXBlockPortal;
import com.khorn.terraincontrol.forge.generator.TXTeleporter;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityTravelToDimensionListener {
    @SubscribeEvent
    public void entityTravelToDimension(EntityTravelToDimensionEvent e) {
        boolean cartographerEnabled = ((ForgeEngine)TerrainControl.getEngine()).getCartographerEnabled();
        if (e.getDimension() == -1) {
            if (!ForgeMaterialData.ofMinecraftBlockState(e.getEntity().func_130014_f_().func_180495_p(e.getEntity().func_180425_c())).toDefaultMaterial().equals((Object)DefaultMaterial.PORTAL)) {
                e.getEntity().field_71088_bW = 0;
                e.setCanceled(true);
                return;
            }
            Entity sender = e.getEntity();
            BlockPos playerPos = new BlockPos((Vec3i)sender.func_180425_c());
            World world = sender.func_130014_f_();
            BlockPos pos = new BlockPos((Vec3i)sender.func_180425_c());
            IBlockState blockState = world.func_180495_p(pos);
            while (!blockState.func_185904_a().func_76220_a() && pos.func_177956_o() > 0) {
                pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                blockState = world.func_180495_p(pos);
            }
            ArrayList<LocalWorld> forgeWorlds = ((ForgeEngine)TerrainControl.getEngine()).getAllWorlds();
            int destinationDim = 0;
            boolean bPortalMaterialFound = false;
            ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockState);
            for (LocalWorld localWorld : forgeWorlds) {
                ForgeWorld forgeWorld = (ForgeWorld)localWorld;
                ArrayList<LocalMaterialData> portalMaterials = forgeWorld.getConfigs().getWorldConfig().DimensionPortalMaterials;
                boolean bIsPortalMaterial = false;
                for (LocalMaterialData portalMaterial : portalMaterials) {
                    if (!material.toDefaultMaterial().equals((Object)portalMaterial.toDefaultMaterial()) || material.getBlockData() != portalMaterial.getBlockData()) continue;
                    bIsPortalMaterial = true;
                    bPortalMaterialFound = true;
                    break;
                }
                if (!bIsPortalMaterial) continue;
                if (forgeWorld.getWorld().field_73011_w.getDimension() != e.getEntity().field_71093_bK) {
                    destinationDim = forgeWorld.getWorld().field_73011_w.getDimension();
                    break;
                }
                destinationDim = 0;
            }
            if (!bPortalMaterialFound && !material.toDefaultMaterial().equals((Object)DefaultMaterial.OBSIDIAN)) {
                e.getEntity().func_130014_f_().func_175698_g(e.getEntity().func_180425_c());
                e.setCanceled(true);
                return;
            }
            if (pos.func_177956_o() > 0 && bPortalMaterialFound) {
                boolean isCartographerPortal;
                e.setCanceled(true);
                int originDimension = e.getEntity().field_71093_bK;
                int newDimension = destinationDim;
                boolean bl = isCartographerPortal = cartographerEnabled && blockState.func_177230_c() == Blocks.field_150371_ca && (byte)blockState.func_177230_c().func_176201_c(blockState) == 1;
                if (isCartographerPortal) {
                    newDimension = Cartographer.CartographerDimension;
                }
                if (newDimension == 0 && e.getEntity().field_71093_bK == 0) {
                    e.getEntity().func_130014_f_().func_175698_g(e.getEntity().func_180425_c());
                    return;
                }
                TXBlockPortal.placeInExistingPortal(originDimension, playerPos);
                if (e.getEntity() instanceof EntityPlayerMP) {
                    TXTeleporter.changeDimension(newDimension, (EntityPlayerMP)e.getEntity());
                } else {
                    TXTeleporter.changeDimension(newDimension, e.getEntity());
                }
                if (originDimension == 0 && cartographerEnabled) {
                    Cartographer.CreateBlockWorldMapAtSpawn(ChunkCoordinate.fromBlockCoords(playerPos.func_177958_n(), playerPos.func_177952_p()), true);
                }
            }
        }
    }
}

