/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.client.events;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.forge.WorldLoader;
import com.khorn.terraincontrol.logging.LogMarker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class ClientNetworkEventListener {
    private final WorldLoader worldLoader;

    public ClientNetworkEventListener(WorldLoader worldLoader) {
        this.worldLoader = worldLoader;
    }

    @SubscribeEvent
    public void onPacketReceive(FMLNetworkEvent.ClientCustomPacketEvent event) {
        if (event.getManager().func_150731_c()) {
            return;
        }
        FMLProxyPacket receivedPacket = event.getPacket();
        ByteBuf stream = receivedPacket.payload();
        try {
            int serverProtocolVersion = stream.readInt();
            int clientProtocolVersion = 5;
            if (serverProtocolVersion == clientProtocolVersion) {
                WorldClient worldMC = FMLClientHandler.instance().getClient().field_71441_e;
                if (stream.readableBytes() > 4 && worldMC != null) {
                    DataInputStream wrappedStream = new DataInputStream((InputStream)new ByteBufInputStream(stream));
                    this.worldLoader.registerClientWorldBukkit(worldMC, wrappedStream);
                }
                TerrainControl.log(LogMarker.TRACE, "Config received from server", new Object[0]);
            } else {
                if (serverProtocolVersion > 5) {
                    this.sendMessage(TextFormatting.GREEN, "The server is running a newer version of OpenTerrainGenerator. Please update!");
                } else {
                    this.sendMessage(TextFormatting.YELLOW, "The server is running an outdated version of OpenTerrainGenerator. Cannot load custom biome colors and weather.");
                }
                TerrainControl.log(LogMarker.WARN, "Server has different protocol version. Client: {} Server: {}", 5, serverProtocolVersion);
            }
        }
        catch (Exception e) {
            TerrainControl.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
            TerrainControl.printStackTrace(LogMarker.FATAL, e);
            TerrainControl.log(LogMarker.FATAL, "Packet contents: {}", Arrays.toString(stream.array()));
            this.sendMessage(TextFormatting.RED, "Error receiving packet.");
        }
    }

    private void sendMessage(TextFormatting color, String message) {
        TextComponentString chat = new TextComponentString("OpenTerrainGenerator: " + message);
        Style chatStyle = new Style();
        chatStyle.func_150238_a(color);
        chat.func_150255_a(chatStyle);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)chat);
    }
}

