/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ServerConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.exception.BiomeNotFoundException;
import com.khorn.terraincontrol.forge.ForgeBiome;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.TXDimensionManager;
import com.khorn.terraincontrol.forge.TXWorldType;
import com.khorn.terraincontrol.forge.events.PlayerTracker;
import com.khorn.terraincontrol.forge.util.CommandHelper;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.minecraftTypes.MobNames;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;

final class TXCommandHandler
implements ICommand {
    private final List<String> aliases = Arrays.asList("otg");
    public static final TextFormatting ERROR_COLOR = TextFormatting.RED;
    public static final TextFormatting MESSAGE_COLOR = TextFormatting.GREEN;
    public static final TextFormatting VALUE_COLOR = TextFormatting.DARK_GREEN;

    TXCommandHandler() {
    }

    public String func_71517_b() {
        return "otg";
    }

    public String func_71518_a(ICommandSender var1) {
        return "otg";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] argString) {
        World mcWorld = sender.func_130014_f_();
        boolean isOp = sender.func_70003_b(2, this.func_71517_b());
        if (!mcWorld.field_72995_K) {
            ForgeWorld world = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld(mcWorld);
            if (world == null && (!argString[0].equals("dimension") && !argString[0].equals("dim") || argString.length >= 3)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "OpenTerrainGenerator is not enabled for this world.", new Object[0]));
                return;
            }
            BlockPos pos = sender.func_180425_c();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (argString == null || argString.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("-- OpenTerrainGenerator --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("Commands:"));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg worldinfo " + VALUE_COLOR + "Show author and description information for this world."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg biome (-f, -s, -d, -m) " + VALUE_COLOR + "Show biome information for the biome at the player's coordinates."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg entities " + VALUE_COLOR + "Show a list of entities that can be spawned inside BO3's using the Entity() tag."));
                if (isOp) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg pregen <radius> " + VALUE_COLOR + "Sets the pre-generation radius to <radius> chunks. Same as /otg pregenerator <radius>."));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim " + VALUE_COLOR + "Shows the name and id of the dimension the player is currently in. Same as /otg dimension."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim -l " + VALUE_COLOR + "Shows a list of all dimensions. Same as /otg dimension -l."));
                if (isOp) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim -c <dimension name> " + VALUE_COLOR + "Creates a dimension using world and biome configs from mods/OpenTerrainGenerator/worlds/<dimension name>. Custom dimensions can be accessed via a quartz portal. Biome names must be unique across dimensions. Same as /otg dimension -c <dimension name>"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim -d <dimension name> " + VALUE_COLOR + "Deletes the specified dimension. Dimension must be unloaded (dimensions unload automatically when no players are inside, this may take a minute). Same as /otg dimension -d <dimension name>"));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("Tips:"));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- Check out OpenTerrainGenerator.ini and each world's WorldConfig.ini for optional features."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- When using the pre-generator in single player open the chat window so you can background MC without pausing the game."));
            } else if (argString[0].equals("worldinfo") || argString[0].equals("world")) {
                WorldConfig worldConfig = world.getConfigs().getWorldConfig();
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("-- World info --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Author: " + VALUE_COLOR + worldConfig.author));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Description: " + VALUE_COLOR + worldConfig.description));
            } else if (isOp && (argString[0].equals("pregenerator") || argString[0].equals("pregen"))) {
                if (argString.length > 1) {
                    int radius = 0;
                    try {
                        radius = Integer.parseInt(argString[1]);
                    }
                    catch (NumberFormatException ex) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "\"" + argString[1] + "\" could not be parsed as a number.", new Object[0]));
                        return;
                    }
                    world = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getWorld((World)DimensionManager.getWorld((int)0));
                    int newRadius = world.getConfigs().getWorldConfig().PreGenerationRadius = ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().setPregenerationRadius(radius, world.getWorld());
                    ((ServerConfigProvider)world.getConfigs()).saveWorldConfig();
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Pre-generator radius set to " + VALUE_COLOR + newRadius + MESSAGE_COLOR + ".", new Object[0]));
                    return;
                }
            } else if (argString[0].equals("entities")) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                TerrainControl.log(LogMarker.INFO, "-- Entities List --", new Object[0]);
                sender.func_145747_a((ITextComponent)new TextComponentString("-- Entities List --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Some of these, like ThrownPotion, FallingSand, Mob and Painting may crash the game so be sure to test your BO3 in single player."));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                EnumCreatureType[] aenumcreaturetype = EnumCreatureType.values();
                Iterator newRadius = EntityList.field_75625_b.keySet().iterator();
                while (newRadius.hasNext()) {
                    String entry;
                    String msg = entry = (String)newRadius.next();
                    for (int k3 = 0; k3 < aenumcreaturetype.length; ++k3) {
                        EnumCreatureType enumcreaturetype = aenumcreaturetype[k3];
                        if (!enumcreaturetype.func_75598_a().isAssignableFrom((Class)EntityList.field_75625_b.get(entry))) continue;
                        msg = msg + VALUE_COLOR + " (" + enumcreaturetype.name() + ")";
                    }
                    TerrainControl.log(LogMarker.INFO, msg.replace("\u00ef\u00bf\u00bd2", "").replace("\u00ef\u00bf\u00bd", "").replace("\u00ef\u00bf\u00bda", ""), new Object[0]);
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- " + msg));
                }
                TerrainControl.log(LogMarker.INFO, "----", new Object[0]);
            } else if (argString[0].equals("dimension") || argString[0].equals("dim")) {
                if (argString.length < 2) {
                    int dimId = sender.func_130014_f_().field_73011_w.getDimension();
                    DimensionType dimension = DimensionManager.getProviderType((int)dimId);
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Currently in dimension " + VALUE_COLOR + dimension.func_186065_b() + MESSAGE_COLOR + " at id " + VALUE_COLOR + dimId + MESSAGE_COLOR + ".", new Object[0]));
                } else if (CommandHelper.containsArgument(argString, "-l")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentString("-- Dimensions --"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    int dimId = sender.func_130014_f_().field_73011_w.getDimension();
                    DimensionType dimension = DimensionManager.getProviderType((int)dimId);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Currently in dimension " + VALUE_COLOR + dimension.func_186065_b() + MESSAGE_COLOR + " at id " + VALUE_COLOR + dimId + MESSAGE_COLOR + ".", new Object[0]));
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    for (int i = -1; i < 1024; ++i) {
                        if (!DimensionManager.isDimensionRegistered((int)i)) continue;
                        DimensionType dimensionType = DimensionManager.getProviderType((int)i);
                        String msg = VALUE_COLOR + dimensionType.func_186065_b() + MESSAGE_COLOR + " at id " + VALUE_COLOR + i + (TerrainControl.getUnloadedWorld(dimensionType.func_186065_b()) == null ? MESSAGE_COLOR + " (loaded)" : VALUE_COLOR + " (unloaded)");
                        sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- " + msg));
                    }
                } else if (isOp && argString.length > 2) {
                    WorldServer overWorld;
                    String mainWorldName;
                    String dimName = argString[2];
                    if (argString.length > 3) {
                        for (int i = 3; i < argString.length; ++i) {
                            dimName = dimName + " " + argString[i];
                        }
                    }
                    if ((mainWorldName = (overWorld = DimensionManager.getWorld((int)0)).func_72912_H().func_76065_j()).toLowerCase().trim().equals(dimName.toLowerCase().trim())) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Dimension name cannot be the same as world name.", new Object[0]));
                        return;
                    }
                    int existingDim = 0;
                    for (int i = 2; i < 1024; ++i) {
                        DimensionType dimensionType;
                        if (!DimensionManager.isDimensionRegistered((int)i) || !(dimensionType = DimensionManager.getProviderType((int)i)).func_186067_c().equals("OTG") || !dimensionType.func_186065_b().equals(dimName)) continue;
                        existingDim = i;
                        if (!CommandHelper.containsArgument(argString, "-c")) continue;
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Dimension '" + dimName + "' already exists.", new Object[0]));
                        return;
                    }
                    if (CommandHelper.containsArgument(argString, "-d")) {
                        if (existingDim > 1) {
                            if (((ForgeEngine)TerrainControl.getEngine()).worldLoader.isWorldUnloaded(dimName)) {
                                ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)TerrainControl.getEngine()).getUnloadedWorld(dimName);
                                TXDimensionManager.DeleteDimension(existingDim, forgeWorld, server, true);
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Deleted dimension " + VALUE_COLOR + dimName + MESSAGE_COLOR + " at id " + VALUE_COLOR + existingDim + MESSAGE_COLOR + ".", new Object[0]));
                                PlayerTracker.SendAllWorldAndBiomeConfigsToAllPlayers(sender.func_184102_h());
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Cannot delete dimension " + VALUE_COLOR + dimName + ERROR_COLOR + ", it is currently loaded. Dimensions are unloaded automatically if no players are inside (this may take a minute).", new Object[0]));
                            }
                        }
                    } else if (CommandHelper.containsArgument(argString, "-c")) {
                        File worldConfigFile = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds/" + dimName + "/WorldConfig.ini");
                        if (!worldConfigFile.exists()) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Could not create dimension, mods/OpenTerrainGenerator/worlds/" + dimName + " could not be found or does not contain a WorldConfig.ini file.", new Object[0]));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Creating new dimension...", new Object[0]));
                            int newDimId = TXDimensionManager.createDimension(dimName, false, true, true);
                            ForgeWorld createdWorld = (ForgeWorld)TerrainControl.getWorld(dimName);
                            DimensionManager.unloadWorld((int)createdWorld.getWorld().field_73011_w.getDimension());
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Created dimension " + VALUE_COLOR + dimName + MESSAGE_COLOR + " at id " + VALUE_COLOR + newDimId + MESSAGE_COLOR + ".", new Object[0]));
                            PlayerTracker.SendAllWorldAndBiomeConfigsToAllPlayers(sender.func_184102_h());
                        }
                    }
                }
            } else {
                if (argString[0].equals("biome")) {
                    LocalBiome savedBiome;
                    if (!(sender.func_130014_f_().func_72912_H().func_76067_t() instanceof TXWorldType)) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Biome information is not available for this dimension.", new Object[0]));
                        return;
                    }
                    LocalBiome biome = world.getBiome(x, z);
                    BiomeIds biomeIds = biome.getIds();
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "According to the biome generator, you are in the " + VALUE_COLOR + biome.getName() + MESSAGE_COLOR + " biome, with id " + VALUE_COLOR + biomeIds.getGenerationId(), new Object[0]));
                    if (CommandHelper.containsArgument(argString, "-f")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "The base temperature of this biome is " + VALUE_COLOR + biome.getBiomeConfig().biomeTemperature + MESSAGE_COLOR + ", \n" + MESSAGE_COLOR + " at your height it is " + VALUE_COLOR + biome.getTemperatureAt(x, y, z), new Object[0]));
                    }
                    if (CommandHelper.containsArgument(argString, "-s")) {
                        try {
                            savedBiome = world.getSavedBiome(x, z);
                            BiomeIds savedIds = savedBiome.getIds();
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "According to the world save files, you are in the " + VALUE_COLOR + savedBiome.getName() + MESSAGE_COLOR + " biome, with id " + VALUE_COLOR + savedIds.getSavedId(), new Object[0]));
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    if (CommandHelper.containsArgument(argString, "-d")) {
                        try {
                            savedBiome = (ForgeBiome)world.getSavedBiome(x, z);
                            BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((Biome)((ForgeBiome)savedBiome).biomeBase);
                            String typesString = "";
                            for (BiomeDictionary.Type type : types) {
                                typesString = typesString.length() == 0 ? typesString + type.name() : typesString + ", " + type.name();
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "BiomeDict: " + VALUE_COLOR + typesString, new Object[0]));
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    if (CommandHelper.containsArgument(argString, "-m")) {
                        try {
                            ForgeBiome calculatedBiome = (ForgeBiome)world.getCalculatedBiome(x, z);
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("-- Biome mob spawning settings --", new Object[0]));
                            for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + creatureType.name() + ": ", new Object[0]));
                                ArrayList creatureList = (ArrayList)calculatedBiome.biomeBase.func_76747_a(creatureType);
                                if (creatureList == null || creatureList.size() <= 0) continue;
                                for (Biome.SpawnListEntry spawnListEntry : creatureList) {
                                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(VALUE_COLOR + "{\"mob\": \"" + MobNames.toInternalName(spawnListEntry.field_76300_b.getSimpleName()) + "\", \"weight\": " + spawnListEntry.field_76292_a + ", \"min\": " + spawnListEntry.field_76301_c + ", \"max\": " + spawnListEntry.field_76299_d + "}", new Object[0]));
                                }
                            }
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    return;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("Unknown command. Type /otg for a list of commands."));
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }

    public int compareTo(ICommand that) {
        return this.func_71517_b().compareTo(that.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return Collections.emptyList();
    }
}

