/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.customobjects.bo3.BO3Check;
import com.khorn.terraincontrol.customobjects.bo3.BO3Config;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.MaterialSet;
import java.util.List;

public final class BlockCheck
extends BO3Check {
    public MaterialSet toCheck;

    public BlockCheck(BO3Config config, List<String> args) throws InvalidConfigException {
        super(config);
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -100, 100);
        this.z = this.readInt(args.get(2), -100, 100);
        this.toCheck = this.readMaterials(args, 3);
    }

    public BlockCheck(BO3Config config, MaterialSet toCheck, int x, int y, int z) {
        super(config);
        this.toCheck = toCheck;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public boolean preventsSpawn(LocalWorld world, int x, int y, int z) {
        return !this.toCheck.contains(world.getMaterial(x, y, z));
    }

    @Override
    public String toString() {
        return "BlockCheck(" + this.x + ',' + this.y + ',' + this.z + this.makeMaterials(this.toCheck) + ')';
    }

    @Override
    public BO3Check rotate() {
        return new BlockCheck((BO3Config)this.getHolder(), this.toCheck.rotate(), this.z, this.y, -this.x);
    }
}

