/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.configuration.ConfigFile;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.SettingsMap;
import com.khorn.terraincontrol.configuration.standard.WorldStandardValues;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.bo3.BO3Check;
import com.khorn.terraincontrol.customobjects.bo3.BO3PlaceableFunction;
import com.khorn.terraincontrol.customobjects.bo3.BO3Settings;
import com.khorn.terraincontrol.customobjects.bo3.BranchFunction;
import com.khorn.terraincontrol.customobjects.bo3.EntityFunction;
import com.khorn.terraincontrol.customobjects.bo3.WeightedBranchFunction;
import com.khorn.terraincontrol.util.BoundingBox;
import com.khorn.terraincontrol.util.MaterialSet;
import com.khorn.terraincontrol.util.Rotation;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultStructurePart;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BO3Config
extends ConfigFile {
    public final File directory;
    public Map<String, CustomObject> otherObjects;
    public String author;
    public String description;
    public WorldConfig.ConfigMode settingsMode;
    public boolean tree;
    public int frequency;
    public double rarity;
    public boolean rotateRandomly;
    public BO3Settings.SpawnHeightEnum spawnHeight;
    public int spawnHeightOffset;
    public int spawnHeightVariance;
    public BO3Settings.ExtrudeMode extrudeMode;
    public MaterialSet extrudeThroughBlocks;
    public int minHeight;
    public int maxHeight;
    public List<String> excludedBiomes;
    public MaterialSet sourceBlocks;
    public int maxPercentageOutsideSourceBlock;
    public BO3Settings.OutsideSourceBlock outsideSourceBlock;
    public BO3PlaceableFunction[][] blocks = new BO3PlaceableFunction[4][];
    public BO3Check[][] bo3Checks = new BO3Check[4][];
    public int maxBranchDepth;
    public BranchFunction[][] branches = new BranchFunction[4][];
    public BoundingBox[] boundingBoxes = new BoundingBox[4];
    public EntityFunction[][] entityFunctions = new EntityFunction[4][];

    public BO3Config(SettingsMap reader, File directory, Map<String, CustomObject> otherObjects) {
        super(reader.getName());
        this.directory = directory;
        this.otherObjects = otherObjects;
        this.readConfigSettings(reader);
        this.correctSettings();
        this.rotateBlocksAndChecks();
    }

    @Override
    protected void writeConfigSettings(SettingsMap writer) {
        writer.bigTitle("BO3 object", "This is the config file of a custom object.", "If you add this object correctly to your BiomeConfigs, it will spawn in the world.", "");
        writer.putSetting(BO3Settings.AUTHOR, this.author, "This is the creator of this BO3 object");
        writer.putSetting(BO3Settings.DESCRIPTION, this.description, "A short description of this BO3 object");
        writer.putSetting(BO3Settings.VERSION, "3", "The BO3 version, don't change this! It can be used by external applications to do a version check.");
        writer.putSetting(WorldStandardValues.SETTINGS_MODE, this.settingsMode, "The settings mode, WriteAll, WriteWithoutComments or WriteDisable. See WorldConfig.");
        writer.bigTitle("Main settings", new String[0]);
        writer.putSetting(BO3Settings.TREE, this.tree, "This needs to be set to true to spawn the object in the Tree and Sapling resources.");
        writer.putSetting(BO3Settings.FREQUENCY, this.frequency, "The frequency of the BO3 from 1 to 200. Tries this many times to spawn this BO3 when using the CustomObject(...) resource.", "Ignored by Tree(..), Sapling(..) and CustomStructure(..)");
        writer.putSetting(BO3Settings.RARITY, this.rarity, "The rarity of the BO3 from 0 to 100. Each spawn attempt has rarity% chance to succeed when using the CustomObject(...) resource.", "Ignored by Tree(..), Sapling(..) and CustomStructure(..)");
        writer.putSetting(BO3Settings.ROTATE_RANDOMLY, this.rotateRandomly, "If you set this to true, the BO3 will be placed with a random rotation.");
        writer.putSetting(BO3Settings.SPAWN_HEIGHT, this.spawnHeight, "The spawn height of the BO3 - atMinY, randomY, highestBlock or highestSolidBlock.");
        writer.putSetting(BO3Settings.SPAWN_HEIGHT_OFFSET, this.spawnHeightOffset, "The offset from the spawn height to spawn this BO3", "Ex. SpawnHeight = highestSolidBlock, SpawnHeightOffset = 3; This object will spawn 3 blocks above the highest solid block");
        writer.putSetting(BO3Settings.SPAWN_HEIGHT_VARIANCE, this.spawnHeightVariance, "A random amount to offset the spawn location from the spawn offset height", "Ex. SpawnHeightOffset = 3, SpawnHeightVariance = 3; This object will spawn 3 to 6 blocks above the original spot it would have spawned");
        writer.smallTitle("Height Limits for the BO3.", new String[0]);
        writer.putSetting(BO3Settings.MIN_HEIGHT, this.minHeight, "When in randomY mode used as the minimum Y or in atMinY mode as the actual Y to spawn this BO3 at.");
        writer.putSetting(BO3Settings.MAX_HEIGHT, this.maxHeight, "When in randomY mode used as the maximum Y to spawn this BO3 at.");
        writer.smallTitle("Extrusion settings", new String[0]);
        writer.putSetting(BO3Settings.EXTRUDE_MODE, this.extrudeMode, "The style of extrusion you wish to use - BottomDown, TopUp, None (Default)");
        writer.putSetting(BO3Settings.EXTRUDE_THROUGH_BLOCKS, this.extrudeThroughBlocks, "The blocks to extrude your BO3 through");
        writer.putSetting(BO3Settings.MAX_BRANCH_DEPTH, this.maxBranchDepth, "Objects can have other objects attacthed to it: branches. Branches can also", "have branches attached to it, which can also have branches, etc. This is the", "maximum branch depth for this objects.");
        writer.putSetting(BO3Settings.EXCLUDED_BIOMES, this.excludedBiomes, "When spawned with the UseWorld keyword, this BO3 should NOT spawn in the following biomes.", "If you write the BO3 name directly in the BiomeConfigs, this will be ignored.");
        writer.bigTitle("Source block settings", new String[0]);
        writer.putSetting(BO3Settings.SOURCE_BLOCKS, this.sourceBlocks, "The block(s) the BO3 should spawn in.");
        writer.putSetting(BO3Settings.MAX_PERCENTAGE_OUTSIDE_SOURCE_BLOCK, this.maxPercentageOutsideSourceBlock, "The maximum percentage of the BO3 that can be outside the SourceBlock.", "The BO3 won't be placed on a location with more blocks outside the SourceBlock than this percentage.");
        writer.putSetting(BO3Settings.OUTSIDE_SOURCE_BLOCK, this.outsideSourceBlock, "What to do when a block is about to be placed outside the SourceBlock? (dontPlace, placeAnyway)");
        this.writeResources(writer);
    }

    @Override
    protected void readConfigSettings(SettingsMap reader) {
        this.author = reader.getSetting(BO3Settings.AUTHOR);
        this.description = reader.getSetting(BO3Settings.DESCRIPTION);
        this.settingsMode = reader.getSetting(WorldStandardValues.SETTINGS_MODE);
        this.tree = reader.getSetting(BO3Settings.TREE);
        this.frequency = reader.getSetting(BO3Settings.FREQUENCY);
        this.rarity = reader.getSetting(BO3Settings.RARITY);
        this.rotateRandomly = reader.getSetting(BO3Settings.ROTATE_RANDOMLY);
        this.spawnHeight = reader.getSetting(BO3Settings.SPAWN_HEIGHT);
        this.spawnHeightOffset = reader.getSetting(BO3Settings.SPAWN_HEIGHT_OFFSET);
        this.spawnHeightVariance = reader.getSetting(BO3Settings.SPAWN_HEIGHT_VARIANCE);
        this.extrudeMode = reader.getSetting(BO3Settings.EXTRUDE_MODE);
        this.extrudeThroughBlocks = reader.getSetting(BO3Settings.EXTRUDE_THROUGH_BLOCKS);
        this.minHeight = reader.getSetting(BO3Settings.MIN_HEIGHT);
        this.maxHeight = reader.getSetting(BO3Settings.MAX_HEIGHT);
        this.maxBranchDepth = reader.getSetting(BO3Settings.MAX_BRANCH_DEPTH);
        this.excludedBiomes = new ArrayList<String>((Collection)reader.getSetting(BO3Settings.EXCLUDED_BIOMES));
        this.sourceBlocks = reader.getSetting(BO3Settings.SOURCE_BLOCKS);
        this.maxPercentageOutsideSourceBlock = reader.getSetting(BO3Settings.MAX_PERCENTAGE_OUTSIDE_SOURCE_BLOCK);
        this.outsideSourceBlock = reader.getSetting(BO3Settings.OUTSIDE_SOURCE_BLOCK);
        this.readConfigFunctions(reader);
    }

    private void readConfigFunctions(SettingsMap reader) {
        BoundingBox box = BoundingBox.newEmptyBox();
        ArrayList<BO3PlaceableFunction> tempBlocksList = new ArrayList<BO3PlaceableFunction>();
        ArrayList<BO3Check> tempChecksList = new ArrayList<BO3Check>();
        ArrayList<BranchFunction> tempBranchesList = new ArrayList<BranchFunction>();
        ArrayList<EntityFunction> tempEntitiesList = new ArrayList<EntityFunction>();
        for (ConfigFunction<BO3Config> res : reader.getConfigFunctions(this, true)) {
            if (res instanceof BO3PlaceableFunction) {
                BO3PlaceableFunction block = (BO3PlaceableFunction)res;
                box.expandToFit(block.x, block.y, block.z);
                tempBlocksList.add(block);
                continue;
            }
            if (res instanceof BO3Check) {
                tempChecksList.add((BO3Check)res);
                continue;
            }
            if (res instanceof WeightedBranchFunction) {
                tempBranchesList.add((WeightedBranchFunction)res);
                continue;
            }
            if (res instanceof BranchFunction) {
                tempBranchesList.add((BranchFunction)res);
                continue;
            }
            if (!(res instanceof EntityFunction)) continue;
            tempEntitiesList.add((EntityFunction)res);
        }
        this.blocks[0] = tempBlocksList.toArray(new BO3PlaceableFunction[tempBlocksList.size()]);
        this.bo3Checks[0] = tempChecksList.toArray(new BO3Check[tempChecksList.size()]);
        this.branches[0] = tempBranchesList.toArray(new BranchFunction[tempBranchesList.size()]);
        this.boundingBoxes[0] = box;
        this.entityFunctions[0] = tempEntitiesList.toArray(new EntityFunction[tempEntitiesList.size()]);
    }

    public void writeResources(SettingsMap writer) {
        writer.bigTitle("Blocks", "All the blocks used in the BO3 are listed here. Possible blocks:", "Block(x,y,z,id[.data][,nbtfile.nbt)", "RandomBlock(x,y,z,id[:data][,nbtfile.nbt],chance[,id[:data][,nbtfile.nbt],chance[,...]])", " So RandomBlock(0,0,0,CHEST,chest.nbt,50,CHEST,anotherchest.nbt,100) will spawn a chest at", " the BO3 origin, and give it a 50% chance to have the contents of chest.nbt, or, if that", " fails, a 100% percent chance to have the contents of anotherchest.nbt.", "MinecraftObject(x,y,z,name)", " Spawns an object in the Mojang NBT structure format. For example, ", " MinecraftObject(0,0,0," + DefaultStructurePart.IGLOO_BOTTOM.getPath() + ")", " spawns the bottom part of an igloo.");
        writer.addConfigFunctions(Arrays.asList(this.blocks[0]));
        writer.bigTitle("BO3 checks", "Require a condition at a certain location in order for the BO3 to be spawned.", "BlockCheck(x,y,z,BlockName[,BlockName[,...]]) - one of the blocks must be at the location", "BlockCheckNot(x,y,z,BlockName[,BlockName[,...]]) - all the blocks must not be at the location", "LightCheck(x,y,z,minLightLevel,maxLightLevel) - light must be between min and max (inclusive)", "", "You can use \"Solid\" as a BlockName for matching all solid blocks or \"All\" to match all blocks that aren't air.", "", "Examples:", "  BlockCheck(0,-1,0,GRASS,DIRT)  Require grass or dirt just below the object", "  BlockCheck(0,-1,0,Solid)       Require any solid block just below the object", "  BlockCheck(0,-1,0,WOOL)        Require any type of wool just below the object", "  BlockCheck(0,-1,0,WOOL:0)      Require white wool just below the object", "  BlockCheckNot(0,-1,0,WOOL:0)   Require that there is no white wool below the object", "  LightCheck(0,0,0,0,1)          Require almost complete darkness just below the object");
        writer.addConfigFunctions(Arrays.asList(this.bo3Checks[0]));
        writer.bigTitle("Branches", "Branches are objects that will spawn when this object spawns when it is used in", "the CustomStructure resource. Branches can also have branches, making complex", "structures possible. See the wiki for more details.", "", "Regular Branches spawn each branch with an independent chance of spawning.", "Branch(x,y,z,branchName,rotation,chance[,anotherBranchName,rotation,chance[,...]][IndividualChance])", "branchName - name of the object to spawn.", "rotation - NORTH, SOUTH, EAST or WEST.", "IndividualChance - The chance each branch has to spawn, assumed to be 100 when left blank", "", "Weighted Branches spawn branches with a dependent chance of spawning.", "WeightedBranch(x,y,z,branchName,rotation,chance[,anotherBranchName,rotation,chance[,...]][MaxChanceOutOf])", "MaxChanceOutOf - The chance all branches have to spawn out of, assumed to be 100 when left blank");
        writer.addConfigFunctions(Arrays.asList(this.branches[0]));
        writer.bigTitle("EntityFunctions", "Forge only (this may have changed, check for updates).", "An EntityFunction spawns an entity instead of a block. The entity is spawned only once when the BO3 is spawned.", "Entities are persistent by default so they don't de-spawn when no player is near, they are only unloaded.", "Usage: Entity(x,y,z,mobName,groupSize,NameTagOrNBTFileName) or Entity(x,y,z,mobName,groupSize)", "Use /otg entities to get a list of entities that can be used as mobName, this includes entities added by other mods.", "NameTagOrNBTFileName can be either a nametag for the mob or an nbt file (such as mymobinfo.nbt or mymobinfo.txt).", "When using a text file you can use the same mob spawning parameters used with the /summon command to equip the", "entity and give it custom attributes etc. You can copy the DATA part of a summon command including surrounding ", "curly braces to a .txt file, for instance for: \"/summon Skeleton x y z {DATA}\"");
        writer.addConfigFunctions(Arrays.asList(this.entityFunctions[0]));
    }

    @Override
    protected void correctSettings() {
        this.maxHeight = this.higherThanOrEqualTo(this.maxHeight, this.minHeight);
    }

    @Override
    protected void renameOldSettings(SettingsMap reader) {
    }

    public void rotateBlocksAndChecks() {
        for (int i = 1; i < 4; ++i) {
            int j;
            this.blocks[i] = new BO3PlaceableFunction[this.blocks[i - 1].length];
            for (j = 0; j < this.blocks[i].length; ++j) {
                this.blocks[i][j] = this.blocks[i - 1][j].rotate();
            }
            this.bo3Checks[i] = new BO3Check[this.bo3Checks[i - 1].length];
            for (j = 0; j < this.bo3Checks[i].length; ++j) {
                this.bo3Checks[i][j] = this.bo3Checks[i - 1][j].rotate();
            }
            this.branches[i] = new BranchFunction[this.branches[i - 1].length];
            for (j = 0; j < this.branches[i].length; ++j) {
                this.branches[i][j] = this.branches[i - 1][j].rotate();
            }
            this.boundingBoxes[i] = this.boundingBoxes[i - 1].rotate();
            this.entityFunctions[i] = new EntityFunction[this.entityFunctions[i - 1].length];
            for (j = 0; j < this.entityFunctions[i].length; ++j) {
                this.entityFunctions[i][j] = this.entityFunctions[i - 1][j].rotate();
            }
        }
    }

    public EntityFunction[] getEntityData(Rotation rotation) {
        return this.entityFunctions[rotation.getRotationId()];
    }
}

