/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.customobjects.Branch;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectCoordinate;
import com.khorn.terraincontrol.customobjects.StructurePartSpawnHeight;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import com.khorn.terraincontrol.util.helpers.RandomHelper;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class CustomObjectStructure {
    protected final Random random;
    protected LocalWorld world;
    protected CustomObjectCoordinate start;
    protected StructurePartSpawnHeight height;
    private Map<ChunkCoordinate, Set<CustomObjectCoordinate>> objectsToSpawn;
    private int maxBranchDepth;

    CustomObjectStructure(LocalWorld world, CustomObjectCoordinate start) {
        CustomObject object = start.getObject();
        this.world = world;
        this.start = start;
        this.height = object.getStructurePartSpawnHeight();
        this.maxBranchDepth = object.getMaxBranchDepth();
        this.random = RandomHelper.getRandomForCoords(start.getX(), start.getY(), start.getZ(), world.getSeed());
        this.objectsToSpawn = new LinkedHashMap<ChunkCoordinate, Set<CustomObjectCoordinate>>();
        this.addToSpawnList(start);
        this.addBranches(start, 1);
    }

    private void addBranches(CustomObjectCoordinate coordObject, int depth) {
        for (Branch branch : this.getBranches(coordObject.getObject(), coordObject.getRotation())) {
            CustomObjectCoordinate childCoordObject = branch.toCustomObjectCoordinate(this.world, this.random, coordObject.getX(), coordObject.getY(), coordObject.getZ());
            if (childCoordObject == null) continue;
            this.addToSpawnList(childCoordObject);
            if (depth >= this.maxBranchDepth) continue;
            this.addBranches(childCoordObject, depth + 1);
        }
    }

    private Branch[] getBranches(CustomObject customObject, Rotation rotation) {
        return customObject.getBranches(rotation);
    }

    private void addToSpawnList(CustomObjectCoordinate coordObject) {
        ChunkCoordinate chunkCoordinate = coordObject.getPopulatingChunk();
        Set<CustomObjectCoordinate> objectsInChunk = this.objectsToSpawn.get(chunkCoordinate);
        if (objectsInChunk == null) {
            objectsInChunk = new LinkedHashSet<CustomObjectCoordinate>();
            this.objectsToSpawn.put(chunkCoordinate, objectsInChunk);
        }
        objectsInChunk.add(coordObject);
    }

    public void spawnForChunk(ChunkCoordinate chunkCoordinate) {
        Set<CustomObjectCoordinate> objectsInChunk = this.objectsToSpawn.get(chunkCoordinate);
        if (objectsInChunk != null) {
            for (CustomObjectCoordinate coordObject : objectsInChunk) {
                coordObject.spawnWithChecks(this.world, this.height, this.random);
            }
        }
    }
}

