/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.StructurePartSpawnHeight;
import com.khorn.terraincontrol.util.BoundingBox;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import java.util.Random;

public class CustomObjectCoordinate {
    private final CustomObject object;
    private final Rotation rotation;
    private final int x;
    private int y;
    private final int z;

    public CustomObjectCoordinate(CustomObject object, Rotation rotation, int x, int y, int z) {
        this.object = object;
        this.rotation = rotation;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public CustomObject getObject() {
        return this.object;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    boolean spawnWithChecks(LocalWorld world, StructurePartSpawnHeight height, Random random) {
        this.y = height.getCorrectY(world, this.x, this.y, this.z);
        if (!this.object.canSpawnAt(world, this.rotation, this.x, this.y, this.z)) {
            return false;
        }
        return this.object.spawnForced(world, random, this.rotation, this.x, this.y, this.z);
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof CustomObjectCoordinate)) {
            return false;
        }
        CustomObjectCoordinate otherCoord = (CustomObjectCoordinate)otherObject;
        if (otherCoord.x != this.x) {
            return false;
        }
        if (otherCoord.y != this.y) {
            return false;
        }
        if (otherCoord.z != this.z) {
            return false;
        }
        if (!otherCoord.rotation.equals((Object)this.rotation)) {
            return false;
        }
        return otherCoord.object.getName().equals(this.object.getName());
    }

    public int hashCode() {
        return this.x >> 13 ^ this.y >> 7 ^ this.z ^ this.object.getName().hashCode() ^ this.rotation.toString().hashCode();
    }

    ChunkCoordinate getPopulatingChunk() {
        BoundingBox box = this.object.getBoundingBox(this.rotation);
        int centerX = this.x + box.getMinX() + box.getWidth() / 2;
        int centerZ = this.z + box.getMinZ() + box.getDepth() / 2;
        return ChunkCoordinate.getPopulatingChunk(centerX, centerZ);
    }
}

