/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration.settingType;

import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.helpers.StringHelper;

class FloatSetting
extends Setting<Float> {
    private final float defaultValue;
    private final float minValue;
    private final float maxValue;

    FloatSetting(String name, float defaultValue, float minValue, float maxValue) {
        super(name);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(this.defaultValue);
    }

    @Override
    public Float read(String string) throws InvalidConfigException {
        return Float.valueOf((float)StringHelper.readDouble(string, this.minValue, this.maxValue));
    }
}

