/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration.io;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.ConfigFunctionsManager;
import com.khorn.terraincontrol.configuration.ErroredFunction;
import com.khorn.terraincontrol.configuration.io.RawSettingValue;
import com.khorn.terraincontrol.configuration.io.SettingsMap;
import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.helpers.InheritanceHelper;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SimpleSettingsMap
implements SettingsMap {
    private final List<RawSettingValue> configFunctions;
    private SettingsMap fallback;
    private final String name;
    private final Map<String, RawSettingValue> settingsCache;
    private final boolean isNewConfig;
    private int dummyKeyIndex = 0;

    public SimpleSettingsMap(String name, boolean isNewConfig) {
        this.name = name;
        this.settingsCache = new LinkedHashMap<String, RawSettingValue>();
        this.configFunctions = new ArrayList<RawSettingValue>();
        this.isNewConfig = isNewConfig;
    }

    private String nextDummyKey() {
        ++this.dummyKeyIndex;
        return "__key" + this.dummyKeyIndex;
    }

    @Override
    public void addConfigFunctions(Collection<? extends ConfigFunction<?>> functions) {
        for (ConfigFunction<?> function : functions) {
            RawSettingValue value = RawSettingValue.create(RawSettingValue.ValueType.FUNCTION, function.toString());
            this.configFunctions.add(value);
            this.settingsCache.put(this.nextDummyKey(), value);
        }
    }

    @Override
    public <T> List<ConfigFunction<T>> getConfigFunctions(T holder, boolean useFallback) {
        ArrayList<ConfigFunction<T>> result = new ArrayList<ConfigFunction<T>>(this.configFunctions.size());
        ConfigFunctionsManager manager = TerrainControl.getConfigFunctionsManager();
        for (RawSettingValue configFunctionLine : this.configFunctions) {
            String parameters;
            List<String> args;
            int bracketIndex;
            String configFunctionString = configFunctionLine.getRawValue();
            String functionName = configFunctionString.substring(0, bracketIndex = configFunctionString.indexOf(40));
            ConfigFunction<T> function = manager.getConfigFunction(functionName, holder, args = Arrays.asList(StringHelper.readCommaSeperatedString(parameters = configFunctionString.substring(bracketIndex + 1, configFunctionString.length() - 1))));
            if (function == null) continue;
            result.add(function);
            if (!(function instanceof ErroredFunction) || !TerrainControl.getPluginConfig().SpawnLog) continue;
            TerrainControl.log(LogMarker.WARN, "Invalid resource {} in {} on line {}: {}", functionName, this.name, configFunctionLine.getLineNumber(), ((ErroredFunction)function).error);
        }
        if (useFallback && this.fallback != null) {
            return InheritanceHelper.mergeLists(result, this.fallback.getConfigFunctions(holder, true));
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<RawSettingValue> getRawSettings() {
        return Collections.unmodifiableCollection(this.settingsCache.values());
    }

    @Override
    public <S> S getSetting(Setting<S> setting) {
        return this.getSetting(setting, setting.getDefaultValue());
    }

    @Override
    public <S> S getSetting(Setting<S> setting, S defaultValue) {
        RawSettingValue stringWithLineNumber = this.settingsCache.get(setting.getName().toLowerCase());
        if (stringWithLineNumber != null) {
            String stringValue = stringWithLineNumber.getRawValue().split(":", 2)[1].trim();
            try {
                return setting.read(stringValue);
            }
            catch (InvalidConfigException e) {
                TerrainControl.log(LogMarker.ERROR, "The value \"{}\" is not valid for the setting {} in {} on line {}: {}", stringValue, setting, this.name, stringWithLineNumber.getLineNumber(), e.getMessage());
            }
        }
        if (this.fallback != null) {
            return this.fallback.getSetting(setting, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean hasSetting(Setting<?> setting) {
        if (this.settingsCache.containsKey(setting.getName().toLowerCase())) {
            return true;
        }
        if (this.fallback != null) {
            return this.fallback.hasSetting(setting);
        }
        return false;
    }

    @Override
    public boolean isNewConfig() {
        return this.isNewConfig;
    }

    @Override
    public <S> void putSetting(Setting<S> setting, S value, String ... comments) {
        RawSettingValue settingValue = RawSettingValue.ofPlainSetting(setting, value).withComments(comments);
        this.settingsCache.put(setting.getName().toLowerCase(), settingValue);
    }

    @Override
    public void renameOldSetting(String oldValue, Setting<?> newValue) {
        if (this.settingsCache.containsKey(oldValue.toLowerCase())) {
            this.settingsCache.put(newValue.getName().toLowerCase(), this.settingsCache.get(oldValue.toLowerCase()));
        }
    }

    @Override
    public void setFallback(SettingsMap reader) {
        this.fallback = reader;
    }

    @Override
    public void addRawSetting(RawSettingValue value) {
        switch (value.getType()) {
            case PLAIN_SETTING: {
                String[] split = value.getRawValue().split(":", 2);
                String settingName = split[0].toLowerCase().trim();
                this.settingsCache.put(settingName, value);
                break;
            }
            case FUNCTION: {
                this.configFunctions.add(value);
                this.settingsCache.put(this.nextDummyKey(), value);
                break;
            }
            default: {
                this.settingsCache.put(this.nextDummyKey(), value);
            }
        }
    }

    @Override
    public void smallTitle(String title, String ... comments) {
        this.settingsCache.put(this.nextDummyKey(), RawSettingValue.create(RawSettingValue.ValueType.SMALL_TITLE, title).withComments(comments));
    }

    @Override
    public void bigTitle(String title, String ... comments) {
        this.settingsCache.put(this.nextDummyKey(), RawSettingValue.create(RawSettingValue.ValueType.BIG_TITLE, title).withComments(comments));
    }

    public String toString() {
        return "SimpleSettingsMap [name=" + this.name + ", fallback=" + this.fallback + "]";
    }
}

