/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.BiomeConfigFinder;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.FileSettingsReader;
import com.khorn.terraincontrol.configuration.io.FileSettingsWriter;
import com.khorn.terraincontrol.configuration.io.SettingsMap;
import com.khorn.terraincontrol.configuration.standard.BiomeStandardValues;
import com.khorn.terraincontrol.configuration.standard.StandardBiomeTemplate;
import com.khorn.terraincontrol.customobjects.CustomObjectCollection;
import com.khorn.terraincontrol.customobjects.CustomObjectLoader;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.helpers.FileHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class ServerConfigProvider
implements ConfigProvider {
    private static final int MAX_INHERITANCE_DEPTH = 15;
    private LocalWorld world;
    private File settingsDir;
    private CustomObjectCollection customObjects;
    private WorldConfig worldConfig;
    private LocalBiome[] biomes;
    private int biomesCount;

    public ServerConfigProvider(File settingsDir, LocalWorld world) {
        this.settingsDir = settingsDir;
        this.world = world;
        this.biomes = new LocalBiome[world.getMaxBiomesCount()];
        this.loadSettings(false);
    }

    public ServerConfigProvider(File settingsDir, LocalWorld world, CustomObjectCollection customObjects) {
        this.settingsDir = settingsDir;
        this.world = world;
        this.biomes = new LocalBiome[world.getMaxBiomesCount()];
        this.customObjects = customObjects;
        this.loadSettings(true);
    }

    private void loadSettings(boolean loadCustomObjects) {
        if (loadCustomObjects) {
            SettingsMap worldConfigSettings = this.loadWorldConfig();
            this.loadBiomes(worldConfigSettings);
            this.worldConfig.biomeGroupManager.processBiomeData(this.world);
        } else {
            this.loadCustomObjects();
            SettingsMap worldConfigSettings = this.loadWorldConfig();
            this.loadBiomes(worldConfigSettings);
            this.worldConfig.biomeGroupManager.processBiomeData(this.world);
        }
    }

    private void loadCustomObjects() {
        File oldWorldObjectsDir = new File(this.settingsDir, "BOBPlugins");
        File worldObjectsDir = new File(this.settingsDir, "WorldObjects");
        if (!FileHelper.migrateFolder(oldWorldObjectsDir, worldObjectsDir)) {
            TerrainControl.log(LogMarker.WARN, "Failed to move old world custom objects from {} to {} in world {}. Please move the old objects manually.", oldWorldObjectsDir.getName(), worldObjectsDir.getName(), this.world.getName());
        }
        Map<String, CustomObjectLoader> objectLoaders = TerrainControl.getCustomObjectManager().getObjectLoaders();
        this.customObjects = new CustomObjectCollection(objectLoaders, worldObjectsDir);
        this.customObjects.setFallback(TerrainControl.getCustomObjectManager().getGlobalObjects());
        TerrainControl.log(LogMarker.INFO, "{} world custom objects loaded.", this.customObjects.getAll().size());
    }

    private SettingsMap loadWorldConfig() {
        File worldConfigFile = new File(this.settingsDir, "WorldConfig.ini");
        SettingsMap settingsMap = FileSettingsReader.read(this.world.getName(), worldConfigFile);
        this.worldConfig = new WorldConfig(this.settingsDir, settingsMap, this.world, this.customObjects);
        FileSettingsWriter.writeToFile(this.worldConfig.getSettingsAsMap(), worldConfigFile, this.worldConfig.SettingsMode);
        return settingsMap;
    }

    public void saveWorldConfig() {
        File worldConfigFile = new File(this.settingsDir, "WorldConfig.ini");
        FileSettingsWriter.writeToFile(this.worldConfig.getSettingsAsMap(), worldConfigFile, this.worldConfig.SettingsMode);
    }

    private void loadBiomes(SettingsMap worldConfigSettings) {
        ArrayList<File> biomeDirs = new ArrayList<File>(2);
        biomeDirs.add(new File(this.settingsDir, this.correctOldBiomeConfigFolder(this.settingsDir)));
        biomeDirs.add(new File(TerrainControl.getEngine().getTCDataFolder(), "GlobalBiomes"));
        FileHelper.makeFolders(biomeDirs);
        HashSet<BiomeLoadInstruction> biomesToLoad = new HashSet<BiomeLoadInstruction>();
        biomesToLoad.addAll(this.world.getDefaultBiomes());
        for (Map.Entry<String, Integer> entry : this.worldConfig.customBiomeGenerationIds.entrySet()) {
            String biomeName = entry.getKey();
            int generationId = entry.getValue();
            biomesToLoad.add(new BiomeLoadInstruction(biomeName, generationId, new StandardBiomeTemplate(this.worldConfig.worldHeightScale)));
        }
        BiomeConfigFinder biomeConfigFinder = new BiomeConfigFinder(this.worldConfig, TerrainControl.getPluginConfig().biomeConfigExtension);
        Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs = biomeConfigFinder.findBiomes(biomeDirs, biomesToLoad);
        Map<String, BiomeConfig> loadedBiomes = this.readAndWriteSettings(worldConfigSettings, biomeConfigStubs);
        String loadedBiomeNames = this.indexSettings(loadedBiomes);
        TerrainControl.log(LogMarker.INFO, "{} biomes Loaded", this.biomesCount);
        TerrainControl.log(LogMarker.TRACE, "{}", loadedBiomeNames);
    }

    @Override
    public WorldConfig getWorldConfig() {
        return this.worldConfig;
    }

    @Override
    public LocalBiome getBiomeByIdOrNull(int id) {
        if (id < 0 || id > this.biomes.length) {
            return null;
        }
        return this.biomes[id];
    }

    @Override
    public void reload() {
        Arrays.fill(this.biomes, null);
        this.biomesCount = 0;
        this.loadSettings(true);
    }

    private Map<String, BiomeConfig> readAndWriteSettings(SettingsMap worldConfigSettings, Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs) {
        HashMap<String, BiomeConfig> loadedBiomes = new HashMap<String, BiomeConfig>();
        for (BiomeConfigFinder.BiomeConfigStub biomeConfigStub : biomeConfigStubs.values()) {
            this.processInheritance(biomeConfigStubs, biomeConfigStub, 0);
            this.processMobInheritance(biomeConfigStubs, biomeConfigStub, 0);
            BiomeConfig biomeConfig = new BiomeConfig(biomeConfigStub.getLoadInstructions(), biomeConfigStub, biomeConfigStub.getSettings(), this.worldConfig);
            loadedBiomes.put(biomeConfigStub.getBiomeName(), biomeConfig);
            File writeFile = biomeConfigStub.getFile();
            if (!biomeConfig.biomeExtends.isEmpty()) {
                writeFile = new File(writeFile.getAbsolutePath() + ".inherited");
            }
            FileSettingsWriter.writeToFile(biomeConfig.getSettingsAsMap(), writeFile, this.worldConfig.SettingsMode);
        }
        return loadedBiomes;
    }

    private int getRequestedGenerationId(BiomeConfig biomeConfig) {
        Integer requestedGenerationId = DefaultBiome.getId(biomeConfig.getName());
        if (requestedGenerationId == null) {
            requestedGenerationId = biomeConfig.worldConfig.customBiomeGenerationIds.get(biomeConfig.getName());
        }
        if (requestedGenerationId == null) {
            throw new RuntimeException(biomeConfig.getName() + " is not a default biome and not a custom biome. This is a bug!");
        }
        return requestedGenerationId;
    }

    private String indexSettings(Map<String, BiomeConfig> loadedBiomes) {
        StringBuilder loadedBiomeNames = new StringBuilder();
        ArrayList<BiomeConfig> loadedBiomeList = new ArrayList<BiomeConfig>(loadedBiomes.values());
        Collections.sort(loadedBiomeList, new Comparator<BiomeConfig>(){

            @Override
            public int compare(BiomeConfig a, BiomeConfig b) {
                return ServerConfigProvider.this.getRequestedGenerationId(a) - ServerConfigProvider.this.getRequestedGenerationId(b);
            }
        });
        for (BiomeConfig biomeConfig : loadedBiomeList) {
            int requestedGenerationId;
            ++this.biomesCount;
            loadedBiomeNames.append(biomeConfig.getName());
            loadedBiomeNames.append(", ");
            int requestedSavedId = requestedGenerationId = this.getRequestedGenerationId(biomeConfig);
            if (!biomeConfig.replaceToBiomeName.isEmpty()) {
                BiomeConfig replaceToConfig = loadedBiomes.get(biomeConfig.replaceToBiomeName);
                if (replaceToConfig == null) {
                    TerrainControl.log(LogMarker.WARN, "Invalid ReplaceToBiomeName in biome {}: biome {} doesn't exist", biomeConfig.getName(), biomeConfig.replaceToBiomeName);
                    biomeConfig.replaceToBiomeName = "";
                } else if (!replaceToConfig.replaceToBiomeName.isEmpty()) {
                    TerrainControl.log(LogMarker.WARN, "Invalid ReplaceToBiomeName in biome {}: biome {} also has a ReplaceToBiomeName value", biomeConfig.getName(), biomeConfig.replaceToBiomeName);
                    biomeConfig.replaceToBiomeName = "";
                } else {
                    requestedSavedId = this.getRequestedGenerationId(replaceToConfig);
                }
            }
            LocalBiome biome = this.world.createBiomeFor(biomeConfig, new BiomeIds(requestedGenerationId, requestedSavedId), this);
            int generationId = biome.getIds().getGenerationId();
            this.biomes[generationId] = biome;
            this.worldConfig.customBiomeGenerationIds.put(biome.getName(), generationId);
            if (!this.worldConfig.BiomeConfigsHaveReplacement) {
                this.worldConfig.BiomeConfigsHaveReplacement = biomeConfig.replacedBlocks.hasReplaceSettings();
            }
            if (this.worldConfig.maxSmoothRadius < biomeConfig.smoothRadius) {
                this.worldConfig.maxSmoothRadius = biomeConfig.smoothRadius;
            }
            if (this.worldConfig.biomeMode != TerrainControl.getBiomeModeManager().FROM_IMAGE) continue;
            if (this.worldConfig.biomeColorMap == null) {
                this.worldConfig.biomeColorMap = new HashMap();
            }
            int color = biomeConfig.biomeColor;
            this.worldConfig.biomeColorMap.put(color, biome.getIds().getGenerationId());
        }
        ArrayList<LocalWorld> worlds = TerrainControl.getAllWorlds();
        if (worlds != null) {
            for (LocalWorld world : worlds) {
                if (this.worldConfig.maxSmoothRadius >= world.getConfigs().getWorldConfig().maxSmoothRadius) continue;
                this.worldConfig.maxSmoothRadius = world.getConfigs().getWorldConfig().maxSmoothRadius;
            }
        }
        if (this.biomesCount > 0) {
            loadedBiomeNames.delete(loadedBiomeNames.length() - 2, loadedBiomeNames.length());
        }
        return loadedBiomeNames.toString();
    }

    private void processInheritance(Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, BiomeConfigFinder.BiomeConfigStub biomeConfigStub, int currentDepth) {
        if (biomeConfigStub.biomeExtendsProcessed) {
            return;
        }
        String extendedBiomeName = biomeConfigStub.getSettings().getSetting(BiomeStandardValues.BIOME_EXTENDS);
        if (extendedBiomeName.isEmpty()) {
            biomeConfigStub.biomeExtendsProcessed = true;
            return;
        }
        BiomeConfigFinder.BiomeConfigStub extendedBiomeConfig = biomeConfigStubs.get(extendedBiomeName);
        if (extendedBiomeConfig == null) {
            TerrainControl.log(LogMarker.WARN, "The biome {} tried to extend the biome {}, but that biome doesn't exist.", biomeConfigStub.getBiomeName(), extendedBiomeName);
            return;
        }
        if (currentDepth > 15) {
            TerrainControl.log(LogMarker.FATAL, "The biome {} cannot extend the biome {} - too much configs processed already! Cyclical inheritance?", biomeConfigStub.getBiomeName(), extendedBiomeConfig.getBiomeName());
        }
        if (!extendedBiomeConfig.biomeExtendsProcessed) {
            this.processInheritance(biomeConfigStubs, extendedBiomeConfig, currentDepth + 1);
        }
        biomeConfigStub.getSettings().setFallback(extendedBiomeConfig.getSettings());
        biomeConfigStub.biomeExtendsProcessed = true;
    }

    private void processMobInheritance(Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, BiomeConfigFinder.BiomeConfigStub biomeConfigStub, int currentDepth) {
        if (biomeConfigStub.inheritMobsBiomeNameProcessed) {
            return;
        }
        String stubInheritMobsBiomeName = biomeConfigStub.getSettings().getSetting(BiomeStandardValues.INHERIT_MOBS_BIOME_NAME, biomeConfigStub.getLoadInstructions().getBiomeTemplate().defaultInheritMobsBiomeName);
        if (stubInheritMobsBiomeName != null && stubInheritMobsBiomeName.length() > 0) {
            String[] inheritMobsBiomeNames;
            for (String inheritMobsBiomeName : inheritMobsBiomeNames = stubInheritMobsBiomeName.split(",")) {
                if (inheritMobsBiomeName.isEmpty()) {
                    biomeConfigStub.inheritMobsBiomeNameProcessed = true;
                    return;
                }
                BiomeConfigFinder.BiomeConfigStub inheritMobsBiomeConfig = biomeConfigStubs.get(inheritMobsBiomeName);
                if (inheritMobsBiomeConfig == null) {
                    TerrainControl.log(LogMarker.WARN, "The biome {} tried to inherit mobs from the biome {}, but that biome doesn't exist.", biomeConfigStub.getFile().getName(), inheritMobsBiomeName);
                    continue;
                }
                if (currentDepth > 15) {
                    TerrainControl.log(LogMarker.FATAL, "The biome {} cannot inherit mobs from biome {} - too much configs processed already! Cyclical inheritance?", biomeConfigStub.getFile().getName(), inheritMobsBiomeConfig.getFile().getName());
                }
                if (inheritMobsBiomeConfig == biomeConfigStub) {
                    this.world.mergeVanillaBiomeMobSpawnSettings(biomeConfigStub);
                    continue;
                }
                if (!inheritMobsBiomeConfig.inheritMobsBiomeNameProcessed) {
                    this.processMobInheritance(biomeConfigStubs, inheritMobsBiomeConfig, currentDepth + 1);
                }
                biomeConfigStub.mergeMobs(inheritMobsBiomeConfig);
            }
            biomeConfigStub.inheritMobsBiomeNameProcessed = true;
        }
    }

    private String correctOldBiomeConfigFolder(File settingsDir) {
        String biomeFolderName = "WorldBiomes";
        File oldBiomeConfigs = new File(settingsDir, "BiomeConfigs");
        if (oldBiomeConfigs.exists() && !oldBiomeConfigs.renameTo(new File(settingsDir, biomeFolderName))) {
            TerrainControl.log(LogMarker.WARN, "========================", new Object[0]);
            TerrainControl.log(LogMarker.WARN, "Fould old `BiomeConfigs` folder, but it could not be renamed to `", biomeFolderName, "`!");
            TerrainControl.log(LogMarker.WARN, "Please rename the folder manually.", new Object[0]);
            TerrainControl.log(LogMarker.WARN, "========================", new Object[0]);
            biomeFolderName = "BiomeConfigs";
        }
        return biomeFolderName;
    }

    @Override
    public LocalBiome[] getBiomeArray() {
        return this.biomes;
    }

    @Override
    public CustomObjectCollection getCustomObjects() {
        return this.customObjects;
    }
}

