/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.configuration.io.SettingsMap;
import com.khorn.terraincontrol.configuration.io.SimpleSettingsMap;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ConfigFile {
    private final String configName;

    protected ConfigFile(String configName) {
        this.configName = configName;
    }

    public SettingsMap getSettingsAsMap() {
        SimpleSettingsMap settingsMap = new SimpleSettingsMap(this.configName, false);
        this.writeConfigSettings(settingsMap);
        return settingsMap;
    }

    protected abstract void writeConfigSettings(SettingsMap var1);

    protected abstract void readConfigSettings(SettingsMap var1);

    protected abstract void correctSettings();

    protected abstract void renameOldSettings(SettingsMap var1);

    protected final int higherThanOrEqualTo(int currentValue, int minimumValue) {
        if (currentValue < minimumValue) {
            return minimumValue;
        }
        return currentValue;
    }

    protected final double higherThan(double currentValue, double minimumValue) {
        if (currentValue < minimumValue) {
            return minimumValue;
        }
        return currentValue;
    }

    protected final int lowerThanOrEqualTo(int currentValue, int maximumValue) {
        if (currentValue > maximumValue) {
            return maximumValue;
        }
        return currentValue;
    }

    protected ArrayList<String> filterBiomes(List<String> biomes, Set<String> customBiomes) {
        ArrayList<String> output = new ArrayList<String>();
        for (String key : biomes) {
            if (customBiomes.contains(key = key.trim())) {
                output.add(key);
                continue;
            }
            if (!DefaultBiome.Contain(key)) continue;
            output.add(key);
        }
        return output;
    }

    public static void writeStringToStream(DataOutput stream, String value) throws IOException {
        byte[] bytes = (value == null ? "" : value).getBytes();
        stream.writeShort(bytes.length);
        stream.write(bytes);
    }

    public static String readStringFromStream(DataInputStream stream) throws IOException {
        byte[] chars = new byte[stream.readShort()];
        if (stream.read(chars, 0, chars.length) != chars.length) {
            throw new EOFException();
        }
        return new String(chars);
    }

    public String getName() {
        return this.configName;
    }
}

