/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.metrics;

import com.khorn.terraincontrol.bukkit.TXPlugin;
import com.khorn.terraincontrol.bukkit.metrics.Metrics;
import com.khorn.terraincontrol.util.helpers.MetricsHelper;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BukkitMetricsHelper
extends MetricsHelper {
    private final TXPlugin plugin;

    public BukkitMetricsHelper(TXPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                BukkitMetricsHelper.this.startMetrics();
            }
        }, 100L);
    }

    private void startMetrics() {
        this.calculateBiomeModes(this.plugin.worlds.values());
        try {
            Metrics metrics = new Metrics((Plugin)this.plugin);
            Metrics.Graph usedBiomeModesGraph = metrics.createGraph("Biome modes used");
            usedBiomeModesGraph.addPlotter(new Metrics.Plotter("Normal"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.normalMode;
                }
            });
            usedBiomeModesGraph.addPlotter(new Metrics.Plotter("FromImage"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.fromImageMode;
                }
            });
            usedBiomeModesGraph.addPlotter(new Metrics.Plotter("Default"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.vanillaMode;
                }
            });
            usedBiomeModesGraph.addPlotter(new Metrics.Plotter("BeforeGroups"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.beforeGroupsBiomeMode;
                }
            });
            usedBiomeModesGraph.addPlotter(new Metrics.Plotter("OldGenerator"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.oldBiomeMode;
                }
            });
            usedBiomeModesGraph.addPlotter(new Metrics.Plotter("Custom / Unknown"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.customMode;
                }
            });
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

