/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.generator;

import com.google.common.base.Preconditions;
import com.khorn.terraincontrol.bukkit.BukkitWorld;
import com.khorn.terraincontrol.bukkit.generator.TXChunkGenerator;
import com.khorn.terraincontrol.configuration.WorldConfig;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.World;
import org.bukkit.craftbukkit.v1_10_R1.generator.CustomChunkGenerator;
import org.bukkit.generator.ChunkGenerator;

public class TXInternalChunkGenerator
extends CustomChunkGenerator {
    private final BukkitWorld localWorld;

    public TXInternalChunkGenerator(BukkitWorld world, ChunkGenerator generator) {
        super(world.getWorld(), world.getSeed(), generator);
        Preconditions.checkArgument((boolean)(generator instanceof TXChunkGenerator), (Object)"Generator must be of the plugin");
        this.localWorld = world;
    }

    public BlockPosition findNearestMapFeature(World mcWorld, String type, BlockPosition position) {
        WorldConfig worldConfig = this.localWorld.getConfigs().getWorldConfig();
        if (type.equals("Mineshaft")) {
            if (worldConfig.mineshaftsEnabled) {
                return this.localWorld.mineshaftGen.getNearestGeneratedFeature(mcWorld, position);
            }
        } else if (type.equals("Fortress")) {
            if (worldConfig.netherFortressesEnabled) {
                return this.localWorld.netherFortressGen.getNearestGeneratedFeature(mcWorld, position);
            }
        } else if (type.equals("Monument")) {
            if (worldConfig.oceanMonumentsEnabled) {
                return this.localWorld.oceanMonumentGen.getNearestGeneratedFeature(mcWorld, position);
            }
        } else if (type.equals("OTGTemple")) {
            if (worldConfig.rareBuildingsEnabled) {
                return this.localWorld.rareBuildingGen.getNearestGeneratedFeature(mcWorld, position);
            }
        } else if (type.equals("Stronghold")) {
            if (worldConfig.strongholdsEnabled) {
                return this.localWorld.strongholdGen.getNearestGeneratedFeature(mcWorld, position);
            }
        } else if (type.equals("OTGVillage") && worldConfig.villagesEnabled) {
            return this.localWorld.villageGen.getNearestGeneratedFeature(mcWorld, position);
        }
        return null;
    }
}

