/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.generator;

import com.khorn.terraincontrol.bukkit.BukkitWorld;
import com.khorn.terraincontrol.bukkit.TXPlugin;
import com.khorn.terraincontrol.bukkit.generator.BukkitChunkBuffer;
import com.khorn.terraincontrol.bukkit.generator.TXBlockPopulator;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.generator.ChunkProviderTC;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class TXChunkGenerator
extends ChunkGenerator {
    private ChunkProviderTC chunkProviderTC;
    private ArrayList<BlockPopulator> BlockPopulator = new ArrayList();
    private boolean NotGenerate = false;
    private TXPlugin plugin;

    public TXChunkGenerator(TXPlugin _plugin) {
        this.plugin = _plugin;
    }

    private void makeSureWorldIsInitialized(World world) {
        if (this.chunkProviderTC == null) {
            this.plugin.onWorldInit(world);
        }
    }

    public void onInitialize(BukkitWorld _world) {
        this.chunkProviderTC = new ChunkProviderTC(_world.getConfigs(), _world);
        WorldConfig.TerrainMode mode = _world.getConfigs().getWorldConfig().ModeTerrain;
        if (mode == WorldConfig.TerrainMode.Normal || mode == WorldConfig.TerrainMode.OldGenerator) {
            this.BlockPopulator.add(new TXBlockPopulator(_world));
        }
        if (mode == WorldConfig.TerrainMode.NotGenerate) {
            this.NotGenerate = true;
        }
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        this.makeSureWorldIsInitialized(world);
        return this.BlockPopulator;
    }

    public boolean canSpawn(World world, int x, int z) {
        this.makeSureWorldIsInitialized(world);
        Material material = world.getHighestBlockAt(x, z).getType();
        return material.isSolid();
    }

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        this.makeSureWorldIsInitialized(world);
        ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
        if (this.NotGenerate) {
            return chunkData;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        BukkitChunkBuffer chunkBuffer = new BukkitChunkBuffer(chunkCoord, chunkData);
        this.chunkProviderTC.generate(chunkBuffer);
        return chunkData;
    }
}

