/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.generator;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.bukkit.generator.TXWorldChunkManager;
import com.khorn.terraincontrol.bukkit.util.WorldHelper;
import com.khorn.terraincontrol.generator.biome.OutputType;
import com.khorn.terraincontrol.generator.biome.VanillaBiomeGenerator;
import net.minecraft.server.v1_10_R1.BiomeBase;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.WorldChunkManager;

public class BukkitVanillaBiomeGenerator
extends VanillaBiomeGenerator {
    private BiomeBase[] biomeGenBaseArray;
    private WorldChunkManager worldChunkManager;

    public BukkitVanillaBiomeGenerator(LocalWorld world) {
        super(world);
    }

    public void setWorldChunkManager(WorldChunkManager worldChunkManager) {
        if (worldChunkManager instanceof TXWorldChunkManager) {
            throw new IllegalArgumentException(this.getClass() + " expects a vanilla WorldChunkManager, " + worldChunkManager.getClass() + " given");
        }
        this.worldChunkManager = worldChunkManager;
    }

    @Override
    public int[] getBiomesUnZoomed(int[] biomeArray, int x, int z, int xSize, int zSize, OutputType outputType) {
        this.biomeGenBaseArray = this.worldChunkManager.getBiomes(this.biomeGenBaseArray, x, z, xSize, zSize);
        if (biomeArray == null || biomeArray.length < xSize * zSize) {
            biomeArray = new int[xSize * zSize];
        }
        for (int i = 0; i < xSize * zSize; ++i) {
            biomeArray[i] = WorldHelper.getSavedId(this.biomeGenBaseArray[i]);
        }
        return biomeArray;
    }

    @Override
    public int[] getBiomes(int[] biomeArray, int x, int z, int xSize, int z_size, OutputType outputType) {
        this.biomeGenBaseArray = this.worldChunkManager.a(this.biomeGenBaseArray, x, z, xSize, z_size, true);
        if (biomeArray == null || biomeArray.length < xSize * z_size) {
            biomeArray = new int[xSize * z_size];
        }
        for (int i = 0; i < xSize * z_size; ++i) {
            biomeArray[i] = WorldHelper.getSavedId(this.biomeGenBaseArray[i]);
        }
        return biomeArray;
    }

    @Override
    public int getBiome(int x, int z) {
        return WorldHelper.getSavedId(this.worldChunkManager.getBiome(new BlockPosition(x, 0, z)));
    }

    @Override
    public void cleanupCache() {
        this.worldChunkManager.b();
    }

    @Override
    public boolean canGenerateUnZoomed() {
        return true;
    }
}

