/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.generator;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.bukkit.BukkitMaterialData;
import com.khorn.terraincontrol.generator.ChunkBuffer;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import org.bukkit.generator.ChunkGenerator;

final class BukkitChunkBuffer
implements ChunkBuffer {
    private final ChunkCoordinate chunkCoord;
    private final ChunkGenerator.ChunkData chunkData;

    BukkitChunkBuffer(ChunkCoordinate chunkCoord, ChunkGenerator.ChunkData chunkData) {
        this.chunkCoord = chunkCoord;
        this.chunkData = chunkData;
    }

    @Override
    public LocalMaterialData getBlock(int blockX, int blockY, int blockZ) {
        int blockId = this.chunkData.getTypeId(blockX, blockY, blockZ);
        byte blockData = this.chunkData.getData(blockX, blockY, blockZ);
        return BukkitMaterialData.ofIds(blockId, blockData);
    }

    @Override
    public ChunkCoordinate getChunkCoordinate() {
        return this.chunkCoord;
    }

    @Override
    public void setBlock(int blockX, int blockY, int blockZ, LocalMaterialData material) {
        this.chunkData.setBlock(blockX, blockY, blockZ, material.getBlockId(), material.getBlockData());
    }
}

