/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.events;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.bukkit.TXPlugin;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.configuration.ConfigToNetworkSender;
import com.khorn.terraincontrol.logging.LogMarker;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TCSender {
    private TXPlugin plugin;

    public TCSender(TXPlugin plugin) {
        this.plugin = plugin;
    }

    public void send(Player player) {
        World world = player.getWorld();
        if (this.plugin.worlds.containsKey(world.getName())) {
            LocalWorld localWorld = this.plugin.worlds.get(world.getName());
            ConfigProvider configs = localWorld.getConfigs();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(outputStream);
            try {
                stream.writeInt(5);
                ConfigToNetworkSender.writeConfigsToStream(configs, stream, false);
                stream.flush();
            }
            catch (IOException e) {
                TerrainControl.printStackTrace(LogMarker.FATAL, e);
            }
            byte[] data = outputStream.toByteArray();
            player.sendPluginMessage((Plugin)this.plugin, "OpenTerrainGenerator", data);
        }
    }
}

